/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.Nullable;

public class IgnitionManager {
    @Nullable
    private static Ignition ignition;

    public static CompletableFuture<Ignite> start(String nodeName, @Nullable String configStr, Path workDir) {
        CompletableFuture<Ignite> completableFuture;
        Ignition ignition = IgnitionManager.loadIgnitionService(Thread.currentThread().getContextClassLoader());
        if (configStr == null) {
            return ignition.start(nodeName, workDir);
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(configStr.getBytes(StandardCharsets.UTF_8));
        try {
            completableFuture = ignition.start(nodeName, inputStream, workDir);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IgniteException("Couldn't close the stream with node config.", (Throwable)e);
            }
        }
        ((InputStream)inputStream).close();
        return completableFuture;
    }

    public static CompletableFuture<Ignite> start(String nodeName, @Nullable Path cfgPath, Path workDir, @Nullable ClassLoader clsLdr) {
        Ignition ignition = IgnitionManager.loadIgnitionService(clsLdr);
        return ignition.start(nodeName, cfgPath, workDir, clsLdr);
    }

    public static void stop(String nodeName) {
        Ignition ignition = IgnitionManager.loadIgnitionService(Thread.currentThread().getContextClassLoader());
        ignition.stop(nodeName);
    }

    public static void stop(String nodeName, @Nullable ClassLoader clsLdr) {
        Ignition ignition = IgnitionManager.loadIgnitionService(clsLdr);
        ignition.stop(nodeName);
    }

    public static synchronized void init(String nodeName, Collection<String> metaStorageNodeNames, String clusterName) {
        Objects.requireNonNull(nodeName);
        Objects.requireNonNull(metaStorageNodeNames);
        Objects.requireNonNull(clusterName);
        if (ignition == null) {
            throw new IgniteException("Ignition service has not been started");
        }
        ignition.init(nodeName, metaStorageNodeNames, clusterName);
    }

    public static synchronized void init(String nodeName, Collection<String> metaStorageNodeNames, Collection<String> cmgNodeNames, String clusterName) {
        Objects.requireNonNull(nodeName);
        Objects.requireNonNull(metaStorageNodeNames);
        Objects.requireNonNull(cmgNodeNames);
        Objects.requireNonNull(clusterName);
        if (ignition == null) {
            throw new IgniteException("Ignition service has not been started");
        }
        ignition.init(nodeName, metaStorageNodeNames, cmgNodeNames, clusterName);
    }

    private static synchronized Ignition loadIgnitionService(@Nullable ClassLoader clsLdr) {
        if (ignition == null) {
            ServiceLoader<Ignition> ldr = ServiceLoader.load(Ignition.class, clsLdr);
            ignition = ldr.iterator().next();
        }
        return ignition;
    }
}

