/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.store;

import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.MemoryCalculator;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.PageMetaInfoStore;
import org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker.store.HeapPageMetaInfoStore;
import org.apache.ignite.internal.util.GridUnsafe;
import org.jetbrains.annotations.Nullable;

public class OffHeapPageMetaInfoStore
implements PageMetaInfoStore {
    private static final long OVERHEAD_SIZE = 40L;
    private static final int PAGE_ID_OFFSET = 0;
    private static final int PAGE_HEADER_ADDRESS_OFFSET = 8;
    private static final int PAGE_ADDRESS_OFFSET = 16;
    private static final int PAGE_META_OFFSET = 24;
    private static final int ITEM_SIZE = 4;
    private final int size;
    private final int capacity;
    private final long ptr;
    private final MemoryCalculator memCalc;

    public OffHeapPageMetaInfoStore(int capacity, @Nullable MemoryCalculator memCalc) {
        this.capacity = capacity;
        this.size = this.capacity * 32;
        this.ptr = this.allocate(this.size);
        this.memCalc = memCalc;
        if (memCalc != null) {
            memCalc.onHeapAllocated(40L);
            memCalc.onOffHeapAllocated(this.size);
        }
    }

    private long allocate(int size) {
        long ptr = GridUnsafe.allocateMemory(size);
        GridUnsafe.zeroMemory(ptr, size);
        return ptr;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this.size; ++i) {
            if (GridUnsafe.getByte(this.ptr + (long)i) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(int itemIdx, int op, int structureId, long pageId, long pageAddrHeader, long pageAddr) {
        GridUnsafe.putLong(this.offset(itemIdx) + 0L, pageId);
        GridUnsafe.putLong(this.offset(itemIdx) + 8L, pageAddrHeader);
        GridUnsafe.putLong(this.offset(itemIdx) + 16L, pageAddr);
        GridUnsafe.putLong(this.offset(itemIdx) + 24L, this.join(structureId, op));
    }

    @Override
    public void remove(int itemIdx) {
        GridUnsafe.putLong(this.offset(itemIdx) + 0L, 0L);
        GridUnsafe.putLong(this.offset(itemIdx) + 8L, 0L);
        GridUnsafe.putLong(this.offset(itemIdx) + 16L, 0L);
        GridUnsafe.putLong(this.offset(itemIdx) + 24L, 0L);
    }

    @Override
    public int getOperation(int itemIdx) {
        long structureIdAndOp = GridUnsafe.getLong(this.offset(itemIdx) + 24L);
        return (int)(structureIdAndOp >> 32 & 0xFFL);
    }

    @Override
    public int getStructureId(int itemIdx) {
        long structureIdAndOp = GridUnsafe.getLong(this.offset(itemIdx) + 24L);
        return (int)structureIdAndOp;
    }

    @Override
    public long getPageId(int itemIdx) {
        return GridUnsafe.getLong(this.offset(itemIdx) + 0L);
    }

    @Override
    public long getPageAddrHeader(int itemIdx) {
        return GridUnsafe.getLong(this.offset(itemIdx) + 8L);
    }

    @Override
    public long getPageAddr(int itemIdx) {
        return GridUnsafe.getLong(this.offset(itemIdx) + 16L);
    }

    private long offset(long itemIdx) {
        long offset = this.ptr + itemIdx * 8L * 4L;
        assert (offset >= this.ptr && offset <= this.ptr + (long)this.size - 32L) : "offset=" + (offset - this.ptr) + ", size=" + this.size;
        return offset;
    }

    @Override
    public PageMetaInfoStore copy() {
        long[] arr = new long[this.capacity * 4];
        GridUnsafe.copyMemory(null, this.ptr, arr, GridUnsafe.LONG_ARR_OFF, this.size);
        return new HeapPageMetaInfoStore(arr);
    }

    @Override
    public void free() {
        GridUnsafe.freeMemory(this.ptr);
        if (this.memCalc != null) {
            this.memCalc.onHeapFree(40L);
            this.memCalc.onOffHeapFree(this.size);
        }
    }

    private long join(int structureId, int op) {
        long major = (long)op << 32;
        long minor = (long)structureId & 0xFFFFFFFFL;
        return major | minor;
    }
}

