/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.defragmentation;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class DefragmentationFileUtils {
    private static final String DFRG_LINK_MAPPING_FILE_PREFIX = "part-map-";
    private static final String DFRG_LINK_MAPPING_FILE_TEMPLATE = "part-map-%d.bin";
    private static final String DFRG_COMPLETION_MARKER_FILE_NAME = "dfrg-completion-marker";
    private static final String DFRG_INDEX_FILE_NAME = "index-dfrg.bin";
    private static final String DFRG_INDEX_TMP_FILE_NAME = "index-dfrg.bin.tmp";
    private static final String DFRG_PARTITION_FILE_PREFIX = "part-dfrg-";
    private static final String DFRG_PARTITION_FILE_TEMPLATE = "part-dfrg-%d.bin";
    private static final String DFRG_PARTITION_TMP_FILE_TEMPLATE = "part-dfrg-%d.bin.tmp";

    public static void beforeInitPageStores(File workDir, IgniteLogger log) throws IgniteCheckedException {
        try {
            DefragmentationFileUtils.batchRenameDefragmentedCacheGroupPartitions(workDir, log);
            U.delete(DefragmentationFileUtils.defragmentationCompletionMarkerFile(workDir));
            DefragmentationFileUtils.deleteLeftovers(workDir);
        }
        catch (IgniteException e) {
            throw new IgniteCheckedException(e);
        }
    }

    public static void deleteLeftovers(File workDir) {
        for (File file : workDir.listFiles()) {
            String fileName = file.getName();
            if (!fileName.startsWith(DFRG_PARTITION_FILE_PREFIX) && !fileName.startsWith(DFRG_INDEX_FILE_NAME) && !fileName.startsWith(DFRG_LINK_MAPPING_FILE_PREFIX)) continue;
            U.delete(file);
        }
    }

    public static boolean skipAlreadyDefragmentedCacheGroup(File workDir, int grpId, IgniteLogger log) throws IgniteException {
        File completionMarkerFile = DefragmentationFileUtils.defragmentationCompletionMarkerFile(workDir);
        if (completionMarkerFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info(S.toString("Skipping already defragmented page group", "grpId", (Object)grpId, false, "markerFileName", (Object)completionMarkerFile.getName(), false, "workDir", (Object)workDir.getAbsolutePath(), false));
            }
            DefragmentationFileUtils.batchRenameDefragmentedCacheGroupPartitions(workDir, log);
            return true;
        }
        return false;
    }

    public static boolean skipAlreadyDefragmentedPartition(File workDir, int grpId, int partId, IgniteLogger log) throws IgniteException {
        File defragmentedPartFile = DefragmentationFileUtils.defragmentedPartFile(workDir, partId);
        File defragmentedPartMappingFile = DefragmentationFileUtils.defragmentedPartMappingFile(workDir, partId);
        if (defragmentedPartFile.exists() && defragmentedPartMappingFile.exists()) {
            if (log.isInfoEnabled()) {
                log.info(S.toString("Skipping already defragmented partition", "grpId", (Object)grpId, false, "partId", (Object)partId, false, "partFileName", (Object)defragmentedPartFile.getName(), false, "mappingFileName", (Object)defragmentedPartMappingFile.getName(), false, "workDir", (Object)workDir.getAbsolutePath(), false));
            }
            return true;
        }
        File defragmentedPartTmpFile = DefragmentationFileUtils.defragmentedPartTmpFile(workDir, partId);
        try {
            Files.deleteIfExists(defragmentedPartTmpFile.toPath());
            Files.deleteIfExists(defragmentedPartFile.toPath());
            Files.deleteIfExists(defragmentedPartMappingFile.toPath());
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
        return false;
    }

    public static void batchRenameDefragmentedCacheGroupPartitions(File workDir, IgniteLogger log) throws IgniteException {
        File completionMarkerFile = DefragmentationFileUtils.defragmentationCompletionMarkerFile(workDir);
        if (!completionMarkerFile.exists()) {
            return;
        }
        try {
            for (File mappingFile : workDir.listFiles((dir, name) -> name.startsWith(DFRG_LINK_MAPPING_FILE_PREFIX))) {
                Files.delete(mappingFile.toPath());
            }
            for (File partFile : workDir.listFiles((dir, name) -> name.startsWith(DFRG_PARTITION_FILE_PREFIX))) {
                int partId = DefragmentationFileUtils.extractPartId(partFile.getName());
                File oldPartFile = new File(workDir, String.format("part-%d.bin", partId));
                Files.move(partFile.toPath(), oldPartFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
            File idxFile = new File(workDir, DFRG_INDEX_FILE_NAME);
            if (idxFile.exists()) {
                File oldIdxFile = new File(workDir, "index.bin");
                Files.move(idxFile.toPath(), oldIdxFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    private static int extractPartId(String dfrgPartFileName) {
        assert (dfrgPartFileName.startsWith(DFRG_PARTITION_FILE_PREFIX)) : dfrgPartFileName;
        assert (dfrgPartFileName.endsWith(".bin")) : dfrgPartFileName;
        String partIdStr = dfrgPartFileName.substring(DFRG_PARTITION_FILE_PREFIX.length(), dfrgPartFileName.length() - ".bin".length());
        return Integer.parseInt(partIdStr);
    }

    public static File defragmentedIndexTmpFile(File workDir) {
        return new File(workDir, DFRG_INDEX_TMP_FILE_NAME);
    }

    public static File defragmentedIndexFile(File workDir) {
        return new File(workDir, DFRG_INDEX_FILE_NAME);
    }

    public static void renameTempIndexFile(File workDir) throws IgniteException {
        File defragmentedIdxTmpFile = DefragmentationFileUtils.defragmentedIndexTmpFile(workDir);
        File defragmentedIdxFile = DefragmentationFileUtils.defragmentedIndexFile(workDir);
        try {
            Files.deleteIfExists(defragmentedIdxFile.toPath());
            Files.move(defragmentedIdxTmpFile.toPath(), defragmentedIdxFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    public static File defragmentedPartTmpFile(File workDir, int partId) {
        return new File(workDir, String.format(DFRG_PARTITION_TMP_FILE_TEMPLATE, partId));
    }

    public static File defragmentedPartFile(File workDir, int partId) {
        return new File(workDir, String.format(DFRG_PARTITION_FILE_TEMPLATE, partId));
    }

    public static void renameTempPartitionFile(File workDir, int partId) throws IgniteException {
        File defragmentedPartTmpFile = DefragmentationFileUtils.defragmentedPartTmpFile(workDir, partId);
        File defragmentedPartFile = DefragmentationFileUtils.defragmentedPartFile(workDir, partId);
        assert (!defragmentedPartFile.exists()) : defragmentedPartFile;
        try {
            Files.move(defragmentedPartTmpFile.toPath(), defragmentedPartFile.toPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }

    public static File defragmentedPartMappingFile(File workDir, int partId) {
        return new File(workDir, String.format(DFRG_LINK_MAPPING_FILE_TEMPLATE, partId));
    }

    public static File defragmentationCompletionMarkerFile(File workDir) {
        return new File(workDir, DFRG_COMPLETION_MARKER_FILE_NAME);
    }

    public static void writeDefragmentationCompletionMarker(FileIOFactory ioFactory, File workDir, IgniteLogger log) throws IgniteException {
        File completionMarker = DefragmentationFileUtils.defragmentationCompletionMarkerFile(workDir);
        try (FileIO io = ioFactory.create(completionMarker, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            io.force(true);
        }
        catch (IOException e) {
            throw new IgniteException(e);
        }
    }
}

