/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.implcore.trace.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ConcurrentIntrusiveList<T extends Element<T>> {
    private final int capacity;
    private int size = 0;
    @Nullable
    private T head = null;

    public ConcurrentIntrusiveList(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Capacity needs to be greater than 0.");
        this.capacity = capacity;
    }

    public synchronized boolean addElement(T element) {
        if (element.getNext() != null || element.getPrev() != null || element == this.head || this.size >= this.capacity) {
            return false;
        }
        ++this.size;
        if (this.head == null) {
            this.head = element;
        } else {
            this.head.setPrev(element);
            element.setNext(this.head);
            this.head = element;
        }
        return true;
    }

    public synchronized boolean removeElement(T element) {
        if (element.getNext() == null && element.getPrev() == null && element != this.head) {
            return false;
        }
        --this.size;
        Object prev = element.getPrev();
        Object next = element.getNext();
        if (prev == null) {
            this.head = next;
            if (this.head != null) {
                this.head.setPrev(null);
                element.setNext(null);
            }
        } else if (next == null) {
            prev.setNext(null);
            element.setPrev(null);
        } else {
            prev.setNext(element.getNext());
            next.setPrev(element.getPrev());
            element.setNext(null);
            element.setPrev(null);
        }
        return true;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized void clear() {
        T currentHead;
        while ((currentHead = this.head) != null) {
            this.removeElement(currentHead);
        }
        return;
    }

    public synchronized Collection<T> getAll() {
        ArrayList<T> all = new ArrayList<T>(this.size);
        for (T e = this.head; e != null; e = e.getNext()) {
            all.add(e);
        }
        return all;
    }

    public static interface Element<T extends Element<T>> {
        @Nullable
        public T getNext();

        public void setNext(@Nullable T var1);

        @Nullable
        public T getPrev();

        public void setPrev(@Nullable T var1);
    }
}

