/*
 * Decompiled with CFR 0.152.
 */
package org.yardstickframework;

import org.yardstickframework.BenchmarkConfiguration;
import org.yardstickframework.BenchmarkServer;
import org.yardstickframework.BenchmarkUtils;
import org.yardstickframework.impl.BenchmarkLoader;

public class BenchmarkServerStartUp {
    public static void main(String[] cmdArgs) throws Exception {
        final BenchmarkConfiguration cfg = new BenchmarkConfiguration();
        cfg.commandLineArguments(cmdArgs);
        BenchmarkUtils.jcommander(cmdArgs, cfg, "<benchmark-runner>");
        BenchmarkLoader ldr = new BenchmarkLoader();
        ldr.initialize(cfg);
        String name = cfg.serverName();
        if (name != null) {
            name = name.trim();
        }
        if (name == null || name.isEmpty()) {
            BenchmarkUtils.errorHelp(cfg, "Server class name is not specified.");
            return;
        }
        BenchmarkServer srv = ldr.loadClass(BenchmarkServer.class, name);
        if (srv != null) {
            if (cfg.help()) {
                BenchmarkUtils.println(cfg, srv.usage());
                return;
            }
            try {
                srv.start(cfg);
                final BenchmarkServer srv0 = srv;
                if (cfg.shutdownHook()) {
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            try {
                                srv0.stop();
                            }
                            catch (Exception e) {
                                BenchmarkUtils.errorHelp(cfg, "Exception is raised during server stop.", e);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                BenchmarkUtils.error("Failed to start benchmark server (will stop and exit).", e);
                srv.stop();
            }
        } else {
            BenchmarkUtils.errorHelp(cfg, "Could not find benchmark server class name in classpath: " + name + ".\nMake sure class name is specified correctly and corresponding package is added " + "to -p argument list.");
        }
    }
}

