/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.testng.IMethodSelector;
import org.testng.ITestNGMethod;
import org.testng.internal.DefaultMethodSelectorContext;
import org.testng.internal.MethodSelectorDescriptor;
import org.testng.internal.Utils;
import org.testng.xml.XmlTest;

public class RunInfo {
    private final Set<MethodSelectorDescriptor> m_methodSelectors = new TreeSet<MethodSelectorDescriptor>();
    private final Supplier<XmlTest> xmlTest;

    public RunInfo(Supplier<XmlTest> xmlTest) {
        this.xmlTest = xmlTest;
    }

    public XmlTest getXmlTest() {
        return this.xmlTest.get();
    }

    public void addMethodSelector(IMethodSelector selector, int priority) {
        Utils.log("RunInfo", 3, "Adding method selector: " + String.valueOf(selector) + " priority: " + priority);
        MethodSelectorDescriptor md = new MethodSelectorDescriptor(selector, priority);
        this.m_methodSelectors.add(md);
    }

    public boolean includeMethod(ITestNGMethod tm, boolean isTestMethod) {
        boolean foundNegative = false;
        DefaultMethodSelectorContext context = new DefaultMethodSelectorContext();
        boolean result = false;
        for (MethodSelectorDescriptor mds : this.m_methodSelectors) {
            if (!foundNegative) {
                boolean bl = foundNegative = mds.getPriority() < 0;
            }
            if (foundNegative && mds.getPriority() >= 0) break;
            IMethodSelector md = mds.getMethodSelector();
            result = md.includeMethod(context, tm, isTestMethod);
            if (!context.isStopped()) continue;
            return result;
        }
        return result;
    }

    public void setTestMethods(List<ITestNGMethod> testMethods) {
        for (MethodSelectorDescriptor mds : this.m_methodSelectors) {
            mds.setTestMethods(testMethods);
        }
    }
}

