/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.spring.boot.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.flume.instrumentation.util.JMXPollUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnProperty(prefix="flume", name={"metrics"}, havingValue="http")
public class FlumeMetricsController {
    private final Type mapType = new MapTypeToken().getType();
    private final Gson gson = new Gson();

    @GetMapping(value={"/metrics"}, produces={"application/json;charset=utf-8"})
    public String metrics() {
        Map metricsMap = JMXPollUtil.getAllMBeans();
        return this.gson.toJson((Object)metricsMap, this.mapType);
    }

    private static class MapTypeToken
    extends TypeToken<Map<String, Map<String, String>>> {
        private MapTypeToken() {
        }
    }
}

