/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.dsfactory;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.TorqueException;
import org.apache.torque.dsfactory.AbstractDataSourceFactory;

public class JndiDataSourceFactory
extends AbstractDataSourceFactory {
    public static final String JNDI_KEY = "jndi";
    public static final String PATH_KEY = "path";
    public static final String TIME_BETWEEN_LOOKUPS_KEY = "ttl";
    public static final String DATASOURCE_KEY = "datasource";
    public static final String CLASSNAME_KEY = "classname";
    private static final Logger log = LogManager.getLogger(JndiDataSourceFactory.class);
    private String path;
    private Context ctx;
    private DataSource ds = null;
    private long lastLookup = 0L;
    private long ttl = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws TorqueException {
        long time = System.currentTimeMillis();
        if (this.ds == null || time - this.lastLookup > this.ttl) {
            try {
                Context context = this.ctx;
                synchronized (context) {
                    this.ds = (DataSource)this.ctx.lookup(this.path);
                }
                this.lastLookup = time;
            }
            catch (Exception e) {
                throw new TorqueException(e);
            }
        }
        return this.ds;
    }

    @Override
    public void initialize(Configuration configuration) throws TorqueException {
        this.initJNDI(configuration);
        this.initDataSource(configuration);
    }

    private void initJNDI(Configuration configuration) throws TorqueException {
        log.debug("Starting initJNDI");
        Configuration c = configuration.subset(JNDI_KEY);
        if (c == null || c.isEmpty()) {
            throw new TorqueException("JndiDataSourceFactory requires a jndi path property to lookup the DataSource in JNDI.");
        }
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            Iterator i = c.getKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (key.equals(PATH_KEY)) {
                    this.path = c.getString(key);
                    log.debug("JNDI path: {}", (Object)this.path);
                    continue;
                }
                if (key.equals(TIME_BETWEEN_LOOKUPS_KEY)) {
                    this.ttl = c.getLong(key, this.ttl);
                    log.debug("Time between context lookups: {} ms", (Object)this.ttl);
                    continue;
                }
                String value = c.getString(key);
                env.put(key, value);
                log.debug("Set jndi property: {} = {}", (Object)key, (Object)value);
            }
            this.ctx = new InitialContext(env);
            log.debug("Created new InitialContext");
            this.debugCtx(this.ctx);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new TorqueException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDataSource(Configuration configuration) throws TorqueException {
        block9: {
            log.debug("Starting initDataSource");
            try {
                Object dataSource = null;
                Configuration c = configuration.subset(DATASOURCE_KEY);
                if (c != null) {
                    Iterator i = c.getKeys();
                    while (i.hasNext()) {
                        String key = (String)i.next();
                        if (key.equals(CLASSNAME_KEY)) {
                            String classname = c.getString(key);
                            log.debug("Datasource class: {}", (Object)classname);
                            Class<?> dsClass = Class.forName(classname);
                            dataSource = dsClass.newInstance();
                            continue;
                        }
                        if (dataSource != null) {
                            log.debug("Setting datasource property: {}", (Object)key);
                            this.setProperty(key, c, dataSource);
                            continue;
                        }
                        log.error("Tried to set property {} without Datasource definition!", (Object)key);
                    }
                }
                if (dataSource == null) break block9;
                Context context = this.ctx;
                synchronized (context) {
                    this.bindDStoJndi(this.ctx, this.path, dataSource);
                }
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
                throw new TorqueException(e);
            }
        }
    }

    @Override
    public void close() {
    }

    private void debugCtx(Context ctx) throws NamingException {
        log.debug("InitialContext -------------------------------");
        Hashtable<?, ?> env = ctx.getEnvironment();
        log.debug("Environment properties: {}", (Object)env.size());
        env.forEach((key, value) -> log.debug("    {}: {}", key, value));
        log.debug("----------------------------------------------");
    }

    private void bindDStoJndi(Context ctx, String path, Object ds) throws Exception {
        this.debugCtx(ctx);
        int start = path.indexOf(58) + 1;
        if (start > 0) {
            path = path.substring(start);
        }
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreTokens()) {
            String subctx = st.nextToken();
            if (st.hasMoreTokens()) {
                try {
                    ctx.createSubcontext(subctx);
                    log.debug("Added sub context: {}", (Object)subctx);
                }
                catch (NameAlreadyBoundException nabe) {
                    log.debug("Sub context {} already exists", (Object)subctx);
                }
                catch (NamingException ne) {
                    log.debug("Naming exception caught when creating subcontext {}", (Object)subctx, (Object)ne);
                }
                ctx = (Context)ctx.lookup(subctx);
                continue;
            }
            ctx.bind(subctx, ds);
        }
    }
}

