/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Database;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.adapter.AdapterFactory;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IDGeneratorFactory;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.TransactionManager;
import org.apache.torque.util.TransactionManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TorqueInstance {
    private static Log log = LogFactory.getLog(TorqueInstance.class);
    private static final String DEFAULT_NAME = "default";
    private String defaultDBName = null;
    private final Map<String, Database> databases = Collections.synchronizedMap(new HashMap());
    private Map<String, AbstractBaseManager<?>> managers;
    private final Set<IDBroker> idBrokers = new HashSet<IDBroker>();
    private Configuration conf;
    private boolean isInit = false;
    private boolean defaultDsfIsReference = false;

    public TorqueInstance() {
        this.resetConfiguration();
    }

    private synchronized void initialize() throws TorqueException {
        log.debug((Object)"initialize()");
        if (this.isInit) {
            throw new TorqueException("Multiple initializations of Torque attempted");
        }
        if (this.conf == null || this.conf.isEmpty()) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        this.initTransactionManager(this.conf);
        this.initDefaultDbName(this.conf);
        this.initDataSourceFactories(this.conf);
        this.initSchemata(this.conf);
        this.initAdapters(this.conf);
        Database defaultDatabase = this.databases.get(this.defaultDBName);
        Database databaseInfoForKeyDefault = this.getOrCreateDatabase(DEFAULT_NAME);
        if (!this.defaultDBName.equals(DEFAULT_NAME) && databaseInfoForKeyDefault.getDataSourceFactory() == null) {
            log.debug((Object)("Adding the DatasourceFactory and DatabaseAdapter from database " + this.defaultDBName + " onto database " + DEFAULT_NAME));
            databaseInfoForKeyDefault.setDataSourceFactory(defaultDatabase.getDataSourceFactory());
            databaseInfoForKeyDefault.setAdapter(defaultDatabase.getAdapter());
            this.defaultDsfIsReference = true;
        }
        this.initManagerMappings(this.conf);
        this.startIdBrokers();
        this.isInit = true;
    }

    private void initTransactionManager(Configuration conf) throws TorqueException {
        TransactionManager transactionManager;
        log.debug((Object)("initTransactionManager(" + conf + ")"));
        String transactionManagerClassName = conf.getString("transactionManager");
        if (StringUtils.isEmpty((String)transactionManagerClassName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Configuration key torque.transactionManager not set, using default transaction manager " + TransactionManagerImpl.class.getName()));
            }
            transactionManager = new TransactionManagerImpl();
        } else {
            try {
                Class<?> transactionManagerClass = Class.forName(transactionManagerClassName);
                transactionManager = (TransactionManager)transactionManagerClass.newInstance();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Using transaction manager " + transactionManager.getClass().getName()));
                }
            }
            catch (Exception e) {
                log.error((Object)"Error handling transaction manager configuration", (Throwable)e);
                throw new TorqueException(e);
            }
        }
        Transaction.setTransactionManager(transactionManager);
    }

    private void initDefaultDbName(Configuration conf) throws TorqueException {
        log.debug((Object)("initDefaultDbName(" + conf + ")"));
        this.defaultDBName = conf.getString("database.default");
        if (this.defaultDBName == null) {
            String error = "Invalid configuration: Key torque.database.default not set";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAdapters(Configuration conf) throws TorqueException {
        log.debug((Object)("initAdapters(" + conf + ")"));
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration : No keys starting with torque.database found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("adapter") && !key.endsWith("driver")) continue;
                String adapterKey = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                Database database = this.getOrCreateDatabase(handle);
                Adapter adapter = null;
                if (StringUtils.equals((String)"auto", (String)adapterKey)) {
                    Connection con = null;
                    try {
                        con = database.getDataSourceFactory().getDataSource().getConnection();
                        adapter = AdapterFactory.autoDetectAdapter(con);
                    }
                    catch (SQLException e) {
                        log.error((Object)"Could not get product information from JDBC", (Throwable)e);
                    }
                    finally {
                        this.closeConnection(con);
                    }
                } else {
                    adapter = AdapterFactory.create(adapterKey);
                }
                if (adapter == null) {
                    String adapterClassName = c.getString(key + "." + adapterKey + ".className", null);
                    adapter = AdapterFactory.create(adapterKey, adapterClassName);
                }
                database.setAdapter(adapter);
                log.debug((Object)("Adding " + adapterKey + " -> " + handle + " as Adapter"));
                for (IDMethod idMethod : IDGeneratorFactory.ID_GENERATOR_METHODS) {
                    database.addIdGenerator(idMethod, IDGeneratorFactory.create(adapter, handle));
                }
            }
        }
        catch (InstantiationException e) {
            log.error((Object)"Error creating a database adapter instance", (Throwable)e);
            throw new TorqueException(e);
        }
        Database defaultDatabase = this.databases.get(this.getDefaultDB());
        if (defaultDatabase == null || defaultDatabase.getAdapter() == null) {
            String error = "Invalid configuration : No adapter definition found for default DB An adapter must be defined under torque.database." + this.getDefaultDB() + "." + "adapter";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private void initDataSourceFactories(Configuration conf) throws TorqueException {
        log.debug((Object)("initDataSourceFactories(" + conf + ")"));
        Configuration c = conf.subset("dsfactory");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.dsfactory found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.endsWith("factory")) continue;
                String classname = c.getString(key);
                String handle = key.substring(0, key.indexOf(46));
                log.debug((Object)("handle: " + handle + " DataSourceFactory: " + classname));
                Class<?> dsfClass = Class.forName(classname);
                DataSourceFactory dsf = (DataSourceFactory)dsfClass.newInstance();
                Configuration subConf = c.subset(handle);
                dsf.initialize(subConf);
                Database database = this.getOrCreateDatabase(handle);
                database.setDataSourceFactory(dsf);
                String schema = subConf.getString("schema", null);
                if (!StringUtils.isEmpty((String)schema)) {
                    log.warn((Object)"Defining the schema in the dsfactory is deprecated, please configure it via the config key torque.database.${databasename}.schema");
                }
                database.setSchema(schema);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueRuntimeException(e);
        }
        catch (Exception e) {
            log.error((Object)"Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueException(e);
        }
        Database defaultDatabase = this.databases.get(this.defaultDBName);
        if (defaultDatabase == null || defaultDatabase.getDataSourceFactory() == null) {
            String error = "Invalid configuration : No DataSourceFactory definition for default DB found. A DataSourceFactory must be defined under the keytorque.dsfactory." + this.defaultDBName + "." + "factory";
            log.error((Object)error);
            throw new TorqueException(error);
        }
    }

    private void initSchemata(Configuration conf) throws TorqueException {
        log.debug((Object)("initSchemata(" + conf + ")"));
        Configuration c = conf.subset("database");
        if (c == null || c.isEmpty()) {
            String error = "Invalid configuration: No keys starting with torque.database found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        try {
            Iterator it = c.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                int indexOfDot = key.indexOf(46);
                if (indexOfDot == -1) continue;
                String handle = key.substring(0, indexOfDot);
                log.debug((Object)("database handle: " + handle));
                Configuration subConf = c.subset(handle);
                Database database = this.getOrCreateDatabase(handle);
                String schema = subConf.getString("schema", null);
                if (StringUtils.isEmpty((String)schema)) {
                    schema = database.getSchema();
                }
                if (StringUtils.isEmpty((String)schema)) {
                    schema = conf.getString("defaults.schema", null);
                }
                database.setSchema(schema);
            }
        }
        catch (RuntimeException e) {
            log.error((Object)"Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueRuntimeException(e);
        }
        catch (Exception e) {
            log.error((Object)"Error reading DataSourceFactory configuration", (Throwable)e);
            throw new TorqueException(e);
        }
    }

    public void init(String configFile) throws TorqueException {
        log.debug((Object)("init(" + configFile + ")"));
        try {
            PropertiesConfiguration configuration = new PropertiesConfiguration(configFile);
            log.debug((Object)("Config Object is " + configuration));
            this.init((Configuration)configuration);
        }
        catch (ConfigurationException e) {
            throw new TorqueException(e);
        }
    }

    public synchronized void init(Configuration conf) throws TorqueException {
        log.debug((Object)("init(" + conf + ")"));
        this.setConfiguration(conf);
        this.initialize();
    }

    protected synchronized void initManagerMappings(Configuration conf) throws TorqueException {
        int pref = "managed_class.".length();
        int suff = ".manager".length();
        Iterator it = conf.getKeys();
        while (it.hasNext()) {
            String managedClassKey;
            String key = (String)it.next();
            if (!key.startsWith("managed_class.") || !key.endsWith(".manager") || this.managers.containsKey(managedClassKey = key.substring(pref, key.length() - suff))) continue;
            String managerClass = conf.getString(key);
            log.info((Object)("Added Manager for Class: " + managedClassKey + " -> " + managerClass));
            try {
                this.initManager(managedClassKey, managerClass);
            }
            catch (TorqueException e) {
                log.error((Object)"", (Throwable)e);
                e.printStackTrace();
                throw e;
            }
        }
    }

    private synchronized void initManager(String name, String className) throws TorqueException {
        AbstractBaseManager manager = this.managers.get(name);
        if (manager == null && className != null && className.length() != 0) {
            try {
                manager = (AbstractBaseManager)Class.forName(className).newInstance();
                this.managers.put(name, manager);
            }
            catch (Exception e) {
                throw new TorqueException("Could not instantiate manager associated with class: " + name, e);
            }
        }
    }

    private void startIdBrokers() {
        for (IDBroker idBroker : this.idBrokers) {
            idBroker.start();
        }
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void setConfiguration(Configuration conf) throws TorqueException {
        log.debug((Object)("setConfiguration(" + conf + ")"));
        Configuration subConf = conf.subset("torque");
        if (subConf == null || subConf.isEmpty()) {
            String error = "Invalid configuration. No keys starting with torque found in configuration";
            log.error((Object)error);
            throw new TorqueException(error);
        }
        this.conf = subConf;
    }

    public Configuration getConfiguration() {
        log.debug((Object)("getConfiguration() = " + this.conf));
        return this.conf;
    }

    public <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name) {
        AbstractBaseManager<?> m = this.managers.get(name);
        if (m == null) {
            log.error((Object)("No configured manager for key " + name + "."));
        }
        return (T)m;
    }

    public <T extends AbstractBaseManager<? extends Persistent>> T getManager(String name, String defaultClassName) {
        AbstractBaseManager<?> m = this.managers.get(name);
        if (m == null) {
            log.debug((Object)("Added late Manager mapping for Class: " + name + " -> " + defaultClassName));
            try {
                this.initManager(name, defaultClassName);
            }
            catch (TorqueException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            m = this.managers.get(name);
        }
        return (T)m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws TorqueException {
        for (IDBroker idBroker : this.idBrokers) {
            idBroker.stop();
        }
        Iterator<Map.Entry<String, AbstractBaseManager<?>>> it = this.managers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, AbstractBaseManager<?>> mentry = it.next();
            AbstractBaseManager<?> manager = mentry.getValue();
            manager.dispose();
            it.remove();
        }
        TorqueException exception = null;
        Map<String, Database> map = this.databases;
        synchronized (map) {
            for (Map.Entry<String, Database> databaseMapEntry : this.databases.entrySet()) {
                String databaseKey = databaseMapEntry.getKey();
                Database database = databaseMapEntry.getValue();
                if (DEFAULT_NAME.equals(databaseKey) && this.defaultDsfIsReference) {
                    database.setDataSourceFactory(null);
                    continue;
                }
                try {
                    DataSourceFactory dataSourceFactory = database.getDataSourceFactory();
                    if (dataSourceFactory == null) continue;
                    dataSourceFactory.close();
                    database.setDataSourceFactory(null);
                }
                catch (TorqueException e) {
                    log.error((Object)("Error while closing the DataSourceFactory " + databaseKey), (Throwable)e);
                    if (exception != null) continue;
                    exception = e;
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        this.resetConfiguration();
    }

    private void resetConfiguration() {
        this.managers = new HashMap();
        this.isInit = false;
    }

    public DatabaseMap getDatabaseMap() throws TorqueException {
        String name = this.getDefaultDB();
        if (name == null) {
            throw new TorqueException("Torque is not initialized");
        }
        return this.getDatabaseMap(this.getDefaultDB());
    }

    public DatabaseMap getDatabaseMap(String name) throws TorqueException {
        if (name == null) {
            if (!Torque.isInit()) {
                throw new TorqueException("Torque is not initialized");
            }
            name = this.getDefaultDB();
        }
        Database database = this.getOrCreateDatabase(name);
        return database.getDatabaseMap();
    }

    public void registerIDBroker(IDBroker idBroker) {
        this.idBrokers.add(idBroker);
        if (this.isInit()) {
            idBroker.start();
        }
    }

    public Connection getConnection() throws TorqueException {
        return this.getConnection(this.getDefaultDB());
    }

    public Connection getConnection(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        try {
            return this.getDatabase(name).getDataSourceFactory().getDataSource().getConnection();
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    public DataSourceFactory getDataSourceFactory(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        Database database = this.getDatabase(name);
        DataSourceFactory dsf = null;
        if (database != null) {
            dsf = database.getDataSourceFactory();
        }
        if (dsf == null) {
            throw new TorqueException("There was no DataSourceFactory configured for the connection " + name);
        }
        return dsf;
    }

    public Connection getConnection(String name, String username, String password) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        try {
            return this.getDataSourceFactory(name).getDataSource().getConnection(username, password);
        }
        catch (SQLException se) {
            throw new TorqueException(se);
        }
    }

    @Deprecated
    public Adapter getDB(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getAdapter();
    }

    public Adapter getAdapter(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getAdapter();
    }

    public String getDefaultDB() {
        return this.defaultDBName;
    }

    public void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                log.error((Object)"Error occured while closing connection.", (Throwable)e);
            }
        }
    }

    public void setSchema(String name, String schema) {
        this.getOrCreateDatabase(name).setSchema(schema);
    }

    public String getSchema(String name) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized");
        }
        Database database = this.getDatabase(name);
        if (database == null) {
            return null;
        }
        return database.getSchema();
    }

    public Database getDatabase(String databaseName) throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
        if (databaseName == null) {
            databaseName = this.getDefaultDB();
        }
        return this.databases.get(databaseName);
    }

    public Map<String, Database> getDatabases() throws TorqueException {
        if (!this.isInit()) {
            throw new TorqueException("Torque is not initialized.");
        }
        return Collections.unmodifiableMap(this.databases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database getOrCreateDatabase(String databaseName) {
        if (databaseName == null) {
            throw new NullPointerException("databaseName is null");
        }
        Map<String, Database> map = this.databases;
        synchronized (map) {
            Database result = this.databases.get(databaseName);
            if (result == null) {
                result = new Database(databaseName);
                this.databases.put(databaseName, result);
            }
            return result;
        }
    }
}

