/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.Enum64;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.Month;
import org.apache.commons.lang3.TooMany;
import org.apache.commons.lang3.Traffic;
import org.apache.commons.lang3.Traffic2;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnumUtilsTest
extends AbstractLangTest {
    EnumUtilsTest() {
    }

    private void assertArrayEquals(long[] actual, long ... expected) {
        Assertions.assertArrayEquals((long[])expected, (long[])actual);
    }

    @Test
    void testConstructable() {
        new EnumUtils();
    }

    @Test
    void testGenerateBitVector() {
        Assertions.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.noneOf(Traffic.class)));
        Assertions.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED)));
        Assertions.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER)));
        Assertions.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.GREEN)));
        Assertions.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)));
        Assertions.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)));
        Assertions.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)));
        Assertions.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A31)));
        Assertions.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A32)));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, EnumSet.of(Enum64.A63)));
    }

    @Test
    void testGenerateBitVector_longClass() {
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVector(TooMany.class, EnumSet.of(TooMany.A1)));
    }

    @Test
    void testGenerateBitVector_longClassWithArray() {
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVector(TooMany.class, (Enum[])new TooMany[]{TooMany.A1}));
    }

    @Test
    void testGenerateBitVector_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVector((Class)rawType, (Iterable)rawList));
    }

    @Test
    void testGenerateBitVector_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVector((Class)rawType, (Enum[])new Enum[0]));
    }

    @Test
    void testGenerateBitVector_nullArray() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVector(Traffic.class, (Enum[])null));
    }

    @Test
    void testGenerateBitVector_nullArrayElement() {
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null}));
    }

    @Test
    void testGenerateBitVector_nullClass() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVector(null, EnumSet.of(Traffic.RED)));
    }

    @Test
    void testGenerateBitVector_nullClassWithArray() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVector(null, (Enum[])new Traffic[]{Traffic.RED}));
    }

    @Test
    void testGenerateBitVector_nullElement() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVector(Traffic.class, Arrays.asList(Traffic.RED, null)));
    }

    @Test
    void testGenerateBitVector_nullIterable() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVector(Traffic.class, (Iterable)null));
    }

    @Test
    void testGenerateBitVectorFromArray() {
        Assertions.assertEquals((long)0L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[0]));
        Assertions.assertEquals((long)1L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}));
        Assertions.assertEquals((long)2L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}));
        Assertions.assertEquals((long)4L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}));
        Assertions.assertEquals((long)3L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}));
        Assertions.assertEquals((long)5L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}));
        Assertions.assertEquals((long)6L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}));
        Assertions.assertEquals((long)7L, (long)EnumUtils.generateBitVector(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}));
        Assertions.assertEquals((long)0x80000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}));
        Assertions.assertEquals((long)0x100000000L, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
        Assertions.assertEquals((long)Long.MIN_VALUE, (long)EnumUtils.generateBitVector(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}));
    }

    @Test
    void testGenerateBitVectors() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.noneOf(Traffic.class)), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED)), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER)), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.GREEN)), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER)), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.GREEN)), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.AMBER, Traffic.GREEN)), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN)), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A31)), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A32)), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, EnumSet.of(Enum64.A63)), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.M2)), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, EnumSet.of(TooMany.L2, TooMany.M2)), 1L, Long.MIN_VALUE);
    }

    @Test
    void testGenerateBitVectors_nonEnumClass() {
        Class<Object> rawType = Object.class;
        ArrayList rawList = new ArrayList();
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVectors((Class)rawType, (Iterable)rawList));
    }

    @Test
    void testGenerateBitVectors_nonEnumClassWithArray() {
        Class<Object> rawType = Object.class;
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVectors((Class)rawType, (Enum[])new Enum[0]));
    }

    @Test
    void testGenerateBitVectors_nullArray() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVectors(Traffic.class, (Enum[])null));
    }

    @Test
    void testGenerateBitVectors_nullArrayElement() {
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, null}));
    }

    @Test
    void testGenerateBitVectors_nullClass() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVectors(null, EnumSet.of(Traffic.RED)));
    }

    @Test
    void testGenerateBitVectors_nullClassWithArray() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVectors(null, (Enum[])new Traffic[]{Traffic.RED}));
    }

    @Test
    void testGenerateBitVectors_nullElement() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVectors(Traffic.class, Arrays.asList(Traffic.RED, null)));
    }

    @Test
    void testGenerateBitVectors_nullIterable() {
        LangAssertions.assertNullPointerException(() -> EnumUtils.generateBitVectors(null, (Iterable)null));
    }

    @Test
    void testGenerateBitVectorsFromArray() {
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[0]), 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED}), 1L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER}), 2L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.GREEN}), 4L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER}), 3L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.GREEN}), 5L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.AMBER, Traffic.GREEN}), 6L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Traffic.class, (Enum[])new Traffic[]{Traffic.RED, Traffic.AMBER, Traffic.GREEN, Traffic.GREEN}), 7L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A31}), 0x80000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A32}), 0x100000000L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(Enum64.class, (Enum[])new Enum64[]{Enum64.A63}), Long.MIN_VALUE);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.M2}), 1L, 0L);
        this.assertArrayEquals(EnumUtils.generateBitVectors(TooMany.class, (Enum[])new TooMany[]{TooMany.L2, TooMany.M2}), 1L, Long.MIN_VALUE);
    }

    @Test
    void testGetEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN"));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE"));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, null));
    }

    @Test
    void testGetEnum_defaultEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"RED", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"AMBER", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"GREEN", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnum(Traffic.class, null, (Enum)Traffic.RED));
        Assertions.assertNull((Object)EnumUtils.getEnum(Traffic.class, (String)"PURPLE", null));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnum(null, (String)"RED", (Enum)Traffic.AMBER));
    }

    @Test
    void testGetEnum_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assertions.assertNull((Object)EnumUtils.getEnum(rawType, (String)"rawType"));
    }

    @Test
    void testGetEnum_nullClass() {
        Assertions.assertNull((Object)EnumUtils.getEnum((Class)null, (String)"PURPLE"));
    }

    @Test
    void testGetEnumIgnoreCase() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"red"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null));
    }

    @Test
    void testGetEnumIgnoreCase_defaultEnum() {
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"red", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"Amber", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"grEEn", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"PURPLE", (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"purple", (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"pUrPlE", (Enum)Traffic.RED));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumIgnoreCase(Traffic.class, null, (Enum)Traffic.RED));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(Traffic.class, (String)"PURPLE", null));
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(null, (String)"PURPLE", null));
    }

    @Test
    void testGetEnumIgnoreCase_nonEnumClass() {
        Class<Object> rawType = Object.class;
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase(rawType, (String)"rawType"));
    }

    @Test
    void testGetEnumIgnoreCase_nullClass() {
        Assertions.assertNull((Object)EnumUtils.getEnumIgnoreCase((Class)null, (String)"PURPLE"));
    }

    @Test
    void testGetEnumList() {
        List test = EnumUtils.getEnumList(Traffic.class);
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertEquals((Object)((Object)Traffic.RED), test.get(0));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), test.get(1));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), test.get(2));
    }

    @Test
    void testGetEnumMap() {
        Map test = EnumUtils.getEnumMap(Traffic.class);
        HashMap<String, Traffic> expected = new HashMap<String, Traffic>();
        expected.put("RED", Traffic.RED);
        expected.put("AMBER", Traffic.AMBER);
        expected.put("GREEN", Traffic.GREEN);
        Assertions.assertEquals(expected, (Object)test, (String)"getEnumMap not created correctly");
        Assertions.assertEquals((int)3, (int)test.size());
        Assertions.assertTrue((boolean)test.containsKey("RED"));
        Assertions.assertEquals((Object)((Object)Traffic.RED), test.get("RED"));
        Assertions.assertTrue((boolean)test.containsKey("AMBER"));
        Assertions.assertEquals((Object)((Object)Traffic.AMBER), test.get("AMBER"));
        Assertions.assertTrue((boolean)test.containsKey("GREEN"));
        Assertions.assertEquals((Object)((Object)Traffic.GREEN), test.get("GREEN"));
        Assertions.assertFalse((boolean)test.containsKey("PURPLE"));
    }

    @Test
    void testGetEnumMap_keyFunction() {
        Map test = EnumUtils.getEnumMap(Month.class, Month::getId);
        HashMap<Integer, Month> expected = new HashMap<Integer, Month>();
        expected.put(1, Month.JAN);
        expected.put(2, Month.FEB);
        expected.put(3, Month.MAR);
        expected.put(4, Month.APR);
        expected.put(5, Month.MAY);
        expected.put(6, Month.JUN);
        expected.put(7, Month.JUL);
        expected.put(8, Month.AUG);
        expected.put(9, Month.SEP);
        expected.put(10, Month.OCT);
        expected.put(11, Month.NOV);
        expected.put(12, Month.DEC);
        Assertions.assertEquals(expected, (Object)test, (String)"getEnumMap not created correctly");
        Assertions.assertEquals((int)12, (int)test.size());
        Assertions.assertFalse((boolean)test.containsKey(0));
        Assertions.assertTrue((boolean)test.containsKey(1));
        Assertions.assertEquals((Object)((Object)Month.JAN), test.get(1));
        Assertions.assertTrue((boolean)test.containsKey(2));
        Assertions.assertEquals((Object)((Object)Month.FEB), test.get(2));
        Assertions.assertTrue((boolean)test.containsKey(3));
        Assertions.assertEquals((Object)((Object)Month.MAR), test.get(3));
        Assertions.assertTrue((boolean)test.containsKey(4));
        Assertions.assertEquals((Object)((Object)Month.APR), test.get(4));
        Assertions.assertTrue((boolean)test.containsKey(5));
        Assertions.assertEquals((Object)((Object)Month.MAY), test.get(5));
        Assertions.assertTrue((boolean)test.containsKey(6));
        Assertions.assertEquals((Object)((Object)Month.JUN), test.get(6));
        Assertions.assertTrue((boolean)test.containsKey(7));
        Assertions.assertEquals((Object)((Object)Month.JUL), test.get(7));
        Assertions.assertTrue((boolean)test.containsKey(8));
        Assertions.assertEquals((Object)((Object)Month.AUG), test.get(8));
        Assertions.assertTrue((boolean)test.containsKey(9));
        Assertions.assertEquals((Object)((Object)Month.SEP), test.get(9));
        Assertions.assertTrue((boolean)test.containsKey(10));
        Assertions.assertEquals((Object)((Object)Month.OCT), test.get(10));
        Assertions.assertTrue((boolean)test.containsKey(11));
        Assertions.assertEquals((Object)((Object)Month.NOV), test.get(11));
        Assertions.assertTrue((boolean)test.containsKey(12));
        Assertions.assertEquals((Object)((Object)Month.DEC), test.get(12));
        Assertions.assertFalse((boolean)test.containsKey(13));
    }

    @Test
    void testGetEnumSystemProperty() {
        String key = this.getClass().getName();
        System.setProperty(key, Traffic.RED.toString());
        try {
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, (String)key, null));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, (String)"?", (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(null, null, (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(null, (String)"?", (Enum)Traffic.RED));
            Assertions.assertEquals((Object)((Object)Traffic.RED), (Object)EnumUtils.getEnumSystemProperty(Traffic.class, null, (Enum)Traffic.RED));
        }
        finally {
            System.getProperties().remove(key);
        }
    }

    @Test
    void testGetFirstEnumIgnoreCase_defaultEnum() {
        Function<Traffic2, String> f = Traffic2::getLabel;
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"***red***", f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"**Amber**", f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"*grEEn*", f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"PURPLE", f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"purple", f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"pUrPlE", f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, null, f, (Enum)Traffic2.RED));
        Assertions.assertNull((Object)EnumUtils.getFirstEnumIgnoreCase(Traffic2.class, (String)"PURPLE", f, null));
        Assertions.assertNull((Object)EnumUtils.getFirstEnumIgnoreCase(null, (String)"PURPLE", f, null));
    }

    @Test
    void testGetFirstEnumToIntFunction() {
        ToIntFunction<Traffic2> f = Traffic2::getValue;
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)1, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)2, f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)3, f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)4, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)5, f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)6, f, (Enum)Traffic2.RED));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)0, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.GREEN), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)-1, f, (Enum)Traffic2.GREEN));
        Assertions.assertEquals((Object)((Object)Traffic2.RED), (Object)EnumUtils.getFirstEnum(Traffic2.class, (int)0, f, (Enum)Traffic2.RED));
        Assertions.assertNull((Object)EnumUtils.getFirstEnum(Traffic2.class, (int)7, f, null));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnum(null, (int)1, f, (Enum)Traffic2.AMBER));
        Assertions.assertEquals((Object)((Object)Traffic2.AMBER), (Object)EnumUtils.getFirstEnum(String.class, (int)1, f, (Enum)Traffic2.AMBER));
    }

    @Test
    void testIsValidEnum() {
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"RED"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"AMBER"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"GREEN"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, (String)"PURPLE"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnum(Traffic.class, null));
    }

    @Test
    void testIsValidEnum_nullClass() {
        Assertions.assertFalse((boolean)EnumUtils.isValidEnum(null, (String)"PURPLE"));
    }

    @Test
    void testIsValidEnumIgnoreCase() {
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"red"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"Amber"));
        Assertions.assertTrue((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"grEEn"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, (String)"purple"));
        Assertions.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(Traffic.class, null));
    }

    @Test
    void testIsValidEnumIgnoreCase_nullClass() {
        Assertions.assertFalse((boolean)EnumUtils.isValidEnumIgnoreCase(null, (String)"PURPLE"));
    }

    @Test
    void testProcessBitVector() {
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVector(Traffic.class, (long)0L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVector(Traffic.class, (long)1L));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)2L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVector(Traffic.class, (long)3L));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)4L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)5L));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)6L));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVector(Traffic.class, (long)7L));
        Assertions.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x80000000L));
        Assertions.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVector(Enum64.class, (long)0x100000000L));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVector(Enum64.class, (long)Long.MIN_VALUE));
    }

    @Test
    void testProcessBitVector_longClass() {
        LangAssertions.assertIllegalArgumentException(() -> EnumUtils.processBitVector(TooMany.class, (long)0L));
    }

    @Test
    void testProcessBitVector_nullClass() {
        Class empty = null;
        LangAssertions.assertNullPointerException(() -> EnumUtils.processBitVector((Class)empty, (long)0L));
    }

    @Test
    void testProcessBitVectors() {
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{7L}));
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.noneOf(Traffic.class), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 0L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 1L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 2L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 3L}));
        Assertions.assertEquals(EnumSet.of(Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 4L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 5L}));
        Assertions.assertEquals(EnumSet.of(Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 6L}));
        Assertions.assertEquals(EnumSet.of(Traffic.RED, Traffic.AMBER, Traffic.GREEN), (Object)EnumUtils.processBitVectors(Traffic.class, (long[])new long[]{666L, 7L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A31), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x80000000L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A32), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{0x100000000L}));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
        Assertions.assertEquals(EnumSet.of(Enum64.A63), (Object)EnumUtils.processBitVectors(Enum64.class, (long[])new long[]{Long.MIN_VALUE}));
    }

    @Test
    void testProcessBitVectors_longClass() {
        Assertions.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{7L}));
        Assertions.assertEquals(EnumSet.noneOf(TooMany.class), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{0L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{1L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 0L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 1L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 2L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 3L}));
        Assertions.assertEquals(EnumSet.of(TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 4L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 5L}));
        Assertions.assertEquals(EnumSet.of(TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 6L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
        Assertions.assertEquals(EnumSet.of(TooMany.A, TooMany.B, TooMany.C, TooMany.M2), (Object)EnumUtils.processBitVectors(TooMany.class, (long[])new long[]{9L, 7L}));
    }

    @Test
    void testProcessBitVectors_nullClass() {
        Class empty = null;
        LangAssertions.assertNullPointerException(() -> EnumUtils.processBitVectors((Class)empty, (long[])new long[]{0L}));
    }

    @Test
    void testStream() {
        Assertions.assertEquals((long)7L, (long)EnumUtils.stream(TimeUnit.class).count());
        Assertions.assertArrayEquals((Object[])TimeUnit.values(), (Object[])EnumUtils.stream(TimeUnit.class).toArray(TimeUnit[]::new));
        Assertions.assertEquals((long)0L, (long)EnumUtils.stream(Object.class).count());
        Assertions.assertEquals((long)0L, (long)EnumUtils.stream(null).count());
    }
}

