/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.AbstractExceptionContextTest;
import org.apache.commons.lang3.exception.ContextedException;
import org.apache.commons.lang3.exception.DefaultExceptionContext;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ContextedExceptionTest
extends AbstractExceptionContextTest<ContextedException> {
    ContextedExceptionTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        super.setUp();
    }

    @Test
    void testContextedException() {
        this.exceptionContext = new ContextedException();
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assertions.assertTrue((boolean)trace.contains("ContextedException"));
        Assertions.assertTrue((boolean)StringUtils.isEmpty((CharSequence)message));
    }

    @Test
    void testContextedExceptionString() {
        this.exceptionContext = new ContextedException("Test Message");
        Assertions.assertEquals((Object)"Test Message", (Object)((ContextedException)this.exceptionContext).getMessage());
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assertions.assertTrue((boolean)trace.contains("Test Message"));
    }

    @Test
    void testContextedExceptionStringThrowable() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assertions.assertTrue((boolean)trace.contains("ContextedException"));
        Assertions.assertTrue((boolean)trace.contains("Test Message"));
        Assertions.assertTrue((boolean)trace.contains("This is monotonous"));
        Assertions.assertTrue((boolean)message.contains("This is monotonous"));
    }

    @Test
    void testContextedExceptionStringThrowableContext() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assertions.assertTrue((boolean)trace.contains("ContextedException"));
        Assertions.assertTrue((boolean)trace.contains("Test Message"));
        Assertions.assertTrue((boolean)trace.contains("This is monotonous"));
        Assertions.assertTrue((boolean)message.contains("This is monotonous"));
    }

    @Test
    void testContextedExceptionThrowable() {
        this.exceptionContext = new ContextedException((Throwable)new Exception("Test Message"));
        String message = ((ContextedException)this.exceptionContext).getMessage();
        String trace = ExceptionUtils.getStackTrace((Throwable)((Throwable)this.exceptionContext));
        Assertions.assertTrue((boolean)trace.contains("ContextedException"));
        Assertions.assertTrue((boolean)trace.contains("Test Message"));
        Assertions.assertTrue((boolean)message.contains("Test Message"));
    }

    @Test
    void testNullException() {
        Assertions.assertEquals((Object)"", (Object)ExceptionUtils.getStackTrace(null), (String)"Empty response.");
    }

    @Test
    void testNullExceptionPassing() {
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), null).addContextValue("test1", null).addContextValue("test2", (Object)"some value").addContextValue("test Date", (Object)new Date()).addContextValue("test Nbr", (Object)5).addContextValue("test Poorly written obj", (Object)new AbstractExceptionContextTest.ObjectWithFaultyToString());
        String message = ((ContextedException)this.exceptionContext).getMessage();
        Assertions.assertNotNull((Object)message);
    }

    @Test
    void testRawMessage() {
        Assertions.assertEquals((Object)(Exception.class.getName() + ": " + "Test Message"), (Object)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException("This is monotonous", (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        Assertions.assertEquals((Object)"This is monotonous", (Object)((ContextedException)this.exceptionContext).getRawMessage());
        this.exceptionContext = new ContextedException(null, (Throwable)new Exception("Test Message"), (ExceptionContext)new DefaultExceptionContext());
        Assertions.assertNull((Object)((ContextedException)this.exceptionContext).getRawMessage());
    }
}

