/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryComponent;

/**
 * Perform document understanding and search using IBM Watson Discovery
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface IbmWatsonDiscoveryComponentBuilderFactory {

    /**
     * IBM Watson Discovery (camel-ibm-watson-discovery)
     * Perform document understanding and search using IBM Watson Discovery
     * 
     * Category: ai,cloud
     * Since: 4.16
     * Maven coordinates: org.apache.camel:camel-ibm-watson-discovery
     * 
     * @return the dsl builder
     */
    static IbmWatsonDiscoveryComponentBuilder ibmWatsonDiscovery() {
        return new IbmWatsonDiscoveryComponentBuilderImpl();
    }

    /**
     * Builder for the IBM Watson Discovery component.
     */
    interface IbmWatsonDiscoveryComponentBuilder extends ComponentBuilder<WatsonDiscoveryComponent> {
    
        /**
         * The Watson Discovery project ID.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param projectId the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder projectId(java.lang.String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
    
        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder serviceUrl(java.lang.String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
    
        
        /**
         * The API version date (format: YYYY-MM-DD).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: 2023-03-31
         * Group: common
         * 
         * @param version the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder version(java.lang.String version) {
            doSetProperty("version", version);
            return this;
        }
    
        /**
         * The collection ID for operations that require it.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param collectionId the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder collectionId(java.lang.String collectionId) {
            doSetProperty("collectionId", collectionId);
            return this;
        }
    
        /**
         * The component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder configuration(org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder operation(org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default IbmWatsonDiscoveryComponentBuilder apiKey(java.lang.String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    class IbmWatsonDiscoveryComponentBuilderImpl
            extends AbstractComponentBuilder<WatsonDiscoveryComponent>
            implements IbmWatsonDiscoveryComponentBuilder {
        @Override
        protected WatsonDiscoveryComponent buildConcreteComponent() {
            return new WatsonDiscoveryComponent();
        }
        private org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration getOrCreateConfiguration(WatsonDiscoveryComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "projectId": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setProjectId((java.lang.String) value); return true;
            case "serviceUrl": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setServiceUrl((java.lang.String) value); return true;
            case "version": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setVersion((java.lang.String) value); return true;
            case "collectionId": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setCollectionId((java.lang.String) value); return true;
            case "configuration": ((WatsonDiscoveryComponent) component).setConfiguration((org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryConfiguration) value); return true;
            case "lazyStartProducer": ((WatsonDiscoveryComponent) component).setLazyStartProducer((boolean) value); return true;
            case "operation": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setOperation((org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations) value); return true;
            case "autowiredEnabled": ((WatsonDiscoveryComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "apiKey": getOrCreateConfiguration((WatsonDiscoveryComponent) component).setApiKey((java.lang.String) value); return true;
            default: return false;
            }
        }
    }
}