/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.jdbc;

import java.sql.Connection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.jdbc.PersistentStorageManager;

public class JDBCTransaction
implements Transaction {
    private PersistentStorageManager pmgr = null;
    private Connection dbConnection = null;
    private boolean active = false;
    private Log log = LogFactory.getLog(this.getClass());

    public JDBCTransaction(PersistentStorageManager pmgr) {
        this.log.debug((Object)"new JDBCTransaction");
        try {
            this.pmgr = pmgr;
            this.dbConnection = pmgr.dbConnect();
            this.dbConnection.setAutoCommit(false);
            this.dbConnection.setTransactionIsolation(4);
            this.active = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    private void freeTransaction() {
        try {
            this.dbConnection.close();
            this.pmgr.removeTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void commit() {
        this.log.debug((Object)"commit JDBCTransaction");
        try {
            this.dbConnection.commit();
            this.freeTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.active = false;
        this.pmgr.releaseTransactionLock();
    }

    public void rollback() {
        this.log.debug((Object)"rollback JDBCTransaction");
        try {
            this.dbConnection.rollback();
            this.freeTransaction();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.active = false;
        this.pmgr.releaseTransactionLock();
    }

    public boolean isActive() {
        return this.active;
    }
}

