/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MakeConnectionProcessor;
import org.apache.sandesha2.msgreceivers.RMMessageReceiver;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.InvokerWorker;
import org.apache.sandesha2.workers.Sender;
import org.apache.sandesha2.wsrm.Sequence;

public class SequenceProcessor {
    private static final Log log = LogFactory.getLog(SequenceProcessor.class);

    public Handler.InvocationResponse processSequenceHeader(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SequenceProcessor::processSequenceHeader");
        }
        Handler.InvocationResponse result = Handler.InvocationResponse.CONTINUE;
        Sequence sequence = rmMsgCtx.getSequence();
        if (sequence != null) {
            result = this.processReliableMessage(rmMsgCtx, transaction);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Message does not contain a sequence header");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceProcessor::processSequenceHeader " + result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler.InvocationResponse processReliableMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        EndpointReference acksTo;
        RelatesTo relatesTo;
        long highestInMsgNo;
        RangeString serverCompletedMessageRanges;
        boolean msgNoPresentInList;
        ConfigurationContext configCtx;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter: SequenceProcessor::processReliableMessage");
        }
        Handler.InvocationResponse result = Handler.InvocationResponse.CONTINUE;
        if (rmMsgCtx.getProperty("Sandesha2AppProcessingDone") != null && rmMsgCtx.getProperty("Sandesha2AppProcessingDone").equals("true")) {
            return result;
        }
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(msgCtx.getConfigurationContext(), (AxisDescription)msgCtx.getConfigurationContext().getAxisConfiguration());
        Sequence sequence = rmMsgCtx.getSequence();
        String sequenceId = sequence.getIdentifier().getIdentifier();
        long msgNo = sequence.getMessageNumber();
        boolean lastMessage = sequence.getLastMessage();
        RMDBeanMgr mgr = storageManager.getRMDBeanMgr();
        RMDBean bean = mgr.retrieve(sequenceId);
        SandeshaUtil.assertProofOfPossession(bean, msgCtx, msgCtx.getEnvelope().getHeader().getFirstChildWithName(new QName(rmMsgCtx.getRMNamespaceValue(), "Sequence")));
        SandeshaUtil.assertProofOfPossession(bean, msgCtx, (OMElement)msgCtx.getEnvelope().getBody());
        OperationContext opCtx = msgCtx.getOperationContext();
        if (opCtx != null) {
            opCtx.setProperty("Sandesha2InboundSequenceId", (Object)sequenceId);
            opCtx.setProperty("Sandesha2InboundMessageNumber", (Object)new Long(msgNo));
            if (lastMessage) {
                opCtx.setProperty("Sandesha2InboundLastMessage", (Object)Boolean.TRUE);
            }
        }
        if ((configCtx = msgCtx.getConfigurationContext()) == null) {
            String message = SandeshaMessageHelper.getMessage("configContextNotSet");
            log.debug((Object)message);
            throw new SandeshaException(message);
        }
        if (bean == null && FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Unknown sequence");
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, bean, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Sequence terminated");
            }
            return Handler.InvocationResponse.ABORT;
        }
        if (FaultManager.checkForSequenceClosed(rmMsgCtx, sequenceId, bean, false)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exit: SequenceProcessor::processReliableMessage, Sequence closed");
            }
            return Handler.InvocationResponse.ABORT;
        }
        FaultManager.checkForLastMsgNumberExceeded(rmMsgCtx, storageManager);
        if (FaultManager.checkForMessageRolledOver(rmMsgCtx, sequenceId, msgNo, bean)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, Message rolled over " + msgNo));
            }
            return Handler.InvocationResponse.ABORT;
        }
        bean.setLastActivatedTime(System.currentTimeMillis());
        if (lastMessage) {
            bean.setLastInMessageId(msgCtx.getMessageID());
        }
        EndpointReference replyTo = rmMsgCtx.getReplyTo();
        if (log.isDebugEnabled()) {
            log.debug((Object)("SequenceProcessor::processReliableMessage replyTo = " + replyTo));
        }
        if (!(msgNoPresentInList = (serverCompletedMessageRanges = bean.getServerCompletedMessages()).isMessageNumberInRanges(msgNo))) {
            serverCompletedMessageRanges.addRange(new Range(msgNo));
        }
        if (msgNo > (highestInMsgNo = bean.getHighestInMessageNumber())) {
            String messageId = msgCtx.getMessageID();
            if (messageId == null) {
                messageId = SandeshaUtil.getUUID();
                msgCtx.setMessageID(messageId);
            }
            bean.setHighestInMessageId(messageId);
            bean.setHighestInMessageNumber(msgNo);
        }
        String specVersion = rmMsgCtx.getRMSpecVersion();
        if (SandeshaUtil.isDuplicateInOnlyMessage(msgCtx) || SandeshaUtil.isDuplicateInOutMessage(msgCtx)) {
            if (replyTo == null || replyTo.isWSAddressingAnonymous()) {
                SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
                SenderBean findSenderBean = new SenderBean();
                if (rmMsgCtx.getMessageType() == 12) {
                    findSenderBean.setMessageType(12);
                } else {
                    findSenderBean.setMessageType(3);
                }
                findSenderBean.setInboundSequenceId(sequence.getIdentifier().getIdentifier());
                findSenderBean.setInboundMessageNumber(sequence.getMessageNumber());
                findSenderBean.setSend(true);
                SenderBean replyMessageBean = senderBeanMgr.findUnique(findSenderBean);
                if (replyMessageBean != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found matching reply for replayed message");
                    }
                    MakeConnectionProcessor.replyToPoll(rmMsgCtx, replyMessageBean, storageManager, false, null, transaction);
                    result = Handler.InvocationResponse.ABORT;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, replayed message: " + result));
                    }
                    return result;
                }
            }
            EndpointReference acksTo2 = bean.getAcksToEndpointReference();
            int msgExchangePattern = rmMsgCtx.getMessageContext().getAxisOperation().getAxisSpecificMEPConstant();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SequenceProcessor:: mep= " + msgExchangePattern));
            }
            if (10 == msgExchangePattern && (replyTo == null || replyTo.getAddress() == null || replyTo.isWSAddressingAnonymous() || replyTo.hasNoneAddress())) {
                this.sendAckIfNeeded(bean, sequenceId, rmMsgCtx, storageManager, true, acksTo2.hasAnonymousAddress());
            }
            result = Handler.InvocationResponse.ABORT;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Exit: SequenceProcessor::processReliableMessage, dropping duplicate: " + result));
            }
            return result;
        }
        EndpointReference toEPR = msgCtx.getTo();
        if (toEPR == null || toEPR.hasAnonymousAddress()) {
            String outboundSequence;
            String toAddress;
            RMSBean outBean = null;
            String string = toAddress = toEPR == null ? null : toEPR.getAddress();
            if (SandeshaUtil.isWSRMAnonymous(toAddress)) {
                RMSBean finderBean = new RMSBean();
                finderBean.setAnonymousUUID(toAddress);
                outBean = storageManager.getRMSBeanMgr().findUnique(finderBean);
            }
            if (outBean == null && (outboundSequence = bean.getOutboundInternalSequence()) != null) {
                outBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, outboundSequence);
            }
            if (outBean != null && outBean.getExpectedReplies() > 0L) {
                outBean.setExpectedReplies(outBean.getExpectedReplies() - 1L);
                RMSBeanMgr outMgr = storageManager.getRMSBeanMgr();
                outMgr.update(outBean);
            }
        }
        bean.setLastActivatedTime(System.currentTimeMillis());
        mgr.update(bean);
        int mep = msgCtx.getAxisOperation().getAxisSpecificMEPConstant();
        if (specVersion != null && specVersion.equals("Spec_2005_02") && mep == 16 && (relatesTo = msgCtx.getRelatesTo()) != null) {
            String messageId = relatesTo.getValue();
            SenderBean sender = storageManager.getSenderBeanMgr().retrieve(messageId);
            if (sender != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Deleting sender for sync-2-way message");
                }
                storageManager.removeMessageContext(sender.getMessageContextRefKey());
                storageManager.getSenderBeanMgr().delete(messageId);
                RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sender.getSequenceID());
                TerminateManager.checkAndTerminate(rmMsgCtx.getConfigurationContext(), storageManager, rmsBean);
            }
        }
        rmMsgCtx.setProperty("WSRMSequenceId", sequenceId);
        rmMsgCtx.setProperty("WSRMMessageNumber", new Long(msgNo));
        boolean backchannelFree = replyTo != null && !replyTo.hasAnonymousAddress() || 10 == mep;
        boolean sendAck = false;
        boolean lastMessageMessage = lastMessage && rmMsgCtx.getMessageType() == 12 && bean.getOutboundInternalSequence() != null;
        boolean ackBackChannel = SpecSpecificConstants.sendAckInBackChannel(rmMsgCtx.getMessageType());
        if (!ackBackChannel && mep == 10) {
            ackBackChannel = true;
        }
        if ((acksTo = bean.getAcksToEndpointReference()).hasAnonymousAddress() && backchannelFree && ackBackChannel && !lastMessageMessage) {
            boolean responseWritten = TransportUtils.isResponseWritten((MessageContext)msgCtx);
            if (!responseWritten) {
                sendAck = true;
            }
        } else if (!acksTo.hasAnonymousAddress()) {
            SandeshaPolicyBean policyBean = SandeshaUtil.getPropertyBean((AxisDescription)msgCtx.getAxisOperation());
            long ackInterval = policyBean.getAcknowledgementInterval();
            ((Sender)storageManager.getSender()).scheduleAddressableAcknowledgement(sequenceId, ackInterval, rmMsgCtx);
            if (backchannelFree) {
                TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)false);
                RequestResponseTransport t = null;
                t = (RequestResponseTransport)rmMsgCtx.getProperty("RequestResponseTransportControl");
                if (t != null && RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals((Object)t.getStatus())) {
                    t.acknowledgeMessage(msgCtx);
                }
            }
        }
        if (("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(msgCtx.getWSAAction()) || "http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage".equals(msgCtx.getSoapAction())) && rmMsgCtx.getRelatesTo() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SequenceProcessor::processReliableMessage, got WSRM 1.0 lastmessage");
            }
            msgCtx.getAxisOperation().setMessageReceiver((MessageReceiver)new RMMessageReceiver());
        }
        InvokerWorker worker = null;
        if (SandeshaUtil.isInOrder(msgCtx)) {
            String key = SandeshaUtil.getUUID();
            InvokerBean invokerBean = new InvokerBean(key, msgNo, sequenceId);
            ContextManager contextMgr = SandeshaUtil.getContextManager(configCtx);
            if (contextMgr != null) {
                invokerBean.setContext(contextMgr.storeContext());
            }
            boolean wasAdded = storageManager.getInvokerBeanMgr().insert(invokerBean);
            rmMsgCtx.setProperty("Sandesha2AppProcessingDone", "true");
            result = Handler.InvocationResponse.SUSPEND;
            if (wasAdded) {
                storageManager.storeMessageContext(key, msgCtx);
                if (bean.getNextMsgNoToProcess() == msgNo && !storageManager.hasUserTransaction(msgCtx)) {
                    String workId = sequenceId;
                    ConfigurationContext context = msgCtx.getConfigurationContext();
                    worker = new InvokerWorker(context, invokerBean);
                    worker.setWorkId(workId);
                    worker.getLock().addWork(workId, worker);
                }
            } else {
                sendAck = false;
                result = Handler.InvocationResponse.ABORT;
                RequestResponseTransport t = null;
                t = (RequestResponseTransport)rmMsgCtx.getProperty("RequestResponseTransportControl");
                if (t != null && RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals((Object)t.getStatus())) {
                    TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)false);
                    t.acknowledgeMessage(msgCtx);
                }
            }
            if (msgCtx.getRelatesTo() != null && msgCtx.getTo() != null && !msgCtx.getTo().hasAnonymousAddress()) {
                result = Handler.InvocationResponse.ABORT;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SequenceProcessor::processReliableMessage, Aborting the thread as this is an async response requiring inorder delivery.  An invoker thread will process the delivery");
                }
            }
        }
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
        }
        if (worker != null) {
            try {
                worker.run();
            }
            catch (Exception e) {
                log.error((Object)"Caught exception running InvokerWorker", (Throwable)e);
            }
        }
        if (sendAck) {
            try {
                transaction = storageManager.getTransaction();
                RMMsgContext ackRMMsgContext = AcknowledgementManager.generateAckMessage(rmMsgCtx, bean, sequenceId, storageManager, true);
                AcknowledgementManager.sendAckNow(ackRMMsgContext);
                TransportUtils.setResponseWritten((MessageContext)msgCtx, (boolean)true);
                RequestResponseTransport t = (RequestResponseTransport)rmMsgCtx.getProperty("RequestResponseTransportControl");
                if (t != null && RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals((Object)t.getStatus())) {
                    t.signalResponseReady();
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
                Object var36_49 = null;
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
            }
            catch (Throwable throwable) {
                Object var36_50 = null;
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                throw throwable;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exit: SequenceProcessor::processReliableMessage " + result));
        }
        return result;
    }

    private void sendAckIfNeeded(RMDBean rmdBean, String sequenceId, RMMsgContext rmMsgCtx, StorageManager storageManager, boolean serverSide, boolean anonymousAcksTo) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: SequenceProcessor::sendAckIfNeeded " + sequenceId));
        }
        RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, rmdBean, sequenceId, storageManager, serverSide);
        if (anonymousAcksTo) {
            AcknowledgementManager.sendAckNow(ackRMMsgCtx);
            TransportUtils.setResponseWritten((MessageContext)rmMsgCtx.getMessageContext(), (boolean)true);
        } else {
            long ackInterval = SandeshaUtil.getPropertyBean((AxisDescription)rmMsgCtx.getMessageContext().getAxisService()).getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            AcknowledgementManager.addAckBeanEntry(ackRMMsgCtx, sequenceId, timeToSend, storageManager);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit: SequenceProcessor::sendAckIfNeeded");
        }
    }
}

