/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Locale;
import org.openjdk.javax.tools.DiagnosticListener;
import org.openjdk.javax.tools.JavaCompiler;
import org.openjdk.tools.javac.api.JavacTool;
import org.openjdk.tools.javac.code.ClassFinder;
import org.openjdk.tools.javac.code.Symbol;
import org.openjdk.tools.javac.code.Symtab;
import org.openjdk.tools.javac.main.JavaCompiler;
import org.openjdk.tools.javac.util.Context;
import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.Name;
import org.openjdk.tools.javac.util.Names;
import org.openjdk.tools.sjavac.comp.PubapiVisitor;
import org.openjdk.tools.sjavac.comp.SmartFileManager;
import org.openjdk.tools.sjavac.options.Options;
import org.openjdk.tools.sjavac.pubapi.PubApi;

public class PubApiExtractor {
    final Context context;
    final JavaCompiler.CompilationTask task;
    final SmartFileManager fileManager;

    public PubApiExtractor(Options options) {
        JavacTool javacTool = JavacTool.create();
        this.fileManager = new SmartFileManager(javacTool.getStandardFileManager((DiagnosticListener)null, (Locale)null, (Charset)null));
        this.context = new Context();
        String[] stringArray = options.prepJavacArgs();
        this.task = javacTool.getTask(new PrintWriter(System.err), this.fileManager, null, Arrays.asList(stringArray), null, null, this.context);
        JavaCompiler.instance(this.context);
    }

    public PubApi getPubApi(String string) {
        Symtab symtab = Symtab.instance(this.context);
        ClassFinder classFinder = ClassFinder.instance(this.context);
        Names names = Names.instance(this.context);
        Name name = names.fromString(string);
        Symbol.ClassSymbol classSymbol = classFinder.loadClass(symtab.inferModule(Convert.packagePart(name)), name);
        PubapiVisitor pubapiVisitor = new PubapiVisitor();
        pubapiVisitor.visit(classSymbol);
        return pubapiVisitor.getCollectedPubApi();
    }

    public void close() throws IOException {
        this.fileManager.close();
    }
}

