/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import java.util.HashSet;
import java.util.Set;
import org.openjdk.javax.tools.JavaFileObject;
import org.openjdk.tools.javac.code.Lint;
import org.openjdk.tools.javac.util.JCDiagnostic;
import org.openjdk.tools.javac.util.Log;

public class MandatoryWarningHandler {
    private Log log;
    private boolean verbose;
    private String prefix;
    private Set<JavaFileObject> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private JavaFileObject deferredDiagnosticSource;
    private Object deferredDiagnosticArg;
    private final boolean enforceMandatory;
    private final Lint.LintCategory lintCategory;

    public MandatoryWarningHandler(Log log, boolean bl, boolean bl2, String string, Lint.LintCategory lintCategory) {
        this.log = log;
        this.verbose = bl;
        this.prefix = string;
        this.enforceMandatory = bl2;
        this.lintCategory = lintCategory;
    }

    public void report(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        JavaFileObject javaFileObject = this.log.currentSourceFile();
        if (this.verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<JavaFileObject>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.logMandatoryWarning(diagnosticPosition, string, objectArray);
                this.sourcesWithReportedWarnings.add(javaFileObject);
            } else if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(javaFileObject) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticSource = javaFileObject;
                this.deferredDiagnosticArg = javaFileObject;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || MandatoryWarningHandler.equal(this.deferredDiagnosticSource, javaFileObject))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticSource = javaFileObject;
            this.deferredDiagnosticArg = javaFileObject;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !MandatoryWarningHandler.equal(this.deferredDiagnosticSource, javaFileObject)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
    }

    public void reportDeferredDiagnostic() {
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
            } else {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.verbose) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.prefix + ".recompile", new Object[0]);
            }
        }
    }

    private static boolean equal(Object object, Object object2) {
        return object == null || object2 == null ? object == object2 : object.equals(object2);
    }

    private void logMandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        if (this.enforceMandatory) {
            this.log.mandatoryWarning(this.lintCategory, diagnosticPosition, string, objectArray);
        } else {
            this.log.warning(this.lintCategory, diagnosticPosition, string, objectArray);
        }
    }

    private void logMandatoryNote(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        if (this.enforceMandatory) {
            this.log.mandatoryNote(javaFileObject, string, objectArray);
        } else {
            this.log.note(javaFileObject, string, objectArray);
        }
    }

    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private final String value;

        private DeferredDiagnosticKind(String string2) {
            this.value = string2;
        }

        String getKey(String string) {
            return string + this.value;
        }
    }
}

