/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.DefinitionContext;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NestingElementBase;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValidationProblem;
import org.jibx.binding.model.ValueElement;
import org.jibx.binding.util.ObjectStack;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.ValidationException;
import org.jibx.util.IClassLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaGenerator {
    private static String CURRENT_VERSION = "0.4";
    private static final String XSD_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String XML_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    private static HashMap s_objectTypeMap = new HashMap();
    private static HashMap s_primitiveTypeMap;
    private boolean m_verbose;
    private boolean m_isElementQualified;
    private boolean m_isAttributeQualified;
    private String m_indentSequence;
    private HashMap m_schemaMap;
    private IClassLocator m_classLocator;
    private Document m_document;
    private ObjectStack m_structureStack = new ObjectStack();

    public SchemaGenerator(ArrayList paths) {
        this.m_schemaMap = new HashMap();
        String[] parray = paths.toArray(new String[paths.size()]);
        ClassCache.setPaths(parray);
        ClassFile.setPaths(parray);
        this.m_classLocator = new ClassCache.ClassCacheLocator();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.m_document = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Parser configuration error " + e.getMessage());
        }
        catch (FactoryConfigurationError e) {
            throw new IllegalStateException("Factory configuration error " + e.getMessage());
        }
    }

    public SchemaGenerator(boolean verbose, boolean equal, boolean aqual, ArrayList paths) {
        this(paths);
        this.m_verbose = verbose;
        this.m_isElementQualified = equal;
        this.m_isAttributeQualified = aqual;
        this.m_indentSequence = "  ";
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setElementQualified(boolean qual) {
        this.m_isElementQualified = qual;
    }

    public void setAttributeQualified(boolean qual) {
        this.m_isAttributeQualified = qual;
    }

    public Element[] getSchemas() {
        Element[] schemas = new Element[this.m_schemaMap.size()];
        int fill = 0;
        Iterator iter = this.m_schemaMap.values().iterator();
        while (iter.hasNext()) {
            schemas[fill++] = (Element)iter.next();
        }
        return schemas;
    }

    private void indentForClose(Element parent) {
        StringBuffer buff = new StringBuffer(20);
        buff.append('\n');
        boolean count = false;
        for (Element ancestor = parent; ancestor != null; ancestor = (Element)ancestor.getParentNode()) {
            if (count) {
                buff.append(this.m_indentSequence);
            }
            count = true;
        }
        parent.appendChild(this.m_document.createTextNode(buff.toString()));
    }

    private void addComment(Element parent, String text) {
        if (parent.getChildNodes().getLength() == 0) {
            this.indentForClose(parent);
        }
        parent.appendChild(this.m_document.createTextNode(this.m_indentSequence));
        parent.appendChild(this.m_document.createComment(text));
        this.indentForClose(parent);
    }

    private Element addChildElement(Element parent, String name) {
        if (parent.getChildNodes().getLength() == 0) {
            this.indentForClose(parent);
        }
        parent.appendChild(this.m_document.createTextNode(this.m_indentSequence));
        Element element = this.m_document.createElementNS(XSD_URI, name);
        element.setPrefix(parent.getPrefix());
        parent.appendChild(element);
        this.indentForClose(parent);
        return element;
    }

    public DefinitionContext getDefinitions() {
        int index = 0;
        while (index < this.m_structureStack.size()) {
            NestingElementBase nest;
            if ((nest = (NestingElementBase)this.m_structureStack.peek(index++)).getDefinitions() == null) continue;
            return nest.getDefinitions();
        }
        throw new IllegalStateException("Internal error: no definition context");
    }

    private void defineEmptyStructureComponent(StructureElementBase comp, Element egroup, Element agroup) {
        boolean only;
        NestingElementBase parent = (NestingElementBase)this.m_structureStack.peek(0);
        boolean bl = only = parent.children().size() == 1;
        if (comp.type() == 1) {
            CollectionElement collection = (CollectionElement)comp;
            String itype = collection.getItemTypeClass().getName();
            DefinitionContext dctx = this.getDefinitions();
            TemplateElementBase templ = dctx.getSpecificTemplate(itype);
            Element element = null;
            if (!(templ instanceof MappingElement)) {
                if (only) {
                    this.addComment(egroup, " Replace \"any\" with details of content to complete schema ");
                    element = this.addChildElement(egroup, "any");
                } else {
                    this.addComment(egroup, " No mapping for items of collection at " + ValidationException.describe((Object)collection) + " ");
                    this.addComment(egroup, " Fill in details of content to complete schema ");
                }
            } else {
                element = this.addChildElement(egroup, "element");
                String name = ((MappingElementBase)templ).getName();
                if (element.getPrefix() == null) {
                    name = "tns:" + name;
                }
                element.setAttribute("ref", name);
            }
            if (element != null) {
                element.setAttribute("minOccurs", "0");
                element.setAttribute("maxOccurs", "unbounded");
            }
        } else {
            StructureElement structure = (StructureElement)comp;
            TemplateElementBase templ = structure.getEffectiveMapping();
            if (!(templ instanceof MappingElement)) {
                if (only) {
                    this.addComment(egroup, " Replace \"any\" with details of content to complete schema ");
                    this.addChildElement(egroup, "any");
                } else {
                    this.addComment(egroup, " No mapping for structure at " + ValidationException.describe((Object)structure) + " ");
                    this.addComment(egroup, " Fill in details of content here to complete schema ");
                }
            } else {
                MappingElementBase mapping = (MappingElementBase)templ;
                if (mapping.isAbstract()) {
                    String ename = structure.getName();
                    if (ename == null) {
                        ename = mapping.getName();
                    }
                    if (ename == null) {
                        this.addComment(egroup, "No schema representation for directly-embedded type, inlining definition");
                        this.addComment(egroup, "Add element name to structure at " + ValidationException.describe((Object)structure) + " to avoid inlining");
                        this.defineList(mapping.children(), egroup, agroup, false);
                    } else {
                        Element element = this.addChildElement(egroup, "element");
                        String tname = this.simpleClassName(mapping.getClassName());
                        if (element.getPrefix() == null) {
                            tname = "tns:" + tname;
                        }
                        element.setAttribute("type", tname);
                        String name = structure.getName();
                        if (name == null) {
                            name = mapping.getName();
                        }
                        element.setAttribute("name", name);
                        if (structure.isOptional()) {
                            element.setAttribute("minOccurs", "0");
                        }
                    }
                } else {
                    String sname = structure.getName();
                    String mname = mapping.getName();
                    if (sname != null && !sname.equals(mname)) {
                        this.addComment(egroup, "No schema representation for element reference with different name, inlining definition");
                        this.addComment(egroup, "Remove name on mapping reference at " + ValidationException.describe((Object)structure) + " to avoid inlining");
                        this.defineList(mapping.children(), egroup, agroup, false);
                    } else {
                        Element element = this.addChildElement(egroup, "element");
                        String tname = this.simpleClassName(mapping.getClassName());
                        if (element.getPrefix() == null) {
                            tname = "tns:" + tname;
                        }
                        element.setAttribute("ref", tname);
                        if (structure.isOptional()) {
                            element.setAttribute("minOccurs", "0");
                        }
                    }
                }
            }
        }
    }

    private void defineStructureComponent(StructureElementBase comp, Element egroup, Element agroup, boolean mult) {
        if (comp.getName() != null) {
            Element element = this.addChildElement(egroup, "element");
            element.setAttribute("name", comp.getName());
            if (mult) {
                element.setAttribute("minOccurs", "0");
                element.setAttribute("maxOccurs", "unbounded");
            } else if (comp.isOptional()) {
                element.setAttribute("minOccurs", "0");
            }
            if (comp.children().size() > 0) {
                this.defineNestedStructure(comp, element);
            } else {
                Element type = this.addChildElement(element, "complexType");
                Element seq = this.addChildElement(type, "sequence");
                this.defineEmptyStructureComponent(comp, seq, type);
            }
        } else if (comp.children().size() > 0) {
            boolean coll = comp.type() == 1;
            this.m_structureStack.push(comp);
            this.defineList(comp.children(), egroup, agroup, coll);
            this.m_structureStack.pop();
        } else {
            this.defineEmptyStructureComponent(comp, egroup, agroup);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void defineList(ArrayList comps, Element egroup, Element agroup, boolean mult) {
        int i = 0;
        while (i < comps.size()) {
            ElementBase child = (ElementBase)comps.get(i);
            switch (child.type()) {
                case 1: 
                case 5: {
                    this.defineStructureComponent((StructureElementBase)child, egroup, agroup, mult);
                    break;
                }
                case 3: {
                    System.err.println("Error: nested mapping not supported (class " + ((MappingElementBase)child).getClassName() + ")");
                    break;
                }
                case 6: {
                    System.err.println("Error: template component not yet supported");
                    break;
                }
                case 7: {
                    Element element;
                    int style;
                    ValueElement value = (ValueElement)child;
                    String tname = value.getType().getName();
                    String stype = (String)s_primitiveTypeMap.get(tname);
                    if (stype == null && (stype = (String)s_objectTypeMap.get(tname)) == null) {
                        stype = "xsd:string";
                    }
                    if ((style = value.getStyle()) == 0) {
                        element = this.addChildElement(agroup, "attribute");
                        if (!value.isOptional()) {
                            element.setAttribute("use", "required");
                        }
                    } else {
                        if (style != 1) {
                            System.err.println("Error: value type " + value.getEffectiveStyleName() + " not supported");
                            break;
                        }
                        element = this.addChildElement(egroup, "element");
                        if (mult) {
                            element.setAttribute("minOccurs", "0");
                            element.setAttribute("maxOccurs", "unbounded");
                        } else if (value.isOptional()) {
                            element.setAttribute("minOccurs", "0");
                        }
                    }
                    element.setAttribute("name", value.getName());
                    element.setAttribute("type", stype);
                    break;
                }
            }
            ++i;
        }
        return;
    }

    private Element defineNestedStructure(ContainerElementBase container, Element parent) {
        Element type = this.addChildElement(parent, "complexType");
        ArrayList childs = container.children();
        Element group = container.isOrdered() ? this.addChildElement(type, "sequence") : this.addChildElement(type, "all");
        this.m_structureStack.push(container);
        this.defineList(childs, group, type, container.type() == 1);
        this.m_structureStack.pop();
        return type;
    }

    private void generateSchema(BindingElement binding) {
        this.m_structureStack.push(binding);
        ArrayList tops = binding.topChildren();
        for (int i = 0; i < tops.size(); ++i) {
            ElementBase top = (ElementBase)tops.get(i);
            if (top.type() != 3) continue;
            MappingElementBase mapping = (MappingElementBase)top;
            String uri = mapping.getNamespace().getUri();
            Element schema = (Element)this.m_schemaMap.get(uri);
            if (schema == null) {
                schema = this.m_document.createElementNS(XSD_URI, "schema");
                this.m_schemaMap.put(uri, schema);
                if (this.m_isElementQualified) {
                    schema.setAttribute("elementFormDefault", "qualified");
                }
                if (this.m_isAttributeQualified) {
                    schema.setAttribute("attributeFormDefault", "qualified");
                }
                if (uri == null) {
                    schema.setPrefix("xsd");
                } else {
                    schema.setAttribute("targetNamespace", uri);
                    schema.setAttributeNS(XMLNS_URI, "xmlns:tns", uri);
                    schema.setAttributeNS(XMLNS_URI, "xmlns", XSD_URI);
                }
                schema.setAttributeNS(XMLNS_URI, "xmlns:xsd", XSD_URI);
                this.indentForClose(schema);
            }
            this.indentForClose(schema);
            String cname = mapping.getClassName();
            this.addComment(schema, " Created from mapping for class " + cname + " ");
            if (mapping.isAbstract()) {
                Element type = this.defineNestedStructure(mapping, schema);
                type.setAttribute("name", this.simpleClassName(cname));
                continue;
            }
            Element element = this.addChildElement(schema, "element");
            element.setAttribute("name", mapping.getName());
            if (mapping.getMarshaller() != null || mapping.getUnmarshaller() != null) {
                Element type = this.addChildElement(element, "complexType");
                Element seq = this.addChildElement(type, "sequence");
                this.addComment(seq, " Replace \"any\" with details of content to complete schema ");
                this.addChildElement(seq, "any");
                continue;
            }
            this.defineNestedStructure(mapping, element);
        }
        this.m_structureStack.pop();
    }

    public void generate(BindingElement binding) throws JiBXException {
        ValidationContext vctx = new ValidationContext(this.m_classLocator);
        binding.runValidation(vctx);
        boolean usable = true;
        if (vctx.getProblems().size() > 0) {
            System.err.println("Problems found in binding " + binding.getName());
            ArrayList probs = vctx.getProblems();
            for (int i = 0; i < probs.size(); ++i) {
                ValidationProblem prob = (ValidationProblem)probs.get(i);
                System.err.println(prob.getDescription());
                if (prob.getSeverity() <= 0) continue;
                usable = false;
            }
        }
        if (usable) {
            this.generateSchema(binding);
        } else {
            System.err.println("Binding validation errors prevent schema generation");
            System.exit(1);
        }
    }

    private String simpleClassName(String cname) {
        int split = cname.lastIndexOf(46);
        if (split >= 0) {
            cname = cname.substring(split + 1);
        }
        return cname;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                int i;
                boolean verbose = false;
                boolean edflt = true;
                boolean adflt = false;
                ArrayList<String> paths = new ArrayList<String>();
                for (int offset = 0; offset < args.length; ++offset) {
                    String arg = args[offset];
                    if ("-v".equalsIgnoreCase(arg)) {
                        verbose = true;
                        continue;
                    }
                    if ("-e".equalsIgnoreCase(arg)) {
                        edflt = false;
                        continue;
                    }
                    if ("-a".equalsIgnoreCase(arg)) {
                        adflt = true;
                        continue;
                    }
                    if (!"-p".equalsIgnoreCase(arg)) break;
                    paths.add(args[++offset]);
                }
                String[] vmpaths = Utility.getClassPaths();
                for (int i2 = 0; i2 < vmpaths.length; ++i2) {
                    paths.add(vmpaths[i2]);
                }
                ArrayList<String> bindings = new ArrayList<String>();
                for (i = offset; i < args.length; ++i) {
                    bindings.add(args[i]);
                }
                System.out.println("Running schema generator version " + CURRENT_VERSION);
                if (verbose) {
                    System.out.println("Using paths:");
                    for (i = 0; i < paths.size(); ++i) {
                        System.out.println(" " + paths.get(i));
                    }
                    System.out.println("Using input bindings:");
                    for (i = 0; i < bindings.size(); ++i) {
                        System.out.println(" " + bindings.get(i));
                    }
                }
                SchemaGenerator schemagen = new SchemaGenerator(verbose, edflt, adflt, paths);
                for (int i3 = 0; i3 < bindings.size(); ++i3) {
                    String bpath = (String)bindings.get(i3);
                    String name = Utility.fileName(bpath);
                    File file = new File(bpath);
                    BindingElement binding = Utility.validateBinding(name, new URL("file://" + file.getAbsolutePath()), new FileInputStream(file));
                    if (binding == null) continue;
                    schemagen.generate(binding);
                }
                Element[] schemas = schemagen.getSchemas();
                for (int i4 = 0; i4 < schemas.length; ++i4) {
                    int split;
                    Element schema = schemas[i4];
                    String tns = schema.getAttribute("targetNamespace");
                    String name = tns;
                    if (name.length() == 0) {
                        name = (String)bindings.get(0);
                        split = name.lastIndexOf(46);
                        if (split >= 0) {
                            name = name.substring(0, split);
                        }
                    } else {
                        split = name.lastIndexOf(47);
                        if (split >= 0) {
                            name = name.substring(split + 1);
                        }
                    }
                    try {
                        name = name + ".xsd";
                        FileOutputStream out = new FileOutputStream(name);
                        Transformer transformer = TransformerFactory.newInstance().newTransformer();
                        transformer.setOutputProperty("indent", "no");
                        DOMSource source = new DOMSource(schema);
                        StreamResult result = new StreamResult(out);
                        transformer.transform(source, result);
                        out.close();
                        System.out.print("Wrote schema " + name);
                        if (tns.length() == 0) {
                            System.out.println(" for default namespace");
                            continue;
                        }
                        System.out.println(" for namespace " + tns);
                        continue;
                    }
                    catch (TransformerConfigurationException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (TransformerFactoryConfigurationError e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (JiBXException ex) {
                ex.printStackTrace();
                System.exit(1);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                System.exit(2);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                System.exit(3);
            }
        } else {
            System.out.println("\nUsage: java org.jibx.binding.SchemaGenerator [-v] [-e] [-a] [-p path]* binding1 binding2 ...\nwhere:\n -v  turns on verbose output,\n -e  sets elementFormDefault=\"false\" for the schemas,\n -a  sets attributeFormDefault=\"true\" for the schemas, and\n -p  gives a path component for looking up the classes referenced in the binding\nThe binding# files are different bindings to be used for schema generation.\n");
            System.exit(1);
        }
    }

    static {
        s_objectTypeMap.put("java.lang.Boolean", "xsd:boolean");
        s_objectTypeMap.put("java.lang.Byte", "xsd:byte");
        s_objectTypeMap.put("java.lang.Character", "xsd:unsignedInt");
        s_objectTypeMap.put("java.lang.Double", "xsd:double");
        s_objectTypeMap.put("java.lang.Float", "xsd:float");
        s_objectTypeMap.put("java.lang.Integer", "xsd:int");
        s_objectTypeMap.put("java.lang.Long", "xsd:long");
        s_objectTypeMap.put("java.lang.Short", "xsd:short");
        s_objectTypeMap.put("java.math.BigDecimal", "xsd:decimal");
        s_objectTypeMap.put("java.math.BigInteger", "xsd:integer");
        s_objectTypeMap.put("java.sql.Date", "xsd:date");
        s_objectTypeMap.put("java.sql.Time", "xsd:time");
        s_objectTypeMap.put("java.sql.Timestamp", "xsd:dateTime");
        s_objectTypeMap.put("java.util.Date", "xsd:dateTime");
        s_objectTypeMap.put("byte[]", "xsd:base64");
        s_primitiveTypeMap = new HashMap();
        s_primitiveTypeMap.put("boolean", "xsd:boolean");
        s_primitiveTypeMap.put("byte", "xsd:byte");
        s_primitiveTypeMap.put("char", "xsd:unsignedInt");
        s_primitiveTypeMap.put("double", "xsd:double");
        s_primitiveTypeMap.put("float", "xsd:float");
        s_primitiveTypeMap.put("int", "xsd:int");
        s_primitiveTypeMap.put("long", "xsd:long");
        s_primitiveTypeMap.put("short", "xsd:short");
    }
}

