/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.ant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.ws.java2wsdl.Java2WSDLCodegenEngine;
import org.apache.ws.java2wsdl.MappingSet;
import org.apache.ws.java2wsdl.NamespaceMapping;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLTask
extends Task
implements Java2WSDLConstants {
    public static final String OPEN_BRACKET = "[";
    public static final String CLOSE_BRACKET = "]";
    public static final String COMMA = ",";
    private String className = null;
    private String outputLocation = null;
    private String targetNamespace = null;
    private String targetNamespacePrefix = null;
    private String schemaTargetNamespace = null;
    private String schemaTargetNamespacePrefix = null;
    private String serviceName = null;
    private String outputFileName = null;
    private Path classpath = null;
    private String style = "document";
    private String use = "literal";
    private String locationUri;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private String wsdlVersion = null;
    private String docLitBare = null;
    private String[] extraClasses;
    private final List<ExtraClass> extraClasses2 = new ArrayList<ExtraClass>();
    private String nsGenClassName = null;
    private HashMap namespaceMap = new HashMap();
    private ArrayList pkg2nsMappings = new ArrayList();
    private MappingSet mappings = new MappingSet();
    private String schemaGenClassName = null;

    public String getLocationUri() {
        return this.locationUri;
    }

    public void setLocationUri(String locationUri) {
        this.locationUri = locationUri;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    private Map fillOptionMap() {
        HashMap optionMap = new HashMap();
        if (this.className == null) {
            throw new BuildException("You must specify a classname");
        }
        this.addToOptionMap(optionMap, "cn", this.className);
        this.addToOptionMap(optionMap, "o", this.outputLocation);
        this.addToOptionMap(optionMap, "tn", this.targetNamespace);
        this.addToOptionMap(optionMap, "tp", this.targetNamespacePrefix);
        this.addToOptionMap(optionMap, "stn", this.schemaTargetNamespace);
        this.addToOptionMap(optionMap, "stp", this.schemaTargetNamespacePrefix);
        this.addToOptionMap(optionMap, "sn", this.serviceName);
        this.addToOptionMap(optionMap, "of", this.outputFileName);
        this.addToOptionMap(optionMap, "st", this.getStyle());
        this.addToOptionMap(optionMap, "u", this.getUse());
        this.addToOptionMap(optionMap, "l", this.getLocationUri());
        this.addToOptionMap(optionMap, "afd", this.getAttrFormDefault());
        this.addToOptionMap(optionMap, "efd", this.getElementFormDefault());
        this.addToOptionMap(optionMap, "xc", this.getExtraClasses());
        this.addToOptionMap(optionMap, "nsg", this.getNsGenClassName());
        this.addToOptionMap(optionMap, "sg", this.getSchemaGenClassName());
        this.addToOptionMap(optionMap, "wv", this.getWSDLVersion());
        this.addToOptionMap(optionMap, "dlb", this.getDocLitBare());
        this.loadPkg2NsMap();
        this.addToOptionMap(optionMap, "p2n", this.getPkg2nsMappings());
        return optionMap;
    }

    private String[] getStringArray(String value) {
        String[] values = new String[]{value};
        return values;
    }

    private void addToOptionMap(Map map, String option, String value) {
        if (value != null) {
            map.put(option, new Java2WSDLCommandLineOption(option, this.getStringArray(value)));
        }
    }

    private void addToOptionMap(Map map, String option, String[] values) {
        if (values != null && values.length > 0) {
            map.put(option, new Java2WSDLCommandLineOption(option, values));
        }
    }

    private void addToOptionMap(Map map, String option, ArrayList values) {
        if (values != null && !values.isEmpty()) {
            map.put(option, new Java2WSDLCommandLineOption(option, values));
        }
    }

    public void execute() throws BuildException {
        try {
            Map commandLineOptions = this.fillOptionMap();
            ClassLoader conextClassLoader = Thread.currentThread().getContextClassLoader();
            AntClassLoader cl = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classpath == null ? this.createClasspath() : this.classpath, false);
            commandLineOptions.put("cp", new Java2WSDLCommandLineOption("cp", this.classpath.list()));
            Thread.currentThread().setContextClassLoader((ClassLoader)cl);
            new Java2WSDLCodegenEngine(commandLineOptions).generate();
            Thread.currentThread().setContextClassLoader(conextClassLoader);
        }
        catch (Throwable e) {
            throw new BuildException(e);
        }
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setOutputLocation(String outputLocation) {
        this.outputLocation = outputLocation;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this.targetNamespacePrefix = targetNamespacePrefix;
    }

    public void setSchemaTargetNamespace(String schemaTargetNamespace) {
        this.schemaTargetNamespace = schemaTargetNamespace;
    }

    public void setSchemaTargetNamespacePrefix(String schemaTargetNamespacePrefix) {
        this.schemaTargetNamespacePrefix = schemaTargetNamespacePrefix;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
            this.classpath = this.classpath.concatSystemClasspath();
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    public String[] getExtraClasses() {
        ArrayList<String> list = new ArrayList<String>((this.extraClasses == null ? 0 : this.extraClasses.length) + this.extraClasses2.size());
        if (this.extraClasses != null) {
            list.addAll(Arrays.asList(this.extraClasses));
        }
        for (ExtraClass extraClass : this.extraClasses2) {
            list.add(extraClass.getName());
        }
        return list.toArray(new String[list.size()]);
    }

    public void setExtraClasses(String extraClasses) {
        this.extraClasses = extraClasses.split(COMMA);
    }

    public ExtraClass createExtraClass() {
        ExtraClass extraClass = new ExtraClass();
        this.extraClasses2.add(extraClass);
        return extraClass;
    }

    public String getNsGenClassName() {
        return this.nsGenClassName;
    }

    public void setNsGenClassName(String nsGenClassName) {
        this.nsGenClassName = nsGenClassName;
    }

    public String getSchemaGenClassName() {
        return this.schemaGenClassName;
    }

    public void setSchemaGenClassName(String schemaGenClassName) {
        this.schemaGenClassName = schemaGenClassName;
    }

    public void loadPkg2NsMap() {
        this.mappings.execute(this.namespaceMap, true);
        Iterator packageNames = this.namespaceMap.keySet().iterator();
        String packageName = null;
        while (packageNames.hasNext()) {
            packageName = (String)packageNames.next();
            this.pkg2nsMappings.add(OPEN_BRACKET + packageName + COMMA + this.namespaceMap.get(packageName) + CLOSE_BRACKET);
        }
    }

    public ArrayList getPkg2nsMappings() {
        return this.pkg2nsMappings;
    }

    public void setPkg2nsMappings(ArrayList pkg2nsMappings) {
        this.pkg2nsMappings = pkg2nsMappings;
    }

    public void addMapping(NamespaceMapping mapping) {
        this.mappings.addMapping(mapping);
    }

    public void addMappingSet(MappingSet mappingset) {
        this.mappings.addMappingSet(mappingset);
    }

    public String getDocLitBare() {
        return this.docLitBare;
    }

    public void setDocLitBare(String docLitBare) {
        this.docLitBare = docLitBare;
    }

    public String getWSDLVersion() {
        return this.wsdlVersion;
    }

    public void setWSDLVersion(String wsdlVersion) {
        this.wsdlVersion = wsdlVersion;
    }

    public static class ExtraClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

