/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.code;

import java.util.EnumMap;
import java.util.HashSet;
import org.openjdk.tools.javac.code.Attribute;
import org.openjdk.tools.javac.util.Assert;
import org.openjdk.tools.javac.util.List;

public class TypeMetadata {
    public static final TypeMetadata EMPTY = new TypeMetadata();
    private final EnumMap<Entry.Kind, Entry> contents;

    private TypeMetadata() {
        this.contents = new EnumMap(Entry.Kind.class);
    }

    public TypeMetadata(Entry entry) {
        this();
        Assert.checkNonNull(entry);
        this.contents.put(entry.kind(), entry);
    }

    public TypeMetadata(TypeMetadata typeMetadata) {
        Assert.checkNonNull(typeMetadata);
        this.contents = typeMetadata.contents.clone();
    }

    public TypeMetadata combine(Entry entry) {
        Assert.checkNonNull(entry);
        TypeMetadata typeMetadata = new TypeMetadata(this);
        Entry.Kind kind = entry.kind();
        if (this.contents.containsKey((Object)kind)) {
            typeMetadata.add(kind, this.contents.get((Object)kind).combine(entry));
        } else {
            typeMetadata.add(kind, entry);
        }
        return typeMetadata;
    }

    public TypeMetadata combineAll(TypeMetadata typeMetadata) {
        Assert.checkNonNull(typeMetadata);
        TypeMetadata typeMetadata2 = new TypeMetadata();
        HashSet<Entry.Kind> hashSet = new HashSet<Entry.Kind>(this.contents.keySet());
        hashSet.addAll(typeMetadata.contents.keySet());
        for (Entry.Kind kind : hashSet) {
            if (this.contents.containsKey((Object)kind)) {
                if (typeMetadata.contents.containsKey((Object)kind)) {
                    typeMetadata2.add(kind, this.contents.get((Object)kind).combine(typeMetadata.contents.get((Object)kind)));
                    continue;
                }
                typeMetadata2.add(kind, this.contents.get((Object)kind));
                continue;
            }
            if (!typeMetadata.contents.containsKey((Object)kind)) continue;
            typeMetadata2.add(kind, typeMetadata.contents.get((Object)kind));
        }
        return typeMetadata2;
    }

    public TypeMetadata without(Entry.Kind kind) {
        if (this == EMPTY || this.contents.get((Object)kind) == null) {
            return this;
        }
        TypeMetadata typeMetadata = new TypeMetadata(this);
        typeMetadata.contents.remove((Object)kind);
        return typeMetadata.contents.isEmpty() ? EMPTY : typeMetadata;
    }

    public Entry get(Entry.Kind kind) {
        return this.contents.get((Object)kind);
    }

    private void add(Entry.Kind kind, Entry entry) {
        this.contents.put(kind, entry);
    }

    public static class Annotations
    implements Entry {
        private List<Attribute.TypeCompound> annos;
        public static final List<Attribute.TypeCompound> TO_BE_SET = List.nil();

        public Annotations(List<Attribute.TypeCompound> list) {
            this.annos = list;
        }

        public List<Attribute.TypeCompound> getAnnotations() {
            return this.annos;
        }

        @Override
        public Annotations combine(Entry entry) {
            Assert.check(this.annos == TO_BE_SET);
            this.annos = ((Annotations)entry).annos;
            return this;
        }

        @Override
        public Entry.Kind kind() {
            return Entry.Kind.ANNOTATIONS;
        }

        public String toString() {
            return "ANNOTATIONS [ " + this.annos + " ]";
        }
    }

    public static interface Entry {
        public Kind kind();

        public Entry combine(Entry var1);

        public static enum Kind {
            ANNOTATIONS;

        }
    }
}

