/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core;

import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreNSAwareElement;
import org.apache.axiom.core.CoreNSUnawareElement;
import org.apache.axiom.core.impl.mixin.CoreNSUnawareNamedNodeSupport;

public interface ElementMatcher<T extends CoreElement> {
    public static final ElementMatcher<CoreElement> ANY = new ElementMatcher<CoreElement>(){

        @Override
        public boolean matches(CoreElement element, String namespaceURI, String name) {
            return true;
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_QNAME = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return name.equals(element.coreGetLocalName()) && namespaceURI.equals(element.coreGetNamespaceURI());
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_NAMESPACE_URI = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return namespaceURI.equals(element.coreGetNamespaceURI());
        }
    };
    public static final ElementMatcher<CoreNSAwareElement> BY_LOCAL_NAME = new ElementMatcher<CoreNSAwareElement>(){

        @Override
        public boolean matches(CoreNSAwareElement element, String namespaceURI, String name) {
            return name.equals(element.coreGetLocalName());
        }
    };
    public static final ElementMatcher<CoreElement> BY_NAME = new ElementMatcher<CoreElement>(){

        @Override
        public boolean matches(CoreElement element, String namespaceURI, String name) {
            if (element instanceof CoreNSUnawareElement) {
                return name.equals(CoreNSUnawareNamedNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_impl_mixin_CoreNSUnawareNamedNodeSupport$org_apache_axiom_core_CoreNSUnawareNamedNode$coreGetName((CoreNSUnawareElement)element));
            }
            CoreNSAwareElement nsAwareElement = (CoreNSAwareElement)element;
            String prefix = nsAwareElement.coreGetPrefix();
            int prefixLength = prefix.length();
            String localName = nsAwareElement.coreGetLocalName();
            if (prefixLength == 0) {
                return name.equals(localName);
            }
            int localNameLength = localName.length();
            if (prefixLength + localNameLength + 1 == name.length()) {
                if (name.charAt(prefixLength) != ':') {
                    return false;
                }
                int i = 0;
                while (i < localNameLength) {
                    if (name.charAt(prefixLength + i + 1) != localName.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
                i = 0;
                while (i < prefix.length()) {
                    if (name.charAt(i) != prefix.charAt(i)) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            return false;
        }
    };

    public boolean matches(T var1, String var2, String var3);
}

