/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.cloud.util;

import java.util.Iterator;
import java.util.Set;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.control.nc.io.IOManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudFileUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private CloudFileUtil() {
    }

    public static void cleanDirectoryFiles(IOManager ioManager, Set<String> cloudFiles, FileReference partitionPath) throws HyracksDataException {
        Set localFiles = ioManager.list(partitionPath);
        Iterator localFilesIter = localFiles.iterator();
        LOGGER.info("Cleaning partition {}.", (Object)partitionPath.getRelativePath());
        while (localFilesIter.hasNext()) {
            FileReference file = (FileReference)localFilesIter.next();
            if (file.getFile().isDirectory()) continue;
            String path = file.getRelativePath();
            if (!cloudFiles.contains(path)) {
                CloudFileUtil.logDeleteFile(file);
                localFilesIter.remove();
                ioManager.delete(file);
                continue;
            }
            cloudFiles.remove(path);
        }
        for (String cloudFile : cloudFiles) {
            if (!cloudFile.contains(partitionPath.getRelativePath())) continue;
            localFiles.add(new FileReference(partitionPath.getDeviceHandle(), cloudFile.substring(cloudFile.indexOf(partitionPath.getRelativePath()))));
        }
    }

    private static void logDeleteFile(FileReference fileReference) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting {} from the local cache as {} doesn't exist in the cloud", (Object)fileReference, (Object)fileReference.getRelativePath());
        }
    }
}

