/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.writer;

import org.apache.asterix.runtime.writer.IPathResolver;

abstract class AbstractPathResolver
implements IPathResolver {
    private static final int PREFIX_NUMBER_OF_DIGITS = 4;
    private static final String PREFIX_FILE_FORMAT = "%04d";
    private static final String FILE_COUNTER_FORMAT = "%0" + AbstractPathResolver.getMaxNumberOfDigits() + "d";
    private final String fileExtension;
    private final int fileCounterOffset;
    private final StringBuilder fileStringBuilder;
    protected final char fileSeparator;
    private long fileCounter;

    AbstractPathResolver(String fileExtension, char fileSeparator, int partition) {
        this.fileExtension = fileExtension;
        this.fileSeparator = fileSeparator;
        this.fileStringBuilder = new StringBuilder();
        this.fileCounterOffset = AbstractPathResolver.initFileBuilder(this.fileStringBuilder, partition, fileExtension);
        this.fileCounter = 0L;
    }

    @Override
    public final String getNextFileName() {
        this.fileStringBuilder.setLength(this.fileCounterOffset);
        this.fileStringBuilder.append(String.format(FILE_COUNTER_FORMAT, this.fileCounter++));
        if (this.fileExtension != null && !this.fileExtension.isEmpty()) {
            this.fileStringBuilder.append('.');
            this.fileStringBuilder.append(this.fileExtension);
        }
        return this.fileStringBuilder.toString();
    }

    private static int initFileBuilder(StringBuilder fileStringBuilder, int partition, String fileExtension) {
        fileStringBuilder.append(String.format(PREFIX_FILE_FORMAT, partition));
        fileStringBuilder.append('-');
        int offset = fileStringBuilder.length();
        fileStringBuilder.append(String.format(FILE_COUNTER_FORMAT, 0));
        if (fileExtension != null && !fileExtension.isEmpty()) {
            fileStringBuilder.append('.');
            fileStringBuilder.append(fileExtension);
        }
        return offset;
    }

    private static int getMaxNumberOfDigits() {
        return Long.toString(Long.MAX_VALUE).length();
    }
}

