/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.dataflow.data.nontagged.serde.ACircleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARectangleSerializerDeserializer;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.SpatialUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class SpatialAreaDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = SpatialAreaDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
                    private final DataOutput out = this.resultStorage.getDataOutput();
                    private final IPointable argPtr = new VoidPointable();
                    private final IScalarEvaluator eval;
                    {
                        this.eval = args[0].createScalarEvaluator(ctx);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
                        this.resultStorage.reset();
                        this.eval.evaluate(tuple, this.argPtr);
                        if (PointableHelper.checkAndSetMissingOrNull(result, this.argPtr)) {
                            return;
                        }
                        try {
                            byte[] bytes = this.argPtr.getByteArray();
                            int offset = this.argPtr.getStartOffset();
                            ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
                            double area = 0.0;
                            switch (tag) {
                                case POLYGON: {
                                    short numOfPoints = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                                    if (numOfPoints < 3) {
                                        throw new InvalidDataFormatException(SpatialAreaDescriptor.this.sourceLoc, SpatialAreaDescriptor.this.getIdentifier(), ATypeTag.SERIALIZED_POLYGON_TYPE_TAG);
                                    }
                                    area = Math.abs(SpatialUtils.polygonArea(bytes, offset, numOfPoints));
                                    this.out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                                    this.out.writeDouble(area);
                                    break;
                                }
                                case CIRCLE: {
                                    double radius = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ACircleSerializerDeserializer.getRadiusOffset()));
                                    area = SpatialUtils.pi() * radius * radius;
                                    this.out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                                    this.out.writeDouble(area);
                                    break;
                                }
                                case RECTANGLE: {
                                    double x1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.X)));
                                    double y1 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getBottomLeftCoordinateOffset((Coordinate)Coordinate.Y)));
                                    double x2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.X)));
                                    double y2 = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1 + ARectangleSerializerDeserializer.getUpperRightCoordinateOffset((Coordinate)Coordinate.Y)));
                                    area = (x2 - x1) * (y2 - y1);
                                    this.out.writeByte(ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG);
                                    this.out.writeDouble(area);
                                    break;
                                }
                                default: {
                                    throw new TypeMismatchException(SpatialAreaDescriptor.this.sourceLoc, SpatialAreaDescriptor.this.getIdentifier(), 0, bytes[offset], ATypeTag.SERIALIZED_POLYGON_TYPE_TAG, ATypeTag.SERIALIZED_CIRCLE_TYPE_TAG, ATypeTag.SERIALIZED_RECTANGLE_TYPE_TAG);
                                }
                            }
                        }
                        catch (IOException e) {
                            throw HyracksDataException.create((Throwable)e);
                        }
                        result.set((IValueReference)this.resultStorage);
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SPATIAL_AREA;
    }
}

