/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.visitor;

import java.util.ArrayList;
import java.util.Map;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ProjectionFiltrationTypeUtil;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.AnyExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ArrayExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.asterix.optimizer.rules.pushdown.schema.ObjectExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.RootExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.UnionExpectedSchemaNode;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.asterix.runtime.projection.ProjectionFiltrationWarningFactoryProvider;

public class ExpectedSchemaNodeToIATypeTranslatorVisitor
implements IExpectedSchemaNodeVisitor<IAType, String> {
    private final Map<String, FunctionCallInformation> sourceInformationMap;
    private int counter;

    public ExpectedSchemaNodeToIATypeTranslatorVisitor(Map<String, FunctionCallInformation> sourceInformationMap) {
        this.sourceInformationMap = sourceInformationMap;
    }

    @Override
    public IAType visit(RootExpectedSchemaNode node, String arg) {
        if (node.isAllFields()) {
            return ProjectionFiltrationTypeUtil.ALL_FIELDS_TYPE;
        }
        if (node.isEmpty()) {
            return ProjectionFiltrationTypeUtil.EMPTY_TYPE;
        }
        return this.createRecordType(node, String.valueOf(this.counter++));
    }

    @Override
    public IAType visit(ObjectExpectedSchemaNode node, String arg) {
        ARecordType recordType = this.createRecordType(node, arg);
        this.sourceInformationMap.put(arg, this.createFunctionCallInformation(node));
        return recordType;
    }

    @Override
    public IAType visit(ArrayExpectedSchemaNode node, String arg) {
        IAType itemType = node.getChild().accept(this, String.valueOf(this.counter++));
        AOrderedListType listType = new AOrderedListType(itemType, arg);
        this.sourceInformationMap.put(arg, this.createFunctionCallInformation(node));
        return listType;
    }

    @Override
    public IAType visit(UnionExpectedSchemaNode node, String arg) {
        ArrayList<IAType> unionTypes = new ArrayList<IAType>();
        for (Map.Entry<ExpectedSchemaNodeType, AbstractComplexExpectedSchemaNode> child : node.getChildren()) {
            unionTypes.add(child.getValue().accept(this, String.valueOf(this.counter++)));
        }
        AUnionType unionType = new AUnionType(unionTypes, arg);
        this.sourceInformationMap.put(arg, this.createFunctionCallInformation(node));
        return unionType;
    }

    @Override
    public IAType visit(AnyExpectedSchemaNode node, String arg) {
        return BuiltinType.ANY;
    }

    private ARecordType createRecordType(ObjectExpectedSchemaNode node, String arg) {
        Map<String, IExpectedSchemaNode> children = node.getChildren();
        String[] childrenFieldNames = new String[children.size()];
        IAType[] childrenTypes = new IAType[children.size()];
        int i = 0;
        for (Map.Entry<String, IExpectedSchemaNode> child : children.entrySet()) {
            childrenFieldNames[i] = child.getKey();
            childrenTypes[i++] = child.getValue().accept(this, String.valueOf(this.counter++));
        }
        return new ARecordType(arg, childrenFieldNames, childrenTypes, true);
    }

    private FunctionCallInformation createFunctionCallInformation(IExpectedSchemaNode node) {
        return new FunctionCallInformation(node.getFunctionName(), node.getSourceLocation(), ProjectionFiltrationWarningFactoryProvider.TYPE_MISMATCH_FACTORY);
    }
}

