/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.base.AnalysisUtil;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;

public class OptimizableOperatorSubTree {
    private ILogicalOperator root = null;
    private Mutable<ILogicalOperator> rootRef = null;
    private final List<Mutable<ILogicalOperator>> assignsAndUnnestsRefs = new ArrayList<Mutable<ILogicalOperator>>();
    private final List<AbstractLogicalOperator> assignsAndUnnests = new ArrayList<AbstractLogicalOperator>();
    private final Pair<Integer, Integer> lastMatchedDataSourceVars = new Pair((Object)-1, (Object)-1);
    private Mutable<ILogicalOperator> dataSourceRef = null;
    private DataSourceType dataSourceType = DataSourceType.NO_DATASOURCE;
    private Dataset dataset = null;
    private ARecordType recordType = null;
    private ARecordType metaRecordType = null;
    private Map<LogicalVariable, List<String>> varsToFieldNameMap = new HashMap<LogicalVariable, List<String>>();
    private List<Mutable<ILogicalOperator>> ixJoinOuterAdditionalDataSourceRefs = null;
    private List<DataSourceType> ixJoinOuterAdditionalDataSourceTypes = null;
    private List<Dataset> ixJoinOuterAdditionalDatasets = null;
    private List<ARecordType> ixJoinOuterAdditionalRecordTypes = null;
    private final Map<LogicalVariable, RecordTypeSource> varsToRecordType = new HashMap<LogicalVariable, RecordTypeSource>();

    public boolean initFromSubTree(Mutable<ILogicalOperator> subTreeOpRef) throws AlgebricksException {
        this.reset();
        this.rootRef = subTreeOpRef;
        this.root = (ILogicalOperator)subTreeOpRef.getValue();
        boolean passedSource = false;
        boolean result = false;
        Mutable searchOpRef = subTreeOpRef;
        AbstractLogicalOperator subTreeOp = (AbstractLogicalOperator)searchOpRef.getValue();
        do {
            if (subTreeOp.getOperatorTag() == LogicalOperatorTag.SELECT) {
                searchOpRef = (Mutable)subTreeOp.getInputs().get(0);
                subTreeOp = (AbstractLogicalOperator)searchOpRef.getValue();
            }
            if (subTreeOp.getOperatorTag() != LogicalOperatorTag.ASSIGN && subTreeOp.getOperatorTag() != LogicalOperatorTag.UNNEST) {
                result = this.initializeDataSource((Mutable<ILogicalOperator>)searchOpRef);
                passedSource = true;
                if (!subTreeOp.getInputs().isEmpty()) {
                    searchOpRef = (Mutable)subTreeOp.getInputs().get(0);
                    subTreeOp = (AbstractLogicalOperator)searchOpRef.getValue();
                }
            }
            while (subTreeOp.getOperatorTag() == LogicalOperatorTag.ASSIGN || subTreeOp.getOperatorTag() == LogicalOperatorTag.UNNEST) {
                if (!passedSource && !OperatorPropertiesUtil.isMovable((ILogicalOperator)subTreeOp)) {
                    return false;
                }
                if (subTreeOp.getExecutionMode() != AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
                    this.assignsAndUnnestsRefs.add((Mutable<ILogicalOperator>)searchOpRef);
                }
                this.assignsAndUnnests.add(subTreeOp);
                searchOpRef = (Mutable)subTreeOp.getInputs().get(0);
                subTreeOp = (AbstractLogicalOperator)searchOpRef.getValue();
            }
            if (!passedSource) continue;
            return result;
        } while (subTreeOp.getOperatorTag() == LogicalOperatorTag.SELECT);
        return this.initializeDataSource((Mutable<ILogicalOperator>)searchOpRef);
    }

    private boolean initializeDataSource(Mutable<ILogicalOperator> subTreeOpRef) throws AlgebricksException {
        AbstractLogicalOperator subTreeOp = (AbstractLogicalOperator)subTreeOpRef.getValue();
        if (subTreeOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
            this.setDataSourceType(DataSourceType.DATASOURCE_SCAN);
            this.setDataSourceRef(subTreeOpRef);
            return true;
        }
        if (subTreeOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
            this.setDataSourceType(DataSourceType.COLLECTION_SCAN);
            this.setDataSourceRef(subTreeOpRef);
            return true;
        }
        if (subTreeOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
            boolean dataSourceFound = false;
            while (true) {
                if (subTreeOp.getOperatorTag() == LogicalOperatorTag.UNNEST_MAP) {
                    UnnestMapOperator unnestMapOp = (UnnestMapOperator)subTreeOp;
                    ILogicalExpression unnestExpr = (ILogicalExpression)unnestMapOp.getExpressionRef().getValue();
                    if (unnestExpr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL) {
                        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                        if (f.getFunctionIdentifier().equals((Object)BuiltinFunctions.INDEX_SEARCH)) {
                            AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                            jobGenParams.readFromFuncArgs(f.getArguments());
                            if (jobGenParams.isPrimaryIndex()) {
                                this.initializeDataSourceRefAndType(DataSourceType.PRIMARY_INDEX_LOOKUP, (Mutable<ILogicalOperator>)subTreeOpRef);
                                dataSourceFound = true;
                            } else if (unnestMapOp.getGenerateCallBackProceedResultVar()) {
                                this.initializeDataSourceRefAndType(DataSourceType.INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP, (Mutable<ILogicalOperator>)subTreeOpRef);
                                dataSourceFound = true;
                            }
                        } else if (f.getFunctionIdentifier().equals((Object)BuiltinFunctions.EXTERNAL_LOOKUP)) {
                            if (this.getDataSourceRef() == null) {
                                this.setDataSourceRef((Mutable<ILogicalOperator>)subTreeOpRef);
                                this.setDataSourceType(DataSourceType.EXTERNAL_SCAN);
                            } else {
                                this.initializeIxJoinOuterAddtionalDataSourcesIfEmpty();
                                this.getIxJoinOuterAdditionalDataSourceTypes().add(DataSourceType.EXTERNAL_SCAN);
                                this.getIxJoinOuterAdditionalDataSourceRefs().add((Mutable<ILogicalOperator>)subTreeOpRef);
                            }
                            dataSourceFound = true;
                        }
                    }
                } else if (subTreeOp.getOperatorTag() == LogicalOperatorTag.DATASOURCESCAN) {
                    this.initializeIxJoinOuterAddtionalDataSourcesIfEmpty();
                    this.getIxJoinOuterAdditionalDataSourceTypes().add(DataSourceType.DATASOURCE_SCAN);
                    this.getIxJoinOuterAdditionalDataSourceRefs().add(subTreeOpRef);
                    dataSourceFound = true;
                } else if (subTreeOp.getOperatorTag() == LogicalOperatorTag.EMPTYTUPLESOURCE) {
                    this.initializeIxJoinOuterAddtionalDataSourcesIfEmpty();
                    this.getIxJoinOuterAdditionalDataSourceTypes().add(DataSourceType.COLLECTION_SCAN);
                    this.getIxJoinOuterAdditionalDataSourceRefs().add((Mutable<ILogicalOperator>)subTreeOpRef);
                }
                if (!subTreeOp.hasInputs()) break;
                subTreeOpRef = (Mutable)subTreeOp.getInputs().get(0);
                subTreeOp = (AbstractLogicalOperator)subTreeOpRef.getValue();
            }
            if (dataSourceFound) {
                return true;
            }
        }
        return false;
    }

    private void initializeDataSourceRefAndType(DataSourceType dsType, Mutable<ILogicalOperator> opRef) {
        if (this.getDataSourceRef() == null) {
            this.setDataSourceRef(opRef);
            this.setDataSourceType(dsType);
        } else {
            this.initializeIxJoinOuterAddtionalDataSourcesIfEmpty();
            this.getIxJoinOuterAdditionalDataSourceTypes().add(dsType);
            this.getIxJoinOuterAdditionalDataSourceRefs().add(opRef);
        }
    }

    public boolean setDatasetAndTypeMetadata(MetadataProvider metadataProvider) throws AlgebricksException {
        int i;
        ArrayList<Mutable<ILogicalOperator>> sourceOpRefs = new ArrayList<Mutable<ILogicalOperator>>();
        ArrayList<DataSourceType> dsTypes = new ArrayList<DataSourceType>();
        sourceOpRefs.add(this.getDataSourceRef());
        dsTypes.add(this.getDataSourceType());
        if (this.getIxJoinOuterAdditionalDataSourceRefs() != null) {
            for (i = 0; i < this.getIxJoinOuterAdditionalDataSourceRefs().size(); ++i) {
                sourceOpRefs.add(this.getIxJoinOuterAdditionalDataSourceRefs().get(i));
                dsTypes.add(this.getIxJoinOuterAdditionalDataSourceTypes().get(i));
            }
        }
        block7: for (i = 0; i < sourceOpRefs.size(); ++i) {
            List vars;
            String datasetName;
            DataverseName dataverseName;
            String database;
            switch ((DataSourceType)((Object)dsTypes.get(i))) {
                case DATASOURCE_SCAN: {
                    byte dsType;
                    DataSourceScanOperator dataSourceScan = (DataSourceScanOperator)((Mutable)sourceOpRefs.get(i)).getValue();
                    IDataSource datasource = dataSourceScan.getDataSource();
                    if (datasource instanceof DataSource && (dsType = ((DataSource)datasource).getDatasourceType()) != 0 && dsType != 1) {
                        return false;
                    }
                    DataSourceId srcId = (DataSourceId)dataSourceScan.getDataSource().getId();
                    database = srcId.getDatabaseName();
                    dataverseName = srcId.getDataverseName();
                    datasetName = srcId.getDatasourceName();
                    vars = dataSourceScan.getScanVariables();
                    break;
                }
                case PRIMARY_INDEX_LOOKUP: 
                case INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP: {
                    AbstractUnnestOperator unnestMapOp = (AbstractUnnestOperator)((Mutable)sourceOpRefs.get(i)).getValue();
                    ILogicalExpression unnestExpr = (ILogicalExpression)unnestMapOp.getExpressionRef().getValue();
                    AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)unnestExpr;
                    AccessMethodJobGenParams jobGenParams = new AccessMethodJobGenParams();
                    jobGenParams.readFromFuncArgs(f.getArguments());
                    datasetName = jobGenParams.getDatasetName();
                    dataverseName = jobGenParams.getDataverseName();
                    database = jobGenParams.getDatabaseName();
                    vars = unnestMapOp.getScanVariables();
                    break;
                }
                case EXTERNAL_SCAN: {
                    UnnestMapOperator externalScan = (UnnestMapOperator)((Mutable)sourceOpRefs.get(i)).getValue();
                    Triple<DataverseName, String, String> datasetInfo = AnalysisUtil.getExternalDatasetInfo(externalScan);
                    dataverseName = (DataverseName)datasetInfo.first;
                    datasetName = (String)datasetInfo.second;
                    database = (String)datasetInfo.third;
                    vars = externalScan.getScanVariables();
                    break;
                }
                case COLLECTION_SCAN: {
                    if (i == 0) continue block7;
                    this.getIxJoinOuterAdditionalDatasets().add(null);
                    this.getIxJoinOuterAdditionalRecordTypes().add(null);
                    continue block7;
                }
                default: {
                    return false;
                }
            }
            if (dataverseName == null || datasetName == null) {
                return false;
            }
            Dataset ds = metadataProvider.findDataset(database, dataverseName, datasetName);
            if (ds == null) {
                throw new CompilationException(ErrorCode.NO_METADATA_FOR_DATASET, this.root.getSourceLocation(), new Serializable[]{datasetName});
            }
            IAType itemType = metadataProvider.findType(ds.getItemTypeDatabaseName(), ds.getItemTypeDataverseName(), ds.getItemTypeName());
            if (itemType.getTypeTag() != ATypeTag.OBJECT) {
                if (i == 0) {
                    return false;
                }
                this.getIxJoinOuterAdditionalDatasets().add(null);
                this.getIxJoinOuterAdditionalRecordTypes().add(null);
            }
            ARecordType rType = (ARecordType)itemType;
            ARecordType metaItemType = (ARecordType)metadataProvider.findType(ds.getMetaItemTypeDatabaseName(), ds.getMetaItemTypeDataverseName(), ds.getMetaItemTypeName());
            rType = (ARecordType)metadataProvider.findTypeForDatasetWithoutType((IAType)rType, (IAType)metaItemType, ds);
            if (i == 0) {
                this.setDataset(ds);
                this.setRecordType(rType);
                this.setMetaRecordType(metaItemType);
            } else {
                this.getIxJoinOuterAdditionalDatasets().add(ds);
                this.getIxJoinOuterAdditionalRecordTypes().add(rType);
            }
            if (vars.isEmpty()) continue;
            int numVars = vars.size();
            if (ds.hasMetaPart()) {
                this.varsToRecordType.put((LogicalVariable)vars.get(numVars - 2), new RecordTypeSource(rType, 0));
                this.varsToRecordType.put((LogicalVariable)vars.get(numVars - 1), new RecordTypeSource(metaItemType, 1));
                continue;
            }
            this.varsToRecordType.put((LogicalVariable)vars.get(numVars - 1), new RecordTypeSource(rType, 0));
        }
        return true;
    }

    public boolean hasDataSource() {
        return this.getDataSourceType() != DataSourceType.NO_DATASOURCE;
    }

    public boolean hasIxJoinOuterAdditionalDataSource() {
        boolean dataSourceFound = false;
        if (this.getIxJoinOuterAdditionalDataSourceTypes() != null) {
            for (int i = 0; i < this.getIxJoinOuterAdditionalDataSourceTypes().size(); ++i) {
                if (this.getIxJoinOuterAdditionalDataSourceTypes().get(i) == DataSourceType.NO_DATASOURCE) continue;
                dataSourceFound = true;
                break;
            }
        }
        return dataSourceFound;
    }

    public boolean hasDataSourceScan() {
        return this.getDataSourceType() == DataSourceType.DATASOURCE_SCAN;
    }

    public void reset() {
        this.setRoot(null);
        this.setRootRef(null);
        this.getAssignsAndUnnestsRefs().clear();
        this.getAssignsAndUnnests().clear();
        this.getVarsToFieldNameMap().clear();
        this.setDataSourceRef(null);
        this.setDataSourceType(DataSourceType.NO_DATASOURCE);
        this.setIxJoinOuterAdditionalDataSourceRefs(null);
        this.setIxJoinOuterAdditionalDataSourceTypes(null);
        this.setDataset(null);
        this.setIxJoinOuterAdditionalDatasets(null);
        this.setRecordType(null);
        this.setMetaRecordType(null);
        this.setIxJoinOuterAdditionalRecordTypes(null);
        this.lastMatchedDataSourceVars.first = -1;
        this.lastMatchedDataSourceVars.second = -1;
        this.varsToRecordType.clear();
    }

    public void getPrimaryKeyVars(Mutable<ILogicalOperator> dataSourceRefToFetch, List<LogicalVariable> target) throws AlgebricksException {
        Mutable<ILogicalOperator> dataSourceRefToFetchKey = dataSourceRefToFetch == null ? this.dataSourceRef : dataSourceRefToFetch;
        switch (this.dataSourceType) {
            case DATASOURCE_SCAN: {
                DataSourceScanOperator dataSourceScan = (DataSourceScanOperator)this.getDataSourceRef().getValue();
                int numPrimaryKeys = this.dataset.getPrimaryKeys().size();
                for (int i = 0; i < numPrimaryKeys; ++i) {
                    target.add((LogicalVariable)dataSourceScan.getVariables().get(i));
                }
                break;
            }
            case PRIMARY_INDEX_LOOKUP: {
                AbstractUnnestMapOperator unnestMapOp = (AbstractUnnestMapOperator)dataSourceRefToFetchKey.getValue();
                List<LogicalVariable> primaryKeys = null;
                primaryKeys = AccessMethodUtils.getPrimaryKeyVarsFromPrimaryUnnestMap(this.dataset, (ILogicalOperator)unnestMapOp);
                target.addAll(primaryKeys);
                break;
            }
            case INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP: {
                AbstractUnnestMapOperator idxOnlyPlanUnnestMapOp = (AbstractUnnestMapOperator)dataSourceRefToFetchKey.getValue();
                List idxOnlyPlanKeyVars = idxOnlyPlanUnnestMapOp.getVariables();
                int indexOnlyPlanNumPrimaryKeys = this.dataset.getPrimaryKeys().size();
                int start = idxOnlyPlanKeyVars.size() - 1 - indexOnlyPlanNumPrimaryKeys;
                int end = start + indexOnlyPlanNumPrimaryKeys;
                for (int i = start; i < end; ++i) {
                    target.add((LogicalVariable)idxOnlyPlanKeyVars.get(i));
                }
                break;
            }
            case EXTERNAL_SCAN: 
            case COLLECTION_SCAN: {
                break;
            }
            default: {
                throw new CompilationException(ErrorCode.SUBTREE_HAS_NO_DATA_SOURCE, this.root.getSourceLocation(), new Serializable[0]);
            }
        }
    }

    public List<LogicalVariable> getDataSourceVariables() throws AlgebricksException {
        switch (this.getDataSourceType()) {
            case DATASOURCE_SCAN: 
            case PRIMARY_INDEX_LOOKUP: 
            case EXTERNAL_SCAN: {
                AbstractScanOperator scanOp = (AbstractScanOperator)this.getDataSourceRef().getValue();
                return scanOp.getVariables();
            }
            case INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP: {
                ArrayList<LogicalVariable> pkVars = new ArrayList<LogicalVariable>();
                this.getPrimaryKeyVars(this.dataSourceRef, pkVars);
                return pkVars;
            }
            case COLLECTION_SCAN: {
                return new ArrayList<LogicalVariable>();
            }
        }
        throw new CompilationException(ErrorCode.SUBTREE_HAS_NO_DATA_SOURCE, this.root.getSourceLocation(), new Serializable[0]);
    }

    public List<LogicalVariable> getIxJoinOuterAdditionalDataSourceVariables(int idx) throws AlgebricksException {
        if (this.getIxJoinOuterAdditionalDataSourceRefs() != null && this.getIxJoinOuterAdditionalDataSourceRefs().size() > idx) {
            switch (this.getIxJoinOuterAdditionalDataSourceTypes().get(idx)) {
                case DATASOURCE_SCAN: 
                case PRIMARY_INDEX_LOOKUP: 
                case EXTERNAL_SCAN: {
                    AbstractScanOperator scanOp = (AbstractScanOperator)this.getIxJoinOuterAdditionalDataSourceRefs().get(idx).getValue();
                    return scanOp.getVariables();
                }
                case INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP: {
                    ArrayList<LogicalVariable> PKVars = new ArrayList<LogicalVariable>();
                    this.getPrimaryKeyVars(this.ixJoinOuterAdditionalDataSourceRefs.get(idx), PKVars);
                    return PKVars;
                }
                case COLLECTION_SCAN: {
                    return new ArrayList<LogicalVariable>();
                }
            }
            throw new CompilationException(ErrorCode.SUBTREE_HAS_NO_ADDTIONAL_DATA_SOURCE, this.root.getSourceLocation(), new Serializable[0]);
        }
        return null;
    }

    public void initializeIxJoinOuterAddtionalDataSourcesIfEmpty() {
        if (this.getIxJoinOuterAdditionalDataSourceRefs() == null) {
            this.setIxJoinOuterAdditionalDataSourceRefs(new ArrayList<Mutable<ILogicalOperator>>());
            this.setIxJoinOuterAdditionalDataSourceTypes(new ArrayList<DataSourceType>());
            this.setIxJoinOuterAdditionalDatasets(new ArrayList<Dataset>());
            this.setIxJoinOuterAdditionalRecordTypes(new ArrayList<ARecordType>());
        }
    }

    public ILogicalOperator getRoot() {
        return this.root;
    }

    public void setRoot(ILogicalOperator root) {
        this.root = root;
    }

    public Mutable<ILogicalOperator> getRootRef() {
        return this.rootRef;
    }

    public void setRootRef(Mutable<ILogicalOperator> rootRef) {
        this.rootRef = rootRef;
    }

    public List<Mutable<ILogicalOperator>> getAssignsAndUnnestsRefs() {
        return this.assignsAndUnnestsRefs;
    }

    public List<AbstractLogicalOperator> getAssignsAndUnnests() {
        return this.assignsAndUnnests;
    }

    public Mutable<ILogicalOperator> getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(Mutable<ILogicalOperator> dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public DataSourceType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSourceType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public ARecordType getRecordType() {
        return this.recordType;
    }

    public RecordTypeSource getRecordTypeFor(LogicalVariable var) {
        return this.varsToRecordType.get(var);
    }

    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    public ARecordType getMetaRecordType() {
        return this.metaRecordType;
    }

    public void setMetaRecordType(ARecordType metaRecordType) {
        this.metaRecordType = metaRecordType;
    }

    public List<Mutable<ILogicalOperator>> getIxJoinOuterAdditionalDataSourceRefs() {
        return this.ixJoinOuterAdditionalDataSourceRefs;
    }

    public void setIxJoinOuterAdditionalDataSourceRefs(List<Mutable<ILogicalOperator>> ixJoinOuterAdditionalDataSourceRefs) {
        this.ixJoinOuterAdditionalDataSourceRefs = ixJoinOuterAdditionalDataSourceRefs;
    }

    public List<DataSourceType> getIxJoinOuterAdditionalDataSourceTypes() {
        return this.ixJoinOuterAdditionalDataSourceTypes;
    }

    public void setIxJoinOuterAdditionalDataSourceTypes(List<DataSourceType> ixJoinOuterAdditionalDataSourceTypes) {
        this.ixJoinOuterAdditionalDataSourceTypes = ixJoinOuterAdditionalDataSourceTypes;
    }

    public List<Dataset> getIxJoinOuterAdditionalDatasets() {
        return this.ixJoinOuterAdditionalDatasets;
    }

    public void setIxJoinOuterAdditionalDatasets(List<Dataset> ixJoinOuterAdditionalDatasets) {
        this.ixJoinOuterAdditionalDatasets = ixJoinOuterAdditionalDatasets;
    }

    public List<ARecordType> getIxJoinOuterAdditionalRecordTypes() {
        return this.ixJoinOuterAdditionalRecordTypes;
    }

    public void setIxJoinOuterAdditionalRecordTypes(List<ARecordType> ixJoinOuterAdditionalRecordTypes) {
        this.ixJoinOuterAdditionalRecordTypes = ixJoinOuterAdditionalRecordTypes;
    }

    public Map<LogicalVariable, List<String>> getVarsToFieldNameMap() {
        return this.varsToFieldNameMap;
    }

    public Pair<Integer, Integer> getLastMatchedDataSourceVars() {
        return this.lastMatchedDataSourceVars;
    }

    public void setLastMatchedDataSourceVars(int varIndex, int optVarIndex) {
        this.lastMatchedDataSourceVars.first = varIndex;
        this.lastMatchedDataSourceVars.second = optVarIndex;
    }

    public static enum DataSourceType {
        DATASOURCE_SCAN,
        EXTERNAL_SCAN,
        PRIMARY_INDEX_LOOKUP,
        COLLECTION_SCAN,
        INDEXONLY_PLAN_SECONDARY_INDEX_LOOKUP,
        NO_DATASOURCE;

    }

    public static class RecordTypeSource {
        final ARecordType recordType;
        final int sourceIndicator;

        RecordTypeSource(ARecordType recordType, int sourceIndicator) {
            this.recordType = recordType;
            this.sourceIndicator = sourceIndicator;
        }
    }
}

