/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.asterix.algebra.operators.CommitOperator;
import org.apache.asterix.common.cluster.PartitioningProperties;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.am.AbstractIntroduceAccessMethodRule;
import org.apache.asterix.optimizer.rules.am.AccessMethodAnalysisContext;
import org.apache.asterix.optimizer.rules.am.AccessMethodUtils;
import org.apache.asterix.optimizer.rules.am.ArrayBTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.BTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.IAccessMethod;
import org.apache.asterix.optimizer.rules.am.InvertedIndexAccessMethod;
import org.apache.asterix.optimizer.rules.am.OptimizableOperatorSubTree;
import org.apache.asterix.optimizer.rules.am.RTreeAccessMethod;
import org.apache.asterix.optimizer.rules.am.array.IIntroduceAccessMethodRuleLocalRewrite;
import org.apache.asterix.optimizer.rules.am.array.MergedSelectRewrite;
import org.apache.asterix.optimizer.rules.am.array.SelectFromSubplanRewrite;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class IntroduceSelectAccessMethodRule
extends AbstractIntroduceAccessMethodRule {
    protected Mutable<ILogicalOperator> selectRef = null;
    protected SelectOperator selectOp = null;
    protected AbstractFunctionCallExpression selectCond = null;
    protected IVariableTypeEnvironment typeEnvironment = null;
    protected final OptimizableOperatorSubTree subTree = new OptimizableOperatorSubTree();
    protected List<Mutable<ILogicalOperator>> afterSelectRefs = null;
    private final SelectFromSubplanRewrite selectFromSubplanRewrite = new SelectFromSubplanRewrite();
    private final MergedSelectRewrite mergedSelectRewrite = new MergedSelectRewrite();
    protected static Map<FunctionIdentifier, List<IAccessMethod>> accessMethods = new HashMap<FunctionIdentifier, List<IAccessMethod>>();

    @Override
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        this.clear();
        this.setMetadataDeclarations(context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        if (op.getOperatorTag() != LogicalOperatorTag.DISTRIBUTE_RESULT && op.getOperatorTag() != LogicalOperatorTag.SINK && op.getOperatorTag() != LogicalOperatorTag.DELEGATE_OPERATOR) {
            return false;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.DELEGATE_OPERATOR && !(((DelegateOperator)op).getDelegate() instanceof CommitOperator)) {
            return false;
        }
        this.afterSelectRefs = new ArrayList<Mutable<ILogicalOperator>>();
        ArrayList<Pair<IAccessMethod, Index>> chosenIndexes = new ArrayList<Pair<IAccessMethod, Index>>();
        Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs = null;
        boolean planTransformed = this.checkAndApplyTheSelectTransformation(opRef, context, false, chosenIndexes, analyzedAMs);
        if (this.selectOp != null) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp);
        }
        if (!planTransformed) {
            return false;
        }
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return planTransformed;
    }

    public boolean checkApplicable(Mutable<ILogicalOperator> opRef, IOptimizationContext context, List<Pair<IAccessMethod, Index>> chosenIndexes, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) throws AlgebricksException {
        this.clear();
        this.setMetadataDeclarations(context);
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op)) {
            return false;
        }
        this.afterSelectRefs = new ArrayList<Mutable<ILogicalOperator>>();
        boolean planTransformed = this.checkAndApplyTheSelectTransformation(opRef, context, true, chosenIndexes, analyzedAMs);
        if (this.selectOp != null) {
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp);
        }
        if (!planTransformed) {
            return false;
        }
        OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
        return planTransformed;
    }

    protected boolean checkSelectOpConditionAndInitSubTree(IOptimizationContext context) throws AlgebricksException {
        ILogicalExpression condExpr = (ILogicalExpression)this.selectOp.getCondition().getValue();
        this.typeEnvironment = context.getOutputTypeEnvironment((ILogicalOperator)this.selectOp);
        if (condExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        this.selectCond = (AbstractFunctionCallExpression)condExpr;
        boolean res = this.subTree.initFromSubTree((Mutable<ILogicalOperator>)((Mutable)this.selectOp.getInputs().get(0)));
        return res && this.subTree.hasDataSourceScan();
    }

    private boolean intersectAllSecondaryIndexes(List<Pair<IAccessMethod, Index>> chosenIndexes, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs, IOptimizationContext context) throws AlgebricksException {
        if (chosenIndexes.size() == 1) {
            throw CompilationException.create((ErrorCode)ErrorCode.CHOSEN_INDEX_COUNT_SHOULD_BE_GREATER_THAN_ONE, (Serializable[])new Serializable[0]);
        }
        Mutable conditionRef = this.selectOp.getCondition();
        ArrayList<ILogicalOperator> subRoots = new ArrayList<ILogicalOperator>();
        for (Pair<IAccessMethod, Index> pair : chosenIndexes) {
            AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(pair.first);
            boolean retainInput = AccessMethodUtils.retainInputs(this.subTree.getDataSourceVariables(), (ILogicalOperator)this.subTree.getDataSourceRef().getValue(), this.afterSelectRefs);
            boolean requiresBroadcast = ((ILogicalOperator)((Mutable)((ILogicalOperator)this.subTree.getDataSourceRef().getValue()).getInputs().get(0)).getValue()).getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED;
            ILogicalOperator subRoot = ((IAccessMethod)pair.first).createIndexSearchPlan(this.afterSelectRefs, this.selectRef, (Mutable<ILogicalExpression>)conditionRef, this.subTree.getAssignsAndUnnestsRefs(), this.subTree, null, (Index)pair.second, analysisCtx, retainInput, false, requiresBroadcast, context, null, null);
            if (subRoot == null) {
                return false;
            }
            subRoots.add(subRoot);
        }
        Index idx = (Index)chosenIndexes.get(0).getSecond();
        ILogicalOperator primaryUnnestOp = this.connectAll2ndarySearchPlanWithIntersect(subRoots, context, idx);
        this.subTree.getDataSourceRef().setValue((Object)primaryUnnestOp);
        return primaryUnnestOp != null;
    }

    private Pair<IAccessMethod, Index> fetchPrimaryIndexAmongChosenIndexes(List<Pair<IAccessMethod, Index>> chosenIndexes) throws AlgebricksException {
        Optional<Pair> primaryIndex = chosenIndexes.stream().filter(pair -> ((Index)pair.second).isPrimaryIndex()).findFirst();
        if (primaryIndex.isPresent()) {
            return primaryIndex.get();
        }
        return null;
    }

    private ILogicalOperator connectAll2ndarySearchPlanWithIntersect(List<ILogicalOperator> subRoots, IOptimizationContext context, Index idx) throws AlgebricksException {
        ILogicalOperator lop = subRoots.get(0);
        ArrayList<List> inputVars = new ArrayList<List>(subRoots.size());
        for (int i = 0; i < subRoots.size(); ++i) {
            if (lop.getOperatorTag() != subRoots.get(i).getOperatorTag()) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, lop.getSourceLocation(), new Serializable[]{"The data source root should have the same operator type."});
            }
            if (lop.getInputs().size() != 1) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, lop.getSourceLocation(), new Serializable[]{"The primary search has multiple inputs."});
            }
            ILogicalOperator curRoot = subRoots.get(i);
            ILogicalOperator curRootInput = (ILogicalOperator)((Mutable)curRoot.getInputs().get(0)).getValue();
            if (curRootInput.getOperatorTag() == LogicalOperatorTag.ORDER) {
                OrderOperator order = (OrderOperator)curRootInput;
                ArrayList<LogicalVariable> orderedColumn = new ArrayList<LogicalVariable>(order.getOrderExpressions().size());
                for (Pair orderExpression : order.getOrderExpressions()) {
                    if (((ILogicalExpression)((Mutable)orderExpression.second).getValue()).getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                        throw new CompilationException(ErrorCode.COMPILATION_ERROR, ((ILogicalExpression)((Mutable)orderExpression.second).getValue()).getSourceLocation(), new Serializable[]{"The order by expression should be variables, but they aren't variables."});
                    }
                    VariableReferenceExpression orderedVar = (VariableReferenceExpression)((Mutable)orderExpression.second).getValue();
                    orderedColumn.add(orderedVar.getVariableReference());
                }
                inputVars.add(orderedColumn);
                continue;
            }
            if (curRootInput.getOperatorTag() == LogicalOperatorTag.DISTINCT) {
                DistinctOperator distinct = (DistinctOperator)curRootInput;
                inputVars.add(distinct.getDistinctByVarList());
                continue;
            }
            throw new CompilationException(ErrorCode.COMPILATION_ILLEGAL_STATE, curRootInput.getSourceLocation(), new Serializable[]{"Operator directly below the primary index search should be either a DISTINCT or an ORDER!"});
        }
        List inputVars0 = (List)inputVars.get(0);
        ArrayList<LogicalVariable> outputVars = new ArrayList<LogicalVariable>(inputVars0.size());
        for (LogicalVariable inputVar : inputVars0) {
            LogicalVariable outputVar = context.newVar();
            outputVars.add(outputVar);
            VariableUtilities.substituteVariables((ILogicalOperator)lop, (LogicalVariable)inputVar, (LogicalVariable)outputVar, (ITypingContext)context);
        }
        PartitioningProperties partitioningProperties = this.metadataProvider.getPartitioningProperties(idx);
        IntersectOperator intersect = new IntersectOperator(outputVars, inputVars, partitioningProperties.getComputeStorageMap());
        intersect.setSourceLocation(lop.getSourceLocation());
        for (ILogicalOperator secondarySearch : subRoots) {
            intersect.getInputs().add((Mutable)secondarySearch.getInputs().get(0));
        }
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)intersect);
        lop.getInputs().set(0, new MutableObject((Object)intersect));
        return lop;
    }

    protected boolean prefix(List<List<String>> list1, List<List<String>> list2) {
        for (int i = 0; i < list1.size(); ++i) {
            List<String> l1 = list1.get(i);
            List<String> l2 = list2.get(i);
            if (l1.size() != l2.size()) {
                return false;
            }
            for (int j = 0; j < l1.size(); ++j) {
                String s2;
                String s1 = l1.get(j);
                if (s1.equals(s2 = l2.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    protected void removeSmallerPrefixIndexes(List<Pair<IAccessMethod, Index>> indexes) throws CompilationException {
        int i;
        int len = indexes.size();
        boolean[] include = new boolean[len];
        for (i = 0; i < len; ++i) {
            include[i] = true;
        }
        for (i = 0; i < len - 1; ++i) {
            if (!include[i]) continue;
            IAccessMethod ami = (IAccessMethod)indexes.get((int)i).first;
            Index indexI = (Index)indexes.get((int)i).second;
            DatasetConfig.IndexType typeI = indexI.getIndexType();
            List<List<String>> fieldNamesI = this.findKeyFieldNames(indexI);
            for (int j = i + 1; j < len; ++j) {
                Index indexJ;
                DatasetConfig.IndexType typeJ;
                IAccessMethod amj;
                if (!include[j] || ami != (amj = (IAccessMethod)indexes.get((int)j).first) || typeI != (typeJ = (indexJ = (Index)indexes.get((int)j).second).getIndexType())) continue;
                List<List<String>> fieldNamesJ = this.findKeyFieldNames(indexJ);
                if (fieldNamesI.size() <= fieldNamesJ.size()) {
                    if (!this.prefix(fieldNamesI, fieldNamesJ)) continue;
                    include[i] = false;
                    continue;
                }
                if (!this.prefix(fieldNamesJ, fieldNamesI)) continue;
                include[j] = false;
            }
        }
        for (i = len - 1; i >= 0; --i) {
            if (include[i]) continue;
            indexes.remove(i);
        }
    }

    protected boolean checkAndApplyTheSelectTransformation(Mutable<ILogicalOperator> opRef, IOptimizationContext context, boolean checkApplicableOnly, List<Pair<IAccessMethod, Index>> chosenIndexes, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        boolean isSelectOp = false;
        IPlanPrettyPrinter pp = context.getPrettyPrinter();
        Mutable<ILogicalOperator> selectRefFromThisOp = null;
        SelectOperator selectOpFromThisOp = null;
        if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
            this.selectRef = opRef;
            this.selectOp = (SelectOperator)op;
            selectRefFromThisOp = opRef;
            selectOpFromThisOp = (SelectOperator)op;
            isSelectOp = true;
        } else {
            this.afterSelectRefs.add(opRef);
        }
        for (Mutable inputOpRef : op.getInputs()) {
            boolean selectFoundAndOptimizationApplied = this.checkAndApplyTheSelectTransformation((Mutable<ILogicalOperator>)inputOpRef, context, checkApplicableOnly, chosenIndexes, analyzedAMs);
            if (!selectFoundAndOptimizationApplied) continue;
            return true;
        }
        if (isSelectOp) {
            this.selectRef = selectRefFromThisOp;
            this.selectOp = selectOpFromThisOp;
            boolean continueCheck = true;
            if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectOp)) {
                continueCheck = false;
            }
            if (!checkApplicableOnly && continueCheck) {
                analyzedAMs = new TreeMap<IAccessMethod, AccessMethodAnalysisContext>();
            }
            if (continueCheck && context.getPhysicalOptimizationConfig().isArrayIndexEnabled() && SelectFromSubplanRewrite.isApplicableForRewriteCursory(this.metadataProvider, (ILogicalOperator)this.selectOp)) {
                if (this.rewriteLocallyAndTransform(this.selectRef, context, this.mergedSelectRewrite, checkApplicableOnly, chosenIndexes, analyzedAMs)) {
                    return true;
                }
                if (this.rewriteLocallyAndTransform(this.selectRef, context, this.selectFromSubplanRewrite, checkApplicableOnly, chosenIndexes, analyzedAMs)) {
                    return true;
                }
            }
            if (continueCheck && !this.checkSelectOpConditionAndInitSubTree(context)) {
                continueCheck = false;
            }
            if (continueCheck && !this.analyzeSelectOrJoinOpConditionAndUpdateAnalyzedAM((ILogicalExpression)this.selectCond, this.subTree.getAssignsAndUnnests(), analyzedAMs, context, this.typeEnvironment)) {
                continueCheck = false;
            }
            if (continueCheck && !this.subTree.setDatasetAndTypeMetadata((MetadataProvider)context.getMetadataProvider())) {
                continueCheck = false;
            }
            if (continueCheck) {
                boolean res;
                this.fillSubTreeIndexExprs(this.subTree, analyzedAMs, context, false);
                this.pruneIndexCandidates(analyzedAMs, context, this.typeEnvironment, false);
                this.chooseAllIndexes(analyzedAMs, chosenIndexes);
                this.removeSmallerPrefixIndexes(chosenIndexes);
                if (chosenIndexes == null || chosenIndexes.isEmpty()) {
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectRef.getValue());
                    return false;
                }
                if (checkApplicableOnly) {
                    return true;
                }
                Pair<IAccessMethod, Index> chosenPrimaryIndex = this.fetchPrimaryIndexAmongChosenIndexes(chosenIndexes);
                if (chosenPrimaryIndex != null) {
                    AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(chosenPrimaryIndex.first);
                    res = ((IAccessMethod)chosenPrimaryIndex.first).applySelectPlanTransformation(this.afterSelectRefs, this.selectRef, this.subTree, (Index)chosenPrimaryIndex.second, analysisCtx, context);
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectRef.getValue());
                } else if (chosenIndexes.size() == 1) {
                    AccessMethodAnalysisContext analysisCtx = analyzedAMs.get(chosenIndexes.get((int)0).first);
                    this.fillFieldNamesInTheSubTree(this.subTree, context);
                    res = ((IAccessMethod)chosenIndexes.get((int)0).first).applySelectPlanTransformation(this.afterSelectRefs, this.selectRef, this.subTree, (Index)chosenIndexes.get((int)0).second, analysisCtx, context);
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectRef.getValue());
                } else {
                    res = this.intersectAllSecondaryIndexes(chosenIndexes, analyzedAMs, context);
                    context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)this.selectRef.getValue());
                }
                if (res) {
                    OperatorPropertiesUtil.typeOpRec(opRef, (IOptimizationContext)context);
                    return res;
                }
            }
            this.selectRef = null;
            this.selectOp = null;
            this.afterSelectRefs.add(opRef);
        }
        this.afterSelectRefs.remove(opRef);
        return false;
    }

    @Override
    public Map<FunctionIdentifier, List<IAccessMethod>> getAccessMethods() {
        return accessMethods;
    }

    private boolean rewriteLocallyAndTransform(Mutable<ILogicalOperator> opRef, IOptimizationContext context, IIntroduceAccessMethodRuleLocalRewrite<SelectOperator> rewriter, boolean checkApplicableOnly, List<Pair<IAccessMethod, Index>> chosenIndexes, Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs) throws AlgebricksException {
        SelectOperator selectRewrite = rewriter.createOperator(this.selectOp, context);
        boolean transformationResult = false;
        if (selectRewrite != null) {
            MutableObject selectRuleInput = new MutableObject((Object)selectRewrite);
            if (checkApplicableOnly) {
                transformationResult = this.checkAndApplyTheSelectTransformation((Mutable<ILogicalOperator>)selectRuleInput, context, checkApplicableOnly, chosenIndexes, analyzedAMs);
            } else {
                ArrayList<Pair<IAccessMethod, Index>> chosenIndexes2 = new ArrayList<Pair<IAccessMethod, Index>>();
                Map<IAccessMethod, AccessMethodAnalysisContext> analyzedAMs2 = null;
                transformationResult = this.checkAndApplyTheSelectTransformation((Mutable<ILogicalOperator>)selectRuleInput, context, checkApplicableOnly, chosenIndexes2, analyzedAMs2);
            }
        }
        this.selectOp = rewriter.restoreBeforeRewrite(null, null);
        this.selectRef = opRef;
        return transformationResult;
    }

    private void clear() {
        this.afterSelectRefs = null;
        this.selectRef = null;
        this.selectOp = null;
        this.selectCond = null;
        this.typeEnvironment = null;
        this.subTree.reset();
    }

    static {
        IntroduceSelectAccessMethodRule.registerAccessMethod(BTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceSelectAccessMethodRule.registerAccessMethod(RTreeAccessMethod.INSTANCE, accessMethods);
        IntroduceSelectAccessMethodRule.registerAccessMethod(InvertedIndexAccessMethod.INSTANCE, accessMethods);
        IntroduceSelectAccessMethodRule.registerAccessMethod(ArrayBTreeAccessMethod.INSTANCE, accessMethods);
        for (Pair<FunctionIdentifier, Boolean> f : ArrayBTreeAccessMethod.INSTANCE.getOptimizableFunctions()) {
            SelectFromSubplanRewrite.addOptimizableFunction((FunctionIdentifier)f.first);
        }
    }
}

