/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.active;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.asterix.active.ActiveManager;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.IActiveRuntime;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputSourceOperatorNodePushable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ActiveSourceOperatorNodePushable
extends AbstractUnaryOutputSourceOperatorNodePushable
implements IActiveRuntime {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final IHyracksTaskContext ctx;
    protected final ActiveManager activeManager;
    protected Thread taskThread;
    protected final ActiveRuntimeId runtimeId;
    private volatile boolean done = false;

    public ActiveSourceOperatorNodePushable(IHyracksTaskContext ctx, ActiveRuntimeId runtimeId) {
        this.ctx = ctx;
        this.activeManager = (ActiveManager)((INcApplicationContext)ctx.getJobletContext().getServiceContext().getApplicationContext()).getActiveManager();
        this.runtimeId = runtimeId;
    }

    @Override
    public ActiveRuntimeId getRuntimeId() {
        return this.runtimeId;
    }

    protected abstract void start() throws HyracksDataException, InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void stop(long timeout, TimeUnit unit) throws HyracksDataException, InterruptedException {
        ActiveSourceOperatorNodePushable activeSourceOperatorNodePushable = this;
        synchronized (activeSourceOperatorNodePushable) {
            if (!this.done) {
                this.abort(timeout, unit);
            }
            while (!this.done) {
                this.wait();
            }
        }
    }

    protected abstract void abort(long var1, TimeUnit var3) throws HyracksDataException, InterruptedException;

    public String toString() {
        return this.runtimeId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() throws HyracksDataException {
        LOGGER.trace("initialize() called on ActiveSourceOperatorNodePushable");
        this.taskThread = Thread.currentThread();
        this.activeManager.registerRuntime(this);
        try {
            this.ctx.sendApplicationMessageToCC((Serializable)((Object)new ActivePartitionMessage(this.runtimeId, this.ctx.getJobletContext().getJobId(), ActivePartitionMessage.Event.RUNTIME_REGISTERED, null, "")), null);
            this.start();
        }
        catch (InterruptedException e) {
            LOGGER.info("ingestion op interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        catch (Exception e) {
            this.logIngestionFailure(e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            ActiveSourceOperatorNodePushable activeSourceOperatorNodePushable = this;
            synchronized (activeSourceOperatorNodePushable) {
                this.done = true;
                this.notifyAll();
            }
            LOGGER.trace("initialize() returning on ActiveSourceOperatorNodePushable");
        }
    }

    public final void deinitialize() throws HyracksDataException {
        this.activeManager.deregisterRuntime(this.runtimeId);
        try {
            this.ctx.sendApplicationMessageToCC((Serializable)((Object)new ActivePartitionMessage(this.runtimeId, this.ctx.getJobletContext().getJobId(), ActivePartitionMessage.Event.RUNTIME_DEREGISTERED, null, "")), null);
        }
        catch (Exception e) {
            LOGGER.info("ingestion op stopped w/ failure", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        finally {
            LOGGER.info("ingestion op stopped");
        }
    }

    public final IFrameWriter getInputFrameWriter(int index) {
        return null;
    }

    private void logIngestionFailure(Exception e) {
        if (e.getCause() instanceof InterruptedException) {
            LOGGER.info("ingestion op interrupted", (Throwable)e);
        } else {
            LOGGER.info("ingestion op failed", (Throwable)e);
        }
    }
}

