/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.twitter;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.CharArrayRecord;
import org.apache.asterix.external.util.IFeedLogManager;
import org.apache.asterix.external.util.TwitterUtil;
import twitter4j.FilterQuery;
import twitter4j.StreamListener;
import twitter4j.TwitterStream;

public class TwitterPushRecordReader
implements IRecordReader<char[]> {
    private LinkedBlockingQueue<String> inputQ;
    private TwitterStream twitterStream;
    private CharArrayRecord record;
    private boolean closed = false;

    public TwitterPushRecordReader(TwitterStream twitterStream, TwitterUtil.TweetListener tweetListener, FilterQuery query) {
        this.init(twitterStream);
        tweetListener.setInputQ(this.inputQ);
        this.twitterStream.addListener((StreamListener)tweetListener);
        this.twitterStream.filter(query);
    }

    public TwitterPushRecordReader(TwitterStream twitterStream, TwitterUtil.TweetListener tweetListener) {
        this.init(twitterStream);
        tweetListener.setInputQ(this.inputQ);
        this.twitterStream.addListener((StreamListener)tweetListener);
        twitterStream.sample();
    }

    public TwitterPushRecordReader(TwitterStream twitterStream, TwitterUtil.UserTweetsListener tweetListener) {
        this.init(twitterStream);
        tweetListener.setInputQ(this.inputQ);
        this.twitterStream.addListener((StreamListener)tweetListener);
        twitterStream.user();
    }

    private void init(TwitterStream twitterStream) {
        this.record = new CharArrayRecord();
        this.inputQ = new LinkedBlockingQueue();
        this.twitterStream = twitterStream;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.twitterStream.clearListeners();
            this.twitterStream.cleanUp();
            this.twitterStream = null;
            this.closed = true;
        }
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.closed;
    }

    @Override
    public IRawRecord<char[]> next() throws IOException, InterruptedException {
        String tweet = this.inputQ.poll();
        if (tweet == null) {
            return null;
        }
        this.record.set(tweet);
        return this.record;
    }

    @Override
    public boolean stop() {
        try {
            this.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void setFeedLogManager(IFeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

