/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.asterix.common.context.BaseOperationTracker;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.asterix.common.dataflow.LSMIndexUtil;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.metadata.MetadataIndexImmutableProperties;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.LogRecord;
import org.apache.asterix.common.utils.TransactionUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentId;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentIdGenerator;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIOOperation;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMOperationTracker;
import org.apache.hyracks.storage.am.lsm.common.api.IoOperationCompleteListener;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.FlushOperation;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PrimaryIndexOperationTracker
extends BaseOperationTracker
implements IoOperationCompleteListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private final AtomicInteger numActiveOperations;
    private final ILogManager logManager;
    private final ILSMComponentIdGenerator idGenerator;
    private boolean flushOnExit = false;
    private boolean flushLogCreated = false;
    private final Map<String, FlushOperation> scheduledFlushes = new HashMap<String, FlushOperation>();
    private long lastFlushTime = System.nanoTime();
    private final Map<String, FlushOperation> lastFlushOperation = new HashMap<String, FlushOperation>();
    private final IIndexCheckpointManagerProvider indexCheckpointManagerProvider;

    public PrimaryIndexOperationTracker(int datasetID, int partition, ILogManager logManager, DatasetInfo dsInfo, ILSMComponentIdGenerator idGenerator, IIndexCheckpointManagerProvider indexCheckpointManagerProvider) {
        super(datasetID, dsInfo, partition);
        this.logManager = logManager;
        this.numActiveOperations = new AtomicInteger();
        this.idGenerator = idGenerator;
        this.indexCheckpointManagerProvider = indexCheckpointManagerProvider;
    }

    @Override
    public void beforeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        super.beforeOperation(index, opType, searchCallback, modificationCallback);
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.incrementNumActiveOperations(modificationCallback);
        }
    }

    @Override
    public synchronized void completeOperation(ILSMIndex index, LSMOperationType opType, ISearchOperationCallback searchCallback, IModificationOperationCallback modificationCallback) throws HyracksDataException {
        super.completeOperation(index, opType, searchCallback, modificationCallback);
        if (opType == LSMOperationType.MODIFICATION || opType == LSMOperationType.FORCE_MODIFICATION) {
            this.decrementNumActiveOperations(modificationCallback);
            this.flushIfNeeded();
        }
    }

    public synchronized void flushIfNeeded() throws HyracksDataException {
        if (this.canSafelyFlush() && !this.isFlushLogCreated()) {
            this.flushIfRequested();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushIfRequested() throws HyracksDataException {
        boolean needsFlush = false;
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        if (!this.flushOnExit) {
            for (ILSMIndex lsmIndex : indexes) {
                if (!lsmIndex.hasFlushRequestForCurrentMutableComponent()) continue;
                needsFlush = true;
                break;
            }
        }
        ILSMIndex primaryLsmIndex = null;
        if (needsFlush || this.flushOnExit) {
            this.flushOnExit = false;
            LSMComponentId primaryId = null;
            PrimaryIndexOperationTracker primaryIndexOperationTracker = this;
            synchronized (primaryIndexOperationTracker) {
                if (this.numActiveOperations.get() > 0) {
                    throw new IllegalStateException("Can't request a flush on an index with active operations: " + this.numActiveOperations.get());
                }
                if (indexes.isEmpty()) {
                    LOGGER.debug("no open indexes on dataset {} and partition {}... skipping flush", (Object)this.dsInfo.getDatasetID(), (Object)this.partition);
                    return;
                }
                for (ILSMIndex lsmIndex : indexes) {
                    if (!lsmIndex.isPrimaryIndex()) continue;
                    if (lsmIndex.isCurrentMutableComponentEmpty()) {
                        LOGGER.trace("Primary index on dataset {} and partition {} is empty... skipping flush", (Object)this.dsInfo.getDatasetID(), (Object)this.partition);
                        return;
                    }
                    primaryLsmIndex = lsmIndex;
                    break;
                }
            }
            if (primaryLsmIndex == null) {
                LOGGER.warn("Primary index not found in dataset {} and partition {} open indexes {}; possible secondary index leaked files", (Object)this.dsInfo.getDatasetID(), (Object)this.partition, indexes);
                return;
            }
            for (ILSMIndex lsmIndex : indexes) {
                ILSMOperationTracker opTracker;
                ILSMOperationTracker iLSMOperationTracker = opTracker = lsmIndex.getOperationTracker();
                synchronized (iLSMOperationTracker) {
                    ILSMMemoryComponent memComponent = lsmIndex.getCurrentMemoryComponent();
                    if (memComponent.getWriterCount() > 0) {
                        if (lsmIndex.isAtomic()) {
                            LOGGER.debug("Can't request a flush on a component with writers inside: Index: {} Component: {}", (Object)lsmIndex, (Object)memComponent);
                            return;
                        }
                        throw new IllegalStateException("Can't request a flush on a component with writers inside: Index:" + lsmIndex + " Component:" + memComponent);
                    }
                    if (memComponent.getState() == ILSMComponent.ComponentState.READABLE_WRITABLE && memComponent.isModified()) {
                        memComponent.setUnwritable();
                    }
                    if (lsmIndex.isPrimaryIndex()) {
                        primaryId = (LSMComponentId)memComponent.getId();
                    }
                }
            }
            if (primaryId == null) {
                throw new IllegalStateException("Primary index found in dataset " + this.dsInfo.getDatasetID() + " and partition " + this.partition + " and is modified but its component id is null");
            }
            LogRecord logRecord = new LogRecord();
            if (this.dsInfo.isDurable() && !primaryLsmIndex.isAtomic()) {
                TransactionUtil.formFlushLogRecord(logRecord, this.datasetID, this.partition, primaryId.getMinId(), primaryId.getMaxId(), this);
                try {
                    this.logManager.log(logRecord);
                }
                catch (ACIDException e) {
                    throw new IllegalStateException("could not write flush log", e);
                }
                this.flushLogCreated = true;
            } else {
                this.flushLogCreated = true;
                this.triggerScheduleFlush(logRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void triggerScheduleFlush(LogRecord logRecord) throws HyracksDataException {
        try {
            if (!this.canSafelyFlush()) {
                if (MetadataIndexImmutableProperties.isMetadataDataset(this.datasetID)) {
                    return;
                }
                throw new IllegalStateException("Operation started while index was pending scheduling a flush");
            }
            this.idGenerator.refresh();
            long flushLsn = logRecord.getLSN();
            ILSMComponentId nextComponentId = this.idGenerator.getId();
            HashMap<String, Long> flushMap = new HashMap<String, Long>();
            flushMap.put("FlushLogLsn", flushLsn);
            flushMap.put("NextComponentId", (Long)nextComponentId);
            for (ILSMIndex lsmIndex : this.dsInfo.getDatasetPartitionOpenIndexes(this.partition)) {
                if (!lsmIndex.isPrimaryIndex()) continue;
                if (!lsmIndex.isAtomic() && flushLsn == 0L) {
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = () -> lsmIndex;
                    supplierArray[1] = logRecord::getLogRecordForDisplay;
                    LOGGER.warn("flushing an index {} with LSN 0. Flush log record: {}", supplierArray);
                }
                if (!lsmIndex.isCurrentMutableComponentEmpty()) break;
                LOGGER.trace("Primary index on dataset {} and partition {} is empty... skipping flush", (Object)this.dsInfo.getDatasetID(), (Object)this.partition);
                return;
            }
            Map<String, FlushOperation> map = this.scheduledFlushes;
            synchronized (map) {
                for (ILSMIndex lsmIndex : this.dsInfo.getDatasetPartitionOpenIndexes(this.partition)) {
                    ILSMIndexAccessor accessor = lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
                    accessor.getOpContext().setParameters(flushMap);
                    ILSMIOOperation flush = accessor.scheduleFlush();
                    this.lastFlushTime = System.nanoTime();
                    this.scheduledFlushes.put(flush.getTarget().getRelativePath(), (FlushOperation)flush);
                    if (lsmIndex.isAtomic()) {
                        this.lastFlushOperation.put(lsmIndex.getIndexIdentifier(), (FlushOperation)flush);
                    }
                    flush.addCompleteListener((IoOperationCompleteListener)this);
                }
            }
        }
        finally {
            this.flushLogCreated = false;
        }
    }

    public void finishAllFlush() throws HyracksDataException {
        LogRecord logRecord = new LogRecord();
        this.triggerScheduleFlush(logRecord);
        ArrayList<FlushOperation> flushes = new ArrayList<FlushOperation>(this.getScheduledFlushes());
        LSMIndexUtil.waitFor(flushes);
    }

    public synchronized void commit() throws HyracksDataException {
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        for (ILSMIndex lsmIndex : indexes) {
            lsmIndex.commit();
        }
        for (FlushOperation flush : this.lastFlushOperation.values()) {
            FileReference target = flush.getTarget();
            Map map = flush.getParameters();
            LSMComponentId id = (LSMComponentId)map.get("FlushedComponentId");
            ResourceReference ref = ResourceReference.of(target.getAbsolutePath());
            long componentSequence = IndexComponentFileReference.of((String)ref.getName()).getSequenceEnd();
            this.indexCheckpointManagerProvider.get(ref).flushed(componentSequence, 0L, id.getMaxId());
        }
        this.lastFlushOperation.clear();
    }

    public void abort() throws HyracksDataException {
        this.clear();
    }

    public void clear() throws HyracksDataException {
        ArrayList<FlushOperation> flushes = new ArrayList<FlushOperation>(this.getScheduledFlushes());
        LSMIndexUtil.waitFor(flushes);
        this.deleteMemoryComponent(false);
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        for (ILSMIndex lsmIndex : indexes) {
            lsmIndex.abort();
        }
        this.lastFlushOperation.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(ILSMIOOperation operation) {
        Map<String, FlushOperation> map = this.scheduledFlushes;
        synchronized (map) {
            this.scheduledFlushes.remove(operation.getTarget().getRelativePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlushOperation> getScheduledFlushes() {
        Map<String, FlushOperation> map = this.scheduledFlushes;
        synchronized (map) {
            Collection<FlushOperation> scheduled = this.scheduledFlushes.values();
            ArrayList<FlushOperation> flushes = new ArrayList<FlushOperation>(scheduled.size());
            flushes.addAll(scheduled);
            return flushes;
        }
    }

    public int getNumActiveOperations() {
        return this.numActiveOperations.get();
    }

    private void incrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            this.numActiveOperations.incrementAndGet();
            ((AbstractOperationCallback)modificationCallback).beforeOperation();
        }
    }

    private void decrementNumActiveOperations(IModificationOperationCallback modificationCallback) {
        if (modificationCallback != NoOpOperationCallback.INSTANCE) {
            if (this.numActiveOperations.decrementAndGet() < 0) {
                throw new IllegalStateException("The number of active operations cannot be negative!");
            }
            ((AbstractOperationCallback)modificationCallback).afterOperation();
        }
    }

    public boolean isFlushOnExit() {
        return this.flushOnExit;
    }

    public void setFlushOnExit(boolean flushOnExit) {
        this.flushOnExit = flushOnExit;
    }

    public boolean isFlushLogCreated() {
        return this.flushLogCreated;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public String toString() {
        return "Dataset (" + this.datasetID + "), Partition (" + this.partition + ")";
    }

    public void deleteMemoryComponent(ILSMIndex lsmIndex, ILSMComponentId nextComponentId) throws HyracksDataException {
        HashMap<String, Long> flushMap = new HashMap<String, Long>();
        flushMap.put("FlushLogLsn", 0L);
        flushMap.put("NextComponentId", (Long)nextComponentId);
        ILSMIndexAccessor accessor = lsmIndex.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
        accessor.getOpContext().setParameters(flushMap);
        accessor.deleteComponents(c -> c.getType() == ILSMComponent.LSMComponentType.MEMORY);
    }

    public void deleteMemoryComponent(boolean onlyPrimaryIndex) throws HyracksDataException {
        Set<ILSMIndex> indexes = this.dsInfo.getDatasetPartitionOpenIndexes(this.partition);
        ILSMIndex primaryLsmIndex = null;
        for (ILSMIndex lsmIndex : indexes) {
            if (!lsmIndex.isPrimaryIndex()) continue;
            if (lsmIndex.isCurrentMutableComponentEmpty()) {
                LOGGER.trace("Primary index on dataset {} and partition {} is empty... skipping delete", (Object)this.dsInfo.getDatasetID(), (Object)this.partition);
                return;
            }
            primaryLsmIndex = lsmIndex;
            break;
        }
        Objects.requireNonNull(primaryLsmIndex, "no primary index found in " + indexes);
        this.idGenerator.refresh();
        ILSMComponentId nextComponentId = this.idGenerator.getId();
        if (onlyPrimaryIndex) {
            this.deleteMemoryComponent(primaryLsmIndex, nextComponentId);
        } else {
            for (ILSMIndex lsmIndex : indexes) {
                this.deleteMemoryComponent(lsmIndex, nextComponentId);
            }
        }
    }

    private boolean canSafelyFlush() {
        return this.numActiveOperations.get() == 0;
    }

    public Map<String, FlushOperation> getLastFlushOperation() {
        return this.lastFlushOperation;
    }
}

