/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.utils.TaskUtil;
import org.apache.hyracks.dataflow.std.buffermanager.DeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.FramePoolBackedFrameBufferManager;
import org.apache.hyracks.dataflow.std.buffermanager.IDeallocatableFramePool;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.common.impls.DefaultTupleProjectorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluator;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.search.InvertedIndexSearchPredicate;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;
import org.apache.hyracks.storage.common.IIndex;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.projection.ITupleProjectorFactory;

public class LSMInvertedIndexSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected final IInvertedIndexSearchModifier searchModifier;
    protected final IBinaryTokenizerFactory binaryTokenizerFactory;
    protected final IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory;
    protected final int queryFieldIndex;
    protected final int numOfFields;
    protected final boolean isFullTextSearchQuery;
    protected final ISimpleFrameBufferManager bufferManagerForSearch;
    protected final IDeallocatableFramePool framePool;

    public LSMInvertedIndexSearchOperatorNodePushable(IHyracksTaskContext ctx, RecordDescriptor inputRecDesc, int partition, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, IInvertedIndexSearchModifier searchModifier, IBinaryTokenizerFactory binaryTokenizerFactory, IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory, int queryFieldIndex, boolean isFullTextSearchQuery, int numOfFields, boolean appendIndexFilter, IMissingWriterFactory nonFilterWriterFactory, int frameLimit, int[][] partitionsMap) throws HyracksDataException {
        super(ctx, inputRecDesc, partition, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, appendIndexFilter, nonFilterWriterFactory, null, -1L, false, null, null, (ITupleProjectorFactory)DefaultTupleProjectorFactory.INSTANCE, null, partitionsMap);
        this.searchModifier = searchModifier;
        this.binaryTokenizerFactory = binaryTokenizerFactory;
        this.fullTextConfigEvaluatorFactory = fullTextConfigEvaluatorFactory;
        this.queryFieldIndex = queryFieldIndex;
        this.isFullTextSearchQuery = isFullTextSearchQuery;
        if (!retainInput) {
            this.frameTuple = new FrameTupleReference();
        }
        this.numOfFields = numOfFields;
        this.framePool = new DeallocatableFramePool((IHyracksFrameMgrContext)ctx, frameLimit * ctx.getInitialFrameSize());
        this.bufferManagerForSearch = new FramePoolBackedFrameBufferManager(this.framePool);
        TaskUtil.put((String)"INVERTED_INDEX_SEARCH_FRAME_MANAGER", (Object)this.bufferManagerForSearch, (IHyracksTaskContext)ctx);
    }

    protected ISearchPredicate createSearchPredicate(IIndex index) {
        IBinaryTokenizer tokenizer = this.binaryTokenizerFactory.createTokenizer();
        IFullTextConfigEvaluator fullTextConfigEvaluator = this.fullTextConfigEvaluatorFactory.createFullTextConfigEvaluator();
        return new InvertedIndexSearchPredicate(tokenizer, fullTextConfigEvaluator, this.searchModifier, (ITupleReference)this.minFilterKey, (ITupleReference)this.maxFilterKey, this.isFullTextSearchQuery);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        this.frameTuple.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        InvertedIndexSearchPredicate invIndexSearchPred = (InvertedIndexSearchPredicate)this.searchPred;
        invIndexSearchPred.setQueryTuple((ITupleReference)this.frameTuple);
        invIndexSearchPred.setQueryFieldIndex(this.queryFieldIndex);
        invIndexSearchPred.setIsFullTextSearchQuery(this.isFullTextSearchQuery);
        if (this.minFilterKey != null) {
            this.minFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
        if (this.maxFilterKey != null) {
            this.maxFilterKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }

    protected int getFieldCount(IIndex index) {
        return this.numOfFields;
    }

    protected void addAdditionalIndexAccessorParams(IIndexAccessParameters iap) throws HyracksDataException {
        iap.getParameters().put("HYRACKS_TASK_CONTEXT", this.ctx);
    }
}

