/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.dataflow;

import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifier;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedIndexSearchModifierFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.dataflow.LSMInvertedIndexSearchOperatorNodePushable;
import org.apache.hyracks.storage.am.lsm.invertedindex.fulltext.IFullTextConfigEvaluatorFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizerFactory;

public class LSMInvertedIndexSearchOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final long serialVersionUID = 2L;
    private final int queryField;
    private final IInvertedIndexSearchModifierFactory searchModifierFactory;
    private final int[] minFilterFieldIndexes;
    private final int[] maxFilterFieldIndexes;
    private final boolean appendIndexFilter;
    private final IMissingWriterFactory nonFilterWriterFactory;
    private final boolean isFullTextSearchQuery;
    private final IIndexDataflowHelperFactory indexHelperFactory;
    private final IBinaryTokenizerFactory queryTokenizerFactory;
    private final IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory;
    private final boolean retainInput;
    private final boolean retainMissing;
    private final IMissingWriterFactory missingWriterFactory;
    private final ISearchOperationCallbackFactory searchCallbackFactory;
    private final int numOfFields;
    private final int frameLimit;
    private final int[][] partitionsMap;

    public LSMInvertedIndexSearchOperatorDescriptor(IOperatorDescriptorRegistry spec, RecordDescriptor outRecDesc, int queryField, IIndexDataflowHelperFactory indexHelperFactory, IBinaryTokenizerFactory queryTokenizerFactory, IFullTextConfigEvaluatorFactory fullTextConfigEvaluatorFactory, IInvertedIndexSearchModifierFactory searchModifierFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, boolean isFullTextSearchQuery, int numOfFields, boolean appendIndexFilter, IMissingWriterFactory nonFilterWriterFactory, int frameLimit, int[][] partitionsMap) {
        super(spec, 1, 1);
        this.indexHelperFactory = indexHelperFactory;
        this.queryTokenizerFactory = queryTokenizerFactory;
        this.fullTextConfigEvaluatorFactory = fullTextConfigEvaluatorFactory;
        this.queryField = queryField;
        this.retainInput = retainInput;
        this.retainMissing = retainMissing;
        this.missingWriterFactory = missingWriterFactory;
        this.searchModifierFactory = searchModifierFactory;
        this.searchCallbackFactory = searchCallbackFactory;
        this.minFilterFieldIndexes = minFilterFieldIndexes;
        this.maxFilterFieldIndexes = maxFilterFieldIndexes;
        this.isFullTextSearchQuery = isFullTextSearchQuery;
        this.appendIndexFilter = appendIndexFilter;
        this.nonFilterWriterFactory = nonFilterWriterFactory;
        this.numOfFields = numOfFields;
        this.partitionsMap = partitionsMap;
        this.outRecDescs[0] = outRecDesc;
        this.frameLimit = frameLimit;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        IInvertedIndexSearchModifier searchModifier = this.searchModifierFactory.createSearchModifier();
        return new LSMInvertedIndexSearchOperatorNodePushable(ctx, recordDescProvider.getInputRecordDescriptor(this.getActivityId(), 0), partition, this.minFilterFieldIndexes, this.maxFilterFieldIndexes, this.indexHelperFactory, this.retainInput, this.retainMissing, this.missingWriterFactory, this.searchCallbackFactory, searchModifier, this.queryTokenizerFactory, this.fullTextConfigEvaluatorFactory, this.queryField, this.isFullTextSearchQuery, this.numOfFields, this.appendIndexFilter, this.nonFilterWriterFactory, this.frameLimit, this.partitionsMap);
    }
}

