/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class FullTextConfigEntity {
    private static final FullTextConfigEntity FULL_TEXT_CONFIG = new FullTextConfigEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FULL_TEXT_CONFIG, 3, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DataverseName"), List.of("FullTextConfigName")), 0, FullTextConfigEntity.fullTextConfigType(), true, new int[]{0, 1}), 2, -1);
    private static final FullTextConfigEntity DB_FULL_TEXT_CONFIG = new FullTextConfigEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_FULL_TEXT_CONFIG, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("FullTextConfigName")), 0, FullTextConfigEntity.databaseFullTextConfigType(), true, new int[]{0, 1, 2}), 3, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int configNameIndex;
    private final int tokenizerIndex;
    private final int filterPipelineIndex;

    private FullTextConfigEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.configNameIndex = startIndex++;
        this.tokenizerIndex = startIndex++;
        this.filterPipelineIndex = startIndex++;
    }

    public static FullTextConfigEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_FULL_TEXT_CONFIG : FULL_TEXT_CONFIG;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int configNameIndex() {
        return this.configNameIndex;
    }

    public int tokenizerIndex() {
        return this.tokenizerIndex;
    }

    public int filterPipelineIndex() {
        return this.filterPipelineIndex;
    }

    private static ARecordType fullTextConfigType() {
        return MetadataRecordTypes.createRecordType("FullTextConfigRecordType", new String[]{"DataverseName", "FullTextConfigName", "Tokenizer", "FullTextFilterPipeline"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, AUnionType.createNullableType((IAType)BuiltinType.ASTRING), AUnionType.createNullableType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, "FullTextFilterPipeline"))}, true);
    }

    private static ARecordType databaseFullTextConfigType() {
        return MetadataRecordTypes.createRecordType("FullTextConfigRecordType", new String[]{"DatabaseName", "DataverseName", "FullTextConfigName", "Tokenizer", "FullTextFilterPipeline"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, AUnionType.createNullableType((IAType)BuiltinType.ASTRING), AUnionType.createNullableType((IAType)new AOrderedListType((IAType)BuiltinType.ASTRING, "FullTextFilterPipeline"))}, true);
    }
}

