/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.bootstrap;

import java.util.Arrays;
import java.util.List;
import org.apache.asterix.metadata.bootstrap.MetadataIndex;
import org.apache.asterix.metadata.bootstrap.MetadataPrimaryIndexes;
import org.apache.asterix.metadata.bootstrap.MetadataRecordTypes;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public final class ExternalFileEntity {
    private static final ExternalFileEntity EXTERNAL_FILE = new ExternalFileEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_EXTERNAL_FILE, 4, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32}, Arrays.asList(List.of("DataverseName"), List.of("DatasetName"), List.of("FileNumber")), 0, ExternalFileEntity.externalFileType(), true, new int[]{0, 1, 2}), 3, -1);
    private static final ExternalFileEntity DB_EXTERNAL_FILE = new ExternalFileEntity(new MetadataIndex(MetadataPrimaryIndexes.PROPERTIES_EXTERNAL_FILE, 5, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32}, Arrays.asList(List.of("DatabaseName"), List.of("DataverseName"), List.of("DatasetName"), List.of("FileNumber")), 0, ExternalFileEntity.databaseExternalFileType(), true, new int[]{0, 1, 2, 3}), 4, 0);
    private final int payloadPosition;
    private final MetadataIndex index;
    private final int databaseNameIndex;
    private final int dataverseNameIndex;
    private final int datasetNameIndex;
    private final int fileNumberIndex;
    private final int fileNameIndex;
    private final int fileSizeIndex;
    private final int fileModDateIndex;
    private final int pendingOpIndex;

    private ExternalFileEntity(MetadataIndex index, int payloadPosition, int startIndex) {
        this.index = index;
        this.payloadPosition = payloadPosition;
        this.databaseNameIndex = startIndex++;
        this.dataverseNameIndex = startIndex++;
        this.datasetNameIndex = startIndex++;
        this.fileNumberIndex = startIndex++;
        this.fileNameIndex = startIndex++;
        this.fileSizeIndex = startIndex++;
        this.fileModDateIndex = startIndex++;
        this.pendingOpIndex = startIndex++;
    }

    public static ExternalFileEntity of(boolean usingDatabase) {
        return usingDatabase ? DB_EXTERNAL_FILE : EXTERNAL_FILE;
    }

    public MetadataIndex getIndex() {
        return this.index;
    }

    public ARecordType getRecordType() {
        return this.index.getPayloadRecordType();
    }

    public int payloadPosition() {
        return this.payloadPosition;
    }

    public int databaseNameIndex() {
        return this.databaseNameIndex;
    }

    public int dataverseNameIndex() {
        return this.dataverseNameIndex;
    }

    public int datasetNameIndex() {
        return this.datasetNameIndex;
    }

    public int fileNumberIndex() {
        return this.fileNumberIndex;
    }

    public int fileNameIndex() {
        return this.fileNameIndex;
    }

    public int fileSizeIndex() {
        return this.fileSizeIndex;
    }

    public int fileModDateIndex() {
        return this.fileModDateIndex;
    }

    public int pendingOpIndex() {
        return this.pendingOpIndex;
    }

    private static ARecordType externalFileType() {
        return MetadataRecordTypes.createRecordType("ExternalFileRecordType", new String[]{"DataverseName", "DatasetName", "FileNumber", "FileName", "FileSize", "FileModTime", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32, BuiltinType.ASTRING, BuiltinType.AINT64, BuiltinType.ADATETIME, BuiltinType.AINT32}, true);
    }

    private static ARecordType databaseExternalFileType() {
        return MetadataRecordTypes.createRecordType("ExternalFileRecordType", new String[]{"DatabaseName", "DataverseName", "DatasetName", "FileNumber", "FileName", "FileSize", "FileModTime", "PendingOp"}, new IAType[]{BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.AINT32, BuiltinType.ASTRING, BuiltinType.AINT64, BuiltinType.ADATETIME, BuiltinType.AINT32}, true);
    }
}

