/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.util.List;
import org.apache.hyracks.api.dataflow.IDestroyable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.CleanupUtils;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IExtendedModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.IndexAccessParameters;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallback;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMMemoryComponent;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.trace.ITracer;

public class LSMBTreeOpContext
extends AbstractLSMIndexOperationContext {
    private final ITreeIndexFrameFactory insertLeafFrameFactory;
    private final ITreeIndexFrameFactory deleteLeafFrameFactory;
    private final IBTreeLeafFrame insertLeafFrame;
    private final IBTreeLeafFrame deleteLeafFrame;
    private final BTree[] mutableBTrees;
    private final BTree.BTreeAccessor[] mutableBTreeAccessors;
    private final BTreeOpContext[] mutableBTreeOpCtxs;
    private final MultiComparator cmp;
    private final MultiComparator bloomFilterCmp;
    private final BTreeRangeSearchCursor memCursor;
    private final LSMBTreeCursorInitialState searchInitialState;
    private final LSMBTreePointSearchCursor insertSearchCursor;
    private BTree.BTreeAccessor currentMutableBTreeAccessor;
    private BTreeOpContext currentMutableBTreeOpCtx;
    private boolean destroyed = false;

    public LSMBTreeOpContext(ILSMIndex index, List<ILSMMemoryComponent> mutableComponents, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, IExtendedModificationOperationCallback modificationCallback, ISearchOperationCallback searchCallback, int numBloomFilterKeyFields, int[] btreeFields, int[] filterFields, ILSMHarness lsmHarness, IBinaryComparatorFactory[] filterCmpFactories, ITracer tracer) {
        super(index, btreeFields, filterFields, filterCmpFactories, searchCallback, modificationCallback, tracer);
        LSMBTreeMemoryComponent c = (LSMBTreeMemoryComponent)mutableComponents.get(0);
        IBinaryComparatorFactory[] cmpFactories = c.getIndex().getComparatorFactories();
        this.cmp = cmpFactories[0] != null ? this.createMultiComparator(c.getIndex().getComparatorFactories()) : null;
        this.bloomFilterCmp = numBloomFilterKeyFields == 0 ? null : MultiComparator.create((IBinaryComparatorFactory[])c.getIndex().getComparatorFactories(), (int)0, (int)numBloomFilterKeyFields);
        this.mutableBTrees = new BTree[mutableComponents.size()];
        this.mutableBTreeAccessors = new BTree.BTreeAccessor[mutableComponents.size()];
        this.mutableBTreeOpCtxs = new BTreeOpContext[mutableComponents.size()];
        for (int i = 0; i < mutableComponents.size(); ++i) {
            LSMBTreeMemoryComponent mutableComponent = (LSMBTreeMemoryComponent)mutableComponents.get(i);
            this.mutableBTrees[i] = mutableComponent.getIndex();
            IndexAccessParameters iap = new IndexAccessParameters((IModificationOperationCallback)modificationCallback, (ISearchOperationCallback)NoOpOperationCallback.INSTANCE);
            this.mutableBTreeAccessors[i] = this.mutableBTrees[i].createAccessor((IIndexAccessParameters)iap);
            this.mutableBTreeOpCtxs[i] = this.mutableBTreeAccessors[i].getOpContext();
        }
        this.insertLeafFrameFactory = insertLeafFrameFactory;
        this.deleteLeafFrameFactory = deleteLeafFrameFactory;
        this.insertLeafFrame = (IBTreeLeafFrame)insertLeafFrameFactory.createFrame();
        this.deleteLeafFrame = (IBTreeLeafFrame)deleteLeafFrameFactory.createFrame();
        if (this.insertLeafFrame != null && this.getCmp() != null) {
            this.insertLeafFrame.setMultiComparator(this.getCmp());
        }
        if (this.deleteLeafFrame != null && this.getCmp() != null) {
            this.deleteLeafFrame.setMultiComparator(this.getCmp());
        }
        this.searchPredicate = new RangePredicate(null, null, true, true, this.getCmp(), this.getCmp());
        this.memCursor = this.insertLeafFrame != null ? new BTreeRangeSearchCursor(this.insertLeafFrame, false) : null;
        this.searchInitialState = new LSMBTreeCursorInitialState(insertLeafFrameFactory, this.getCmp(), this.bloomFilterCmp, lsmHarness, null, searchCallback, null);
        this.insertSearchCursor = new LSMBTreePointSearchCursor((ILSMIndexOperationContext)this);
    }

    protected MultiComparator createMultiComparator(IBinaryComparatorFactory[] cmpFactories) {
        return MultiComparator.create((IBinaryComparatorFactory[])cmpFactories);
    }

    public void setOperation(IndexOperation newOp) {
        this.reset();
        this.op = newOp;
    }

    public void setInsertMode() {
        this.currentMutableBTreeOpCtx.setLeafFrame(this.insertLeafFrame);
        this.currentMutableBTreeOpCtx.setLeafFrameFactory(this.insertLeafFrameFactory);
    }

    public void setDeleteMode() {
        this.currentMutableBTreeOpCtx.setLeafFrame(this.deleteLeafFrame);
        this.currentMutableBTreeOpCtx.setLeafFrameFactory(this.deleteLeafFrameFactory);
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
        this.setCurrentMutableBTreeAccessor(this.mutableBTreeAccessors[currentMutableComponentId]);
        this.currentMutableBTreeOpCtx = this.mutableBTreeOpCtxs[currentMutableComponentId];
        switch (this.op) {
            case SEARCH: 
            case DISKORDERSCAN: 
            case UPDATE: {
                break;
            }
            case UPSERT: 
            case INSERT: {
                this.setInsertMode();
                break;
            }
            case PHYSICALDELETE: 
            case DELETE: {
                this.setDeleteMode();
            }
        }
    }

    public BTree.BTreeAccessor getCurrentMutableBTreeAccessor() {
        return this.currentMutableBTreeAccessor;
    }

    public void setCurrentMutableBTreeAccessor(BTree.BTreeAccessor currentMutableBTreeAccessor) {
        this.currentMutableBTreeAccessor = currentMutableBTreeAccessor;
    }

    public LSMBTreePointSearchCursor getInsertSearchCursor() {
        return this.insertSearchCursor;
    }

    public BTreeRangeSearchCursor getMemCursor() {
        return this.memCursor;
    }

    public LSMBTreeCursorInitialState getSearchInitialState() {
        return this.searchInitialState;
    }

    public MultiComparator getCmp() {
        return this.cmp;
    }

    public void destroy() throws HyracksDataException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        Throwable failure = CleanupUtils.destroy(null, (IDestroyable[])this.mutableBTreeAccessors);
        failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])this.mutableBTreeOpCtxs);
        if ((failure = CleanupUtils.destroy((Throwable)failure, (IDestroyable[])new IDestroyable[]{this.insertSearchCursor, this.memCursor})) != null) {
            throw HyracksDataException.create((Throwable)failure);
        }
    }
}

