/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class SqlppFunctionCallResolverVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    private final LangRewritingContext context;
    private final boolean allowNonStoredUdfCalls;
    private final BiFunction<String, Integer, FunctionSignature> builtinFunctionResolver;
    private final BiFunction<String, Integer, FunctionSignature> callExprResolver;

    public SqlppFunctionCallResolverVisitor(LangRewritingContext context, boolean allowNonStoredUdfCalls) {
        this.context = context;
        this.allowNonStoredUdfCalls = allowNonStoredUdfCalls;
        this.builtinFunctionResolver = FunctionUtil.createBuiltinFunctionResolver((MetadataProvider)context.getMetadataProvider());
        this.callExprResolver = this::resolveCallExpr;
    }

    @Override
    public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = FunctionUtil.resolveFunctionCall((FunctionSignature)callExpr.getFunctionSignature(), (SourceLocation)callExpr.getSourceLocation(), (MetadataProvider)this.context.getMetadataProvider(), this.callExprResolver, (boolean)true, (Map)this.context.getDeclaredFunctions(), (boolean)this.allowNonStoredUdfCalls);
        callExpr.setFunctionSignature(fs);
        return super.visit(callExpr, arg);
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        FunctionSignature fs = FunctionUtil.resolveFunctionCall((FunctionSignature)winExpr.getFunctionSignature(), (SourceLocation)winExpr.getSourceLocation(), (MetadataProvider)this.context.getMetadataProvider(), this.callExprResolver, (boolean)false, null, (boolean)false);
        winExpr.setFunctionSignature(fs);
        return super.visit(winExpr, arg);
    }

    private FunctionSignature resolveCallExpr(String name, int arity) {
        FunctionSignature fs = this.builtinFunctionResolver.apply(name, arity);
        if (fs != null) {
            return fs;
        }
        fs = FunctionSignature.newAsterix((String)name, (int)arity);
        return SqlppFunctionCallResolverVisitor.isAggregateFunction(fs) || SqlppFunctionCallResolverVisitor.isWindowFunction(fs) ? fs : null;
    }

    private static boolean isAggregateFunction(FunctionSignature fs) {
        return FunctionMapUtil.isSql92AggregateFunction(fs) || FunctionMapUtil.isCoreAggregateFunction(fs);
    }

    private static boolean isWindowFunction(FunctionSignature fs) {
        return BuiltinFunctions.getWindowFunction((FunctionIdentifier)fs.createFunctionIdentifier()) != null;
    }
}

