/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.tuple;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.asterix.column.assembler.value.MissingValueGetter;
import org.apache.asterix.column.bytes.stream.in.AbstractBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.ByteBufferInputStream;
import org.apache.asterix.column.bytes.stream.in.DummyBytesInputStream;
import org.apache.asterix.column.bytes.stream.in.MultiByteBufferInputStream;
import org.apache.asterix.column.filter.FilterAccessorProvider;
import org.apache.asterix.column.filter.IColumnFilterEvaluator;
import org.apache.asterix.column.filter.IFilterApplier;
import org.apache.asterix.column.filter.TrueColumnFilterEvaluator;
import org.apache.asterix.column.filter.iterable.IColumnIterableFilterEvaluator;
import org.apache.asterix.column.filter.range.IColumnRangeFilterValueAccessor;
import org.apache.asterix.column.operation.query.ColumnAssembler;
import org.apache.asterix.column.operation.query.QueryColumnMetadata;
import org.apache.asterix.column.tuple.AbstractAsterixColumnTupleReference;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.column.values.reader.PrimitiveColumnValuesReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnBufferProvider;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnReadMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.column.api.projection.IColumnProjectionInfo;
import org.apache.hyracks.storage.am.lsm.btree.column.error.ColumnarValueException;
import org.apache.hyracks.storage.am.lsm.btree.column.impls.btree.ColumnBTreeReadLeafFrame;

public final class QueryColumnTupleReference
extends AbstractAsterixColumnTupleReference {
    private final ColumnAssembler assembler;
    private final IColumnFilterEvaluator rangeFilterEvaluator;
    private final List<IColumnRangeFilterValueAccessor> filterValueAccessors;
    private final IColumnIterableFilterEvaluator columnFilterEvaluator;
    private final IFilterApplier filterApplier;
    private final List<IColumnValuesReader> filterColumnReaders;
    private final AbstractBytesInputStream[] filteredColumnStreams;
    private int previousIndex;

    public QueryColumnTupleReference(int componentIndex, ColumnBTreeReadLeafFrame frame, QueryColumnMetadata columnMetadata, IColumnReadMultiPageOp multiPageOp) {
        super(componentIndex, frame, columnMetadata, multiPageOp);
        this.assembler = columnMetadata.getAssembler();
        this.rangeFilterEvaluator = columnMetadata.getRangeFilterEvaluator();
        this.filterValueAccessors = columnMetadata.getFilterValueAccessors();
        this.columnFilterEvaluator = columnMetadata.getColumnFilterEvaluator();
        this.filterColumnReaders = columnMetadata.getFilterColumnReaders();
        this.filterApplier = this.createFilterApplier();
        int numberOfPrimaryKeys = columnMetadata.getNumberOfPrimaryKeys();
        this.filteredColumnStreams = new AbstractBytesInputStream[columnMetadata.getNumberOfFilteredColumns()];
        for (int i = 0; i < this.filteredColumnStreams.length; ++i) {
            int columnIndex = this.filterColumnReaders.get(i).getColumnIndex();
            this.filteredColumnStreams[i] = columnIndex < 0 ? DummyBytesInputStream.INSTANCE : (columnIndex >= numberOfPrimaryKeys ? new MultiByteBufferInputStream() : new ByteBufferInputStream());
        }
        this.previousIndex = -1;
    }

    @Override
    protected PrimitiveColumnValuesReader[] getPrimaryKeyReaders(IColumnProjectionInfo info) {
        return ((QueryColumnMetadata)info).getPrimaryKeyReaders();
    }

    protected boolean startNewPage(ByteBuffer pageZero, int numberOfColumns, int numberOfTuples) throws HyracksDataException {
        pageZero.position(pageZero.position() + numberOfColumns * 4);
        FilterAccessorProvider.setFilterValues(this.filterValueAccessors, pageZero, numberOfColumns);
        pageZero.position(pageZero.position() + numberOfColumns * 16);
        boolean readColumns = this.rangeFilterEvaluator.evaluate();
        this.assembler.reset(readColumns ? numberOfTuples : 0);
        this.columnFilterEvaluator.reset();
        this.previousIndex = -1;
        return readColumns;
    }

    protected void startColumnFilter(IColumnBufferProvider buffersProvider, int ordinal, int numberOfTuples) throws HyracksDataException {
        AbstractBytesInputStream columnStream = this.filteredColumnStreams[ordinal];
        columnStream.reset(buffersProvider);
        this.filterColumnReaders.get(ordinal).reset(columnStream, numberOfTuples);
    }

    protected boolean evaluateFilter() throws HyracksDataException {
        return this.columnFilterEvaluator.evaluate();
    }

    protected void startColumn(IColumnBufferProvider buffersProvider, int ordinal, int numberOfTuples) throws HyracksDataException {
        AbstractBytesInputStream columnStream = this.columnStreams[ordinal];
        columnStream.reset(buffersProvider);
        this.assembler.resetColumn(columnStream, ordinal);
    }

    public void skip(int count) throws HyracksDataException {
        this.columnFilterEvaluator.setAt(this.assembler.skip(count));
    }

    public IValueReference getAssembledValue() throws HyracksDataException {
        try {
            if (this.previousIndex == this.tupleIndex) {
                return this.assembler.getPreviousValue();
            }
            this.previousIndex = this.tupleIndex;
            return this.filterApplier.getTuple();
        }
        catch (ColumnarValueException e) {
            this.appendExceptionInformation(e, this.previousIndex);
            throw e;
        }
    }

    private IFilterApplier createFilterApplier() {
        if (this.columnFilterEvaluator == TrueColumnFilterEvaluator.INSTANCE) {
            return this.assembler::nextValue;
        }
        return this::getFilteredAssembledValue;
    }

    private IValueReference getFilteredAssembledValue() throws HyracksDataException {
        int index = this.columnFilterEvaluator.getTupleIndex();
        if (index == this.tupleIndex) {
            this.assembler.setAt(index);
            this.columnFilterEvaluator.evaluate();
            return this.assembler.nextValue();
        }
        return MissingValueGetter.MISSING;
    }
}

