/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.operation.lsm.flush;

import java.nio.ByteBuffer;
import org.apache.asterix.column.operation.lsm.flush.BatchFinalizerVisitor;
import org.apache.asterix.column.operation.lsm.flush.ColumnTransformer;
import org.apache.asterix.column.operation.lsm.flush.FlushColumnMetadata;
import org.apache.asterix.column.values.IColumnValuesWriter;
import org.apache.asterix.column.values.writer.ColumnBatchWriter;
import org.apache.asterix.om.lazy.RecordLazyVisitablePointable;
import org.apache.asterix.om.lazy.TypedRecordLazyVisitablePointable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.btree.column.api.AbstractColumnTupleWriter;
import org.apache.hyracks.storage.am.lsm.btree.column.api.IColumnWriteMultiPageOp;
import org.apache.hyracks.storage.am.lsm.btree.tuples.LSMBTreeTupleReference;

public class FlushColumnTupleWriter
extends AbstractColumnTupleWriter {
    protected final FlushColumnMetadata columnMetadata;
    protected final BatchFinalizerVisitor finalizer;
    protected final ColumnBatchWriter writer;
    private final ColumnTransformer transformer;
    private final RecordLazyVisitablePointable pointable;
    private final int maxNumberOfTuples;
    private final IColumnValuesWriter[] primaryKeyWriters;
    private final int maxLeafNodeSize;
    protected int primaryKeysEstimatedSize;

    public FlushColumnTupleWriter(FlushColumnMetadata columnMetadata, int pageSize, int maxNumberOfTuples, double tolerance, int maxLeafNodeSize) {
        this.columnMetadata = columnMetadata;
        this.transformer = new ColumnTransformer(columnMetadata, columnMetadata.getRoot());
        this.finalizer = new BatchFinalizerVisitor(columnMetadata);
        this.writer = new ColumnBatchWriter(columnMetadata.getMultiPageOpRef(), pageSize, tolerance);
        this.maxNumberOfTuples = maxNumberOfTuples;
        this.maxLeafNodeSize = maxLeafNodeSize;
        this.pointable = new TypedRecordLazyVisitablePointable(columnMetadata.getDatasetType());
        int numberOfPrimaryKeys = columnMetadata.getNumberOfPrimaryKeys();
        this.primaryKeyWriters = new IColumnValuesWriter[numberOfPrimaryKeys];
        for (int i = 0; i < numberOfPrimaryKeys; ++i) {
            this.primaryKeyWriters[i] = columnMetadata.getWriter(i);
        }
    }

    public final void init(IColumnWriteMultiPageOp multiPageOp) throws HyracksDataException {
        this.columnMetadata.init(multiPageOp);
    }

    public final int getNumberOfColumns() {
        return this.columnMetadata.getNumberOfColumns();
    }

    public final int bytesRequired(ITupleReference tuple) {
        int primaryKeysSize = 0;
        for (int i = 0; i < this.columnMetadata.getNumberOfPrimaryKeys(); ++i) {
            primaryKeysSize += this.primaryKeyWriters[i].getEstimatedSize(tuple.getFieldLength(i));
        }
        return primaryKeysSize;
    }

    public final int getOccupiedSpace() {
        int numberOfColumns = this.getNumberOfColumns();
        int filterSize = numberOfColumns * 16;
        return this.primaryKeysEstimatedSize + filterSize;
    }

    public final int getMaxNumberOfTuples() {
        if (this.transformer.getStringLengths() >= this.maxLeafNodeSize) {
            return 0;
        }
        return this.maxNumberOfTuples;
    }

    public final void close() {
        this.columnMetadata.close();
    }

    public void writeTuple(ITupleReference tuple) throws HyracksDataException {
        LSMBTreeTupleReference btreeTuple = (LSMBTreeTupleReference)tuple;
        if (btreeTuple.isAntimatter()) {
            this.primaryKeysEstimatedSize = this.transformer.writeAntiMatter(btreeTuple);
            return;
        }
        this.writeRecord(tuple);
        this.writeMeta(btreeTuple);
    }

    public final int flush(ByteBuffer pageZero) throws HyracksDataException {
        this.writer.setPageZeroBuffer(pageZero, this.getNumberOfColumns(), this.columnMetadata.getNumberOfPrimaryKeys());
        this.transformer.resetStringLengths();
        return this.finalizer.finalizeBatch(this.writer, this.columnMetadata);
    }

    protected void writeRecord(ITupleReference tuple) throws HyracksDataException {
        int recordFieldId = this.columnMetadata.getRecordFieldIndex();
        this.pointable.set(tuple.getFieldData(recordFieldId), tuple.getFieldStart(recordFieldId), tuple.getFieldLength(recordFieldId));
        this.primaryKeysEstimatedSize = this.transformer.transform(this.pointable);
    }

    protected void writeMeta(LSMBTreeTupleReference btreeTuple) throws HyracksDataException {
    }
}

