/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.column.filter.iterable.accessor;

import org.apache.asterix.column.assembler.value.IValueGetter;
import org.apache.asterix.column.values.IColumnValuesReader;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class UnionColumnFilterValueAccessorEvaluator
implements IScalarEvaluator {
    private final IColumnValuesReader[] readers;
    private final IValueGetter[] valueGetters;

    public UnionColumnFilterValueAccessorEvaluator(IColumnValuesReader[] readers, IValueGetter[] valueGetters) {
        this.readers = readers;
        this.valueGetters = valueGetters;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        for (int i = 0; i < this.readers.length; ++i) {
            IColumnValuesReader reader = this.readers[i];
            IValueGetter getter = this.valueGetters[i];
            if (!this.setValue(reader, getter, result)) continue;
            return;
        }
        PointableHelper.setMissing((IPointable)result);
    }

    private boolean setValue(IColumnValuesReader reader, IValueGetter getter, IPointable result) {
        if (reader.isRepeated() && !reader.isRepeatedValue() || reader.isMissing()) {
            return false;
        }
        if (reader.isNull()) {
            PointableHelper.setNull((IPointable)result);
        } else {
            result.set(getter.getValue(reader));
        }
        return true;
    }
}

