/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.asterix.metadata.bootstrap;

import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

/**
 * Contains static ARecordType's of all metadata record types.
 */
public final class MetadataRecordTypes {

    //--------------------------------------- Fields Names --------------------------------------//
    public static final String FIELD_NAME_ADAPTER_CONFIGURATION = "AdapterConfiguration";
    public static final String FIELD_NAME_ARITY = "Arity";
    public static final String FIELD_NAME_AUTOGENERATED = "Autogenerated";
    public static final String FIELD_NAME_CAST = "Cast";
    public static final String FIELD_NAME_CLASSNAME = "Classname";
    public static final String FIELD_NAME_COMPACTION_POLICY = "CompactionPolicy";
    public static final String FIELD_NAME_COMPACTION_POLICY_PROPERTIES = "CompactionPolicyProperties";
    public static final String FIELD_NAME_DATASET_ID = "DatasetId";
    public static final String FIELD_NAME_DATASET_NAME = "DatasetName";
    public static final String FIELD_NAME_DATASET_TYPE = "DatasetType";
    public static final String FIELD_NAME_DATASOURCE_ADAPTER = "DatasourceAdapter";
    public static final String FIELD_NAME_DATATYPE_DATABASE_NAME = "DatatypeDatabaseName";
    public static final String FIELD_NAME_DATATYPE_DATAVERSE_NAME = "DatatypeDataverseName";
    public static final String FIELD_NAME_DATATYPE_NAME = "DatatypeName";
    public static final String FIELD_NAME_DATABASE_NAME = "DatabaseName";
    public static final String FIELD_NAME_DATABASE_ID = "DatabaseId";
    public static final String FIELD_NAME_SYSTEM_DATABASE = "SystemDatabase";
    public static final String FIELD_NAME_DATAVERSE_NAME = "DataverseName";
    public static final String FIELD_NAME_DATA_FORMAT = "DataFormat";
    public static final String FIELD_NAME_DEFAULT = "Default";
    public static final String FIELD_NAME_DEFINITION = "Definition";
    public static final String FIELD_NAME_DEPENDENCIES = "Dependencies";
    public static final String FIELD_NAME_DERIVED = "Derived";
    public static final String FIELD_NAME_DESCRIPTION = "Description";
    public static final String FIELD_NAME_EXTERNAL_DETAILS = "ExternalDetails";
    public static final String FIELD_NAME_FEED_NAME = "FeedName";
    public static final String FIELD_NAME_FIELDS = "Fields";
    public static final String FIELD_NAME_FIELD_NAME = "FieldName";
    public static final String FIELD_NAME_FIELD_TYPE = "FieldType";
    public static final String FIELD_NAME_FILE_MOD_TIME = "FileModTime";
    public static final String FIELD_NAME_FILE_NAME = "FileName";
    public static final String FIELD_NAME_FILE_NUMBER = "FileNumber";
    public static final String FIELD_NAME_FILE_SIZE = "FileSize";
    public static final String FIELD_NAME_FILE_STRUCTURE = "FileStructure";
    public static final String FIELD_NAME_FOREIGN_KEY = "ForeignKey";
    public static final String FIELD_NAME_FOREIGN_KEYS = "ForeignKeys";
    public static final String FIELD_NAME_GROUP_NAME = "GroupName";
    public static final String FIELD_NAME_HINTS = "Hints";
    public static final String FIELD_NAME_INDEX_NAME = "IndexName";
    public static final String FIELD_NAME_INDEX_STRUCTURE = "IndexStructure";
    public static final String FIELD_NAME_INTERNAL_DETAILS = "InternalDetails";
    public static final String FIELD_NAME_IS_ANONYMOUS = "IsAnonymous";
    public static final String FIELD_NAME_IS_ENFORCED = "IsEnforced";
    public static final String FIELD_NAME_IS_MISSABLE = "IsMissable";
    public static final String FIELD_NAME_IS_NULLABLE = "IsNullable";
    public static final String FIELD_NAME_IS_OPEN = "IsOpen";
    public static final String FIELD_NAME_IS_PRIMARY = "IsPrimary";
    public static final String FIELD_NAME_KIND = "Kind";
    public static final String FIELD_NAME_LANGUAGE = "Language";
    public static final String FIELD_NAME_HASH = "MD5Hash";
    public static final String FIELD_NAME_LIBRARY_DATABASE_NAME = "LibraryDatabaseName";
    public static final String FIELD_NAME_LIBRARY_DATAVERSE_NAME = "LibraryDataverseName";
    public static final String FIELD_NAME_LIBRARY_NAME = "LibraryName";
    public static final String FIELD_NAME_LAST_REFRESH_TIME = "LastRefreshTime";
    public static final String FIELD_NAME_METATYPE_DATABASE_NAME = "MetatypeDatabaseName";
    public static final String FIELD_NAME_METATYPE_DATAVERSE_NAME = "MetatypeDataverseName";
    public static final String FIELD_NAME_METATYPE_NAME = "MetatypeName";
    public static final String FIELD_NAME_NAME = "Name";
    public static final String FIELD_NAME_NODE_NAME = "NodeName";
    public static final String FIELD_NAME_NODE_NAMES = "NodeNames";
    public static final String FIELD_NAME_NUMBER_OF_CORES = "NumberOfCores";
    public static final String FIELD_NAME_OBJECT_DATABASE_NAME = "ObjectDatabaseName";
    public static final String FIELD_NAME_OBJECT_DATAVERSE_NAME = "ObjectDataverseName";
    public static final String FIELD_NAME_OBJECT_NAME = "ObjectName";
    public static final String FIELD_NAME_ORDERED_LIST = "OrderedList";
    public static final String FIELD_NAME_PARAMS = "Params";
    public static final String FIELD_NAME_PARTITIONING_KEY = "PartitioningKey";
    public static final String FIELD_NAME_PARTITIONING_STRATEGY = "PartitioningStrategy";
    public static final String FIELD_NAME_PENDING_OP = "PendingOp";
    public static final String FIELD_NAME_POLICY_NAME = "PolicyName";
    public static final String FIELD_NAME_PRIMARY_KEY = "PrimaryKey";
    public static final String FIELD_NAME_PRIMARY_KEY_ENFORCED = "PrimaryKeyEnforced";
    public static final String FIELD_NAME_PROPERTIES = "Properties";
    public static final String FIELD_NAME_RECORD = "Record";
    public static final String FIELD_NAME_REF_DATABASE_NAME = "RefDatabaseName";
    public static final String FIELD_NAME_REF_DATAVERSE_NAME = "RefDataverseName";
    public static final String FIELD_NAME_REF_DATASET_NAME = "RefDatasetName";
    public static final String FIELD_NAME_RETURN_TYPE = "ReturnType";
    public static final String FIELD_NAME_RETURN_TYPE_DATABASE_NAME = "ReturnTypeDatabaseName";
    public static final String FIELD_NAME_RETURN_TYPE_DATAVERSE_NAME = "ReturnTypeDataverseName";
    public static final String FIELD_NAME_SEARCH_KEY = "SearchKey";
    public static final String FIELD_NAME_SYNONYM_NAME = "SynonymName";
    public static final String FIELD_NAME_TAG = "Tag";
    public static final String FIELD_NAME_TIMESTAMP = "Timestamp";
    public static final String FIELD_NAME_TRANSACTION_STATE = "TransactionState";
    public static final String FIELD_NAME_TYPE = "Type";
    public static final String FIELD_NAME_UNORDERED_LIST = "UnorderedList";
    public static final String FIELD_NAME_VALUE = "Value";
    public static final String FIELD_NAME_VIEW_DETAILS = "ViewDetails";
    public static final String FIELD_NAME_WORKING_MEMORY_SIZE = "WorkingMemorySize";
    public static final String FIELD_NAME_APPLIED_FUNCTIONS = "AppliedFunctions";
    public static final String FIELD_NAME_WHERE_CLAUSE = "WhereClause";
    public static final String FIELD_NAME_FULL_TEXT_CONFIG_NAME = "FullTextConfigName";
    public static final String FIELD_NAME_FULL_TEXT_FILTER_NAME = "FullTextFilterName";
    public static final String FIELD_NAME_FULL_TEXT_FILTER_TYPE = "FullTextFilterType";
    public static final String FIELD_NAME_FULL_TEXT_TOKENIZER = "Tokenizer";
    public static final String FIELD_NAME_FULL_TEXT_FILTER_PIPELINE = "FullTextFilterPipeline";
    public static final String FIELD_NAME_FULL_TEXT_STOPWORD_LIST = "StopwordList";

    //---------------------------------- Record Types Creation ----------------------------------//
    //--------------------------------------- Properties ----------------------------------------//
    public static final int PROPERTIES_NAME_FIELD_INDEX = 0;
    public static final String PROPERTIES_NAME_FIELD_NAME = "name";
    public static final int PROPERTIES_VALUE_FIELD_INDEX = 1;
    public static final String PROPERTIES_VALUE_FIELD_NAME = "value";
    public static final ARecordType POLICY_PARAMS_RECORDTYPE = createPropertiesRecordType();
    public static final ARecordType DATASOURCE_ADAPTER_PROPERTIES_RECORDTYPE = createPropertiesRecordType();
    public static final ARecordType COMPACTION_POLICY_PROPERTIES_RECORDTYPE = createPropertiesRecordType();
    public static final ARecordType DATASET_HINTS_RECORDTYPE = createPropertiesRecordType();
    public static final ARecordType FEED_ADAPTER_CONFIGURATION_RECORDTYPE = createPropertiesRecordType();

    //----------------------------- Internal Details Record Type --------------------------------//
    public static final int INTERNAL_DETAILS_ARECORD_FILESTRUCTURE_FIELD_INDEX = 0;
    public static final int INTERNAL_DETAILS_ARECORD_PARTITIONSTRATEGY_FIELD_INDEX = 1;
    public static final int INTERNAL_DETAILS_ARECORD_PARTITIONKEY_FIELD_INDEX = 2;
    public static final int INTERNAL_DETAILS_ARECORD_PRIMARYKEY_FIELD_INDEX = 3;
    public static final int INTERNAL_DETAILS_ARECORD_AUTOGENERATED_FIELD_INDEX = 4;
    public static final ARecordType INTERNAL_DETAILS_RECORDTYPE = createRecordType(
            // RecordTypeName
            null,
            // FieldNames
            new String[] { FIELD_NAME_FILE_STRUCTURE, FIELD_NAME_PARTITIONING_STRATEGY, FIELD_NAME_PARTITIONING_KEY,
                    FIELD_NAME_PRIMARY_KEY, FIELD_NAME_AUTOGENERATED },
            // FieldTypes
            new IAType[] { BuiltinType.ASTRING, BuiltinType.ASTRING,
                    new AOrderedListType(new AOrderedListType(BuiltinType.ASTRING, null), null),
                    new AOrderedListType(new AOrderedListType(BuiltinType.ASTRING, null), null), BuiltinType.ABOOLEAN },
            //IsOpen?
            true);

    //----------------------------- External Details Record Type --------------------------------//
    public static final int EXTERNAL_DETAILS_ARECORD_DATASOURCE_ADAPTER_FIELD_INDEX = 0;
    public static final int EXTERNAL_DETAILS_ARECORD_PROPERTIES_FIELD_INDEX = 1;
    public static final int EXTERNAL_DETAILS_ARECORD_LAST_REFRESH_TIME_FIELD_INDEX = 2;
    public static final int EXTERNAL_DETAILS_ARECORD_TRANSACTION_STATE_FIELD_INDEX = 3;
    public static final ARecordType EXTERNAL_DETAILS_RECORDTYPE = createRecordType(
            // RecordTypeName
            null,
            // FieldNames
            new String[] { FIELD_NAME_DATASOURCE_ADAPTER, FIELD_NAME_PROPERTIES, FIELD_NAME_LAST_REFRESH_TIME,
                    FIELD_NAME_TRANSACTION_STATE },
            // FieldTypes
            new IAType[] { BuiltinType.ASTRING, new AOrderedListType(DATASOURCE_ADAPTER_PROPERTIES_RECORDTYPE, null),
                    BuiltinType.ADATETIME, BuiltinType.AINT32 },
            //IsOpen?
            true);
    //---------------------------------------- Dataset ------------------------------------------//
    public static final String RECORD_NAME_DATASET = "DatasetRecordType";
    //Optional open fields
    public static final String DATASET_ARECORD_BLOCK_LEVEL_STORAGE_COMPRESSION_FIELD_NAME =
            "BlockLevelStorageCompression";
    public static final String DATASET_ARECORD_DATASET_COMPRESSION_SCHEME_FIELD_NAME = "DatasetCompressionScheme";
    public static final String DATASET_ARECORD_REBALANCE_FIELD_NAME = "rebalanceCount";
    public static final String DATASET_ARECORD_DATASET_FORMAT_FIELD_NAME = "DatasetFormat";
    public static final String DATASET_ARECORD_DATASET_FORMAT_FORMAT_FIELD_NAME = "Format";
    public static final String DATASET_ARECORD_DATASET_MAX_TUPLE_COUNT_FIELD_NAME = "MaxTupleCount";
    public static final String DATASET_ARECORD_DATASET_FREE_SPACE_TOLERANCE_FIELD_NAME = "FreeSpaceTolerance";
    public static final String DATASET_ARECORD_DATASET_MAX_LEAF_NODE_SIZE_FIELD_NAME = "MaxLeafNodeSize";

    //------------------------------------------ Field ------------------------------------------//
    public static final int FIELD_ARECORD_FIELDNAME_FIELD_INDEX = 0;
    public static final int FIELD_ARECORD_FIELDTYPE_FIELD_INDEX = 1;
    public static final int FIELD_ARECORD_ISNULLABLE_FIELD_INDEX = 2;
    public static final ARecordType FIELD_RECORDTYPE = createRecordType(
            // RecordTypeName
            null,
            // FieldNames
            new String[] { FIELD_NAME_FIELD_NAME, FIELD_NAME_FIELD_TYPE, FIELD_NAME_IS_NULLABLE },
            // FieldTypes
            new IAType[] { BuiltinType.ASTRING, BuiltinType.ASTRING, BuiltinType.ABOOLEAN },
            //IsOpen?
            true);
    //---------------------------------------- Record Type --------------------------------------//
    public static final int RECORDTYPE_ARECORD_ISOPEN_FIELD_INDEX = 0;
    public static final int RECORDTYPE_ARECORD_FIELDS_FIELD_INDEX = 1;
    public static final ARecordType RECORD_RECORDTYPE = createRecordType(
            // RecordTypeName
            null,
            // FieldNames
            new String[] { FIELD_NAME_IS_OPEN, FIELD_NAME_FIELDS },
            // FieldTypes
            new IAType[] { BuiltinType.ABOOLEAN, new AOrderedListType(FIELD_RECORDTYPE, null) },
            //IsOpen?
            true);

    //-------------------------------------- Derived Type ---------------------------------------//
    public static final int DERIVEDTYPE_ARECORD_TAG_FIELD_INDEX = 0;
    public static final int DERIVEDTYPE_ARECORD_ISANONYMOUS_FIELD_INDEX = 1;
    public static final int DERIVEDTYPE_ARECORD_RECORD_FIELD_INDEX = 2;
    public static final int DERIVEDTYPE_ARECORD_UNORDEREDLIST_FIELD_INDEX = 3;
    public static final int DERIVEDTYPE_ARECORD_ORDEREDLIST_FIELD_INDEX = 4;
    public static final ARecordType DERIVEDTYPE_RECORDTYPE = createRecordType(
            // RecordTypeName
            null,
            // FieldNames
            new String[] { FIELD_NAME_TAG, FIELD_NAME_IS_ANONYMOUS, FIELD_NAME_RECORD, FIELD_NAME_UNORDERED_LIST,
                    FIELD_NAME_ORDERED_LIST },
            // FieldTypes
            new IAType[] { BuiltinType.ASTRING, BuiltinType.ABOOLEAN,
                    AUnionType.createUnknownableType(RECORD_RECORDTYPE),
                    AUnionType.createUnknownableType(BuiltinType.ASTRING),
                    AUnionType.createUnknownableType(BuiltinType.ASTRING) },
            //IsOpen?
            true);
    //---------------------------------------- Data Type ----------------------------------------//
    public static final String RECORD_NAME_DATATYPE = "DatatypeRecordType";

    //-------------------------------------- Database ------------------------------------------//
    public static final String RECORD_NAME_DATABASE = "DatabaseRecordType";

    //-------------------------------------- Dataverse ------------------------------------------//
    public static final String RECORD_NAME_DATAVERSE = "DataverseRecordType";

    //-------------------------------------------- Index ----------------------------------------//
    public static final String RECORD_NAME_INDEX = "IndexRecordType";

    //----------------------------------------- Node --------------------------------------------//
    public static final String RECORD_NAME_NODE = "NodeRecordType";

    //--------------------------------------- Node Group ----------------------------------------//
    public static final String RECORD_NAME_NODE_GROUP = "NodeGroupRecordType";

    //----------------------------------------- Function ----------------------------------------//
    public static final String RECORD_NAME_FUNCTION = "FunctionRecordType";
    //open types
    public static final String FUNCTION_ARECORD_FUNCTION_RESOURCES_FIELD_NAME = "Resources";
    public static final String FUNCTION_ARECORD_FUNCTION_NULLCALL_FIELD_NAME = "NullCall";
    public static final String FUNCTION_ARECORD_FUNCTION_DETERMINISTIC_FIELD_NAME = "Deterministic";
    public static final String FUNCTION_ARECORD_FUNCTION_PARAMTYPES_FIELD_NAME = "ParamTypes";
    public static final String FUNCTION_ARECORD_FUNCTION_EXTERNAL_IDENTIFIER_FIELD_NAME = "ExternalIdentifier";
    @Deprecated // back-compat
    public static final String FUNCTION_ARECORD_FUNCTION_LIBRARY_FIELD_NAME = "Library";
    @Deprecated // back-compat
    public static final String FUNCTION_ARECORD_FUNCTION_WITHPARAMS_FIELD_NAME = "WithParams";

    //------------------------------------------ Adapter ----------------------------------------//
    public static final String RECORD_NAME_DATASOURCE_ADAPTER = "DatasourceAdapterRecordType";

    //---------------------------------------- Feed Details ------------------------------------//
    public static final String RECORD_NAME_FEED = "FeedRecordType";

    //------------------------------------- Feed Connection ---------------------------------------//
    public static final String RECORD_NAME_FEED_CONNECTION = "FeedConnectionRecordType";

    //------------------------------------- Feed Policy ---------------------------------------//
    public static final String RECORD_NAME_FEED_POLICY = "FeedPolicyRecordType";

    //---------------------------------------- Library ------------------------------------------//
    public static final String RECORD_NAME_LIBRARY = "LibraryRecordType";

    //------------------------------------- Compaction Policy -----------------------------------//
    public static final String RECORD_NAME_COMPACTION_POLICY = "CompactionPolicyRecordType";

    //-------------------------------------- ExternalFile ---------------------------------------//
    public static final String RECORD_NAME_EXTERNAL_FILE = "ExternalFileRecordType";

    //-------------------------------------- Synonym ---------------------------------------//
    public static final String RECORD_NAME_SYNONYM = "SynonymRecordType";

    //---------------------------------- FullText Config and Filter -------------------------//
    public static final String RECORD_NAME_FULL_TEXT_CONFIG = "FullTextConfigRecordType";
    public static final String RECORD_NAME_FULL_TEXT_FILTER = "FullTextFilterRecordType";

    // private members
    private MetadataRecordTypes() {
    }

    public static ARecordType createRecordType(String recordTypeName, String[] fieldNames, IAType[] fieldTypes,
            boolean isOpen) {
        ARecordType recordType = new ARecordType(recordTypeName, fieldNames, fieldTypes, isOpen);
        if (recordTypeName != null) {
            recordType.generateNestedDerivedTypeNames();
        }
        return recordType;
    }

    public static ARecordType createPropertiesRecordType() {
        return createRecordType(
                // RecordTypeName
                null,
                // FieldNames
                new String[] { FIELD_NAME_NAME, FIELD_NAME_VALUE },
                // FieldTypes
                new IAType[] { BuiltinType.ASTRING, BuiltinType.ASTRING },
                //IsOpen? Seriously?
                true);
    }
}
