/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.UserAgentUtil;
import reactor.core.publisher.Mono;

public class UserAgentPolicy
implements HttpPipelinePolicy {
    private static final String USER_AGENT = "User-Agent";
    public static final String OVERRIDE_USER_AGENT_CONTEXT_KEY = "Override-User-Agent";
    public static final String APPEND_USER_AGENT_CONTEXT_KEY = "Append-User-Agent";
    private final String userAgent;

    public UserAgentPolicy() {
        this(null);
    }

    public UserAgentPolicy(String userAgent) {
        this.userAgent = userAgent != null ? userAgent : "azsdk-java";
    }

    public UserAgentPolicy(String applicationId, String sdkName, String sdkVersion, Configuration configuration) {
        this.userAgent = UserAgentUtil.toUserAgentString(applicationId, sdkName, sdkVersion, configuration);
    }

    @Deprecated
    public UserAgentPolicy(String sdkName, String sdkVersion, Configuration configuration, ServiceVersion version) {
        this.userAgent = UserAgentUtil.toUserAgentString(null, sdkName, sdkVersion, configuration);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String overrideUserAgent = context.getData(OVERRIDE_USER_AGENT_CONTEXT_KEY).orElse(null);
        String appendUserAgent = context.getData(APPEND_USER_AGENT_CONTEXT_KEY).orElse(null);
        String userAgentValue = !CoreUtils.isNullOrEmpty(overrideUserAgent) ? overrideUserAgent : (!CoreUtils.isNullOrEmpty(appendUserAgent) ? this.userAgent + " " + appendUserAgent : this.userAgent);
        context.getHttpRequest().getHeaders().set(USER_AGENT, userAgentValue);
        return next.process();
    }
}

