/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.pushdown.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.optimizer.rules.pushdown.schema.AbstractComplexExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.ExpectedSchemaNodeType;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNode;
import org.apache.asterix.optimizer.rules.pushdown.schema.IExpectedSchemaNodeVisitor;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ObjectExpectedSchemaNode
extends AbstractComplexExpectedSchemaNode {
    private final Map<String, IExpectedSchemaNode> children = new HashMap<String, IExpectedSchemaNode>();

    ObjectExpectedSchemaNode(AbstractComplexExpectedSchemaNode parent, SourceLocation sourceLocation, String functionName) {
        super(parent, sourceLocation, functionName);
    }

    public Set<Map.Entry<String, IExpectedSchemaNode>> getChildren() {
        return this.children.entrySet();
    }

    public IExpectedSchemaNode addChild(String fieldName, IExpectedSchemaNode child) {
        this.children.put(fieldName, child);
        return child;
    }

    @Override
    public ExpectedSchemaNodeType getType() {
        return ExpectedSchemaNodeType.OBJECT;
    }

    @Override
    public <R, T> R accept(IExpectedSchemaNodeVisitor<R, T> visitor, T arg) {
        return visitor.visit(this, arg);
    }

    @Override
    public void replaceChild(IExpectedSchemaNode oldNode, IExpectedSchemaNode newNode) {
        String key = null;
        for (Map.Entry<String, IExpectedSchemaNode> child : this.children.entrySet()) {
            if (child.getValue() != oldNode) continue;
            key = child.getKey();
            break;
        }
        if (key == null) {
            throw new IllegalStateException("Node " + oldNode.getType() + " is not a child");
        }
        this.children.replace(key, newNode);
    }
}

