/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractExpression;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.struct.OperatorType;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public class OperatorExpr
extends AbstractExpression {
    private List<Expression> exprList;
    private List<OperatorType> opList;
    private boolean currentop;

    public OperatorExpr() {
        this.exprList = new ArrayList<Expression>();
        this.opList = new ArrayList<OperatorType>();
    }

    public OperatorExpr(List<Expression> exprList, List<OperatorType> opList, boolean currentop) {
        this.exprList = exprList;
        this.opList = opList;
        this.currentop = currentop;
    }

    public boolean isCurrentop() {
        return this.currentop;
    }

    public void setCurrentop(boolean currentop) {
        this.currentop = currentop;
    }

    public List<Expression> getExprList() {
        return this.exprList;
    }

    public List<OperatorType> getOpList() {
        return this.opList;
    }

    public void setExprList(List<Expression> exprList) {
        this.exprList = exprList;
    }

    public void addOperand(Expression operand) {
        this.exprList.add(operand);
    }

    public static boolean opIsComparison(OperatorType t) {
        switch (t) {
            case EQ: 
            case NEQ: 
            case GT: 
            case GE: 
            case LT: 
            case LE: 
            case DISTINCT: 
            case NOT_DISTINCT: {
                return true;
            }
        }
        return false;
    }

    public void addOperator(String strOp) throws CompilationException {
        OperatorType op = OperatorType.fromSymbol(strOp);
        if (op == null) {
            throw new CompilationException("Unsupported operator: " + strOp);
        }
        this.addOperator(op);
    }

    public void addOperator(OperatorType op) {
        if (op == null) {
            throw new NullPointerException();
        }
        this.opList.add(op);
    }

    @Override
    public Expression.Kind getKind() {
        return Expression.Kind.OP_EXPRESSION;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public int hashCode() {
        return Objects.hash(this.currentop, this.exprList, this.opList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OperatorExpr)) {
            return false;
        }
        OperatorExpr target = (OperatorExpr)object;
        return this.currentop == target.isCurrentop() && Objects.equals(this.exprList, target.exprList) && Objects.equals(this.opList, target.opList);
    }
}

