/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers.json.losslessadm;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.printers.PrintTools;
import org.apache.asterix.dataflow.data.nontagged.printers.json.losslessadm.ATaggedValuePrinter;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.string.UTF8StringUtil;

public class AStringPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    public static final AStringPrinterFactory INSTANCE = new AStringPrinterFactory();
    public static final IPrinter PRINTER = (b, s, l, ps) -> {
        try {
            int utfLength = UTF8StringUtil.getUTFLength((byte[])b, (int)(s + 1));
            ps.print('\"');
            if (utfLength > 0) {
                ATaggedValuePrinter.printDelimiter(ps);
                PrintTools.writeUTF8StringAsJSONUnquoted(b, s + 1, l - 1, utfLength, ps);
            }
            ps.print('\"');
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    };

    public IPrinter createPrinter() {
        return PRINTER;
    }
}

