/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;
import reactor.core.publisher.Mono;

public class MetadataValidationPolicy
implements HttpPipelinePolicy {
    private final ClientLogger logger = new ClientLogger(MetadataValidationPolicy.class);

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        try {
            context.getHttpRequest().getHeaders().stream().filter(header -> header.getName().toLowerCase(Locale.ROOT).startsWith("x-ms-meta")).forEach(header -> {
                boolean foundWhitespace;
                boolean bl = foundWhitespace = Character.isWhitespace(header.getName().charAt("x-ms-meta".length())) || Character.isWhitespace(header.getName().charAt(header.getName().length() - 1)) || Character.isWhitespace(header.getValue().charAt(0)) || Character.isWhitespace(header.getValue().charAt(header.getValue().length() - 1));
                if (foundWhitespace) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Metadata keys and values can not contain leading or trailing whitespace. Please remove or encode them."));
                }
            });
        }
        catch (IllegalArgumentException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
        return next.process();
    }
}

