/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.noop.NoopMeter;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import reactor.netty.Metrics;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.MeterKey;
import reactor.util.annotation.Nullable;

public class MicrometerChannelMetricsRecorder
implements ChannelMetricsRecorder {
    final DistributionSummary.Builder dataReceivedBuilder;
    final ConcurrentMap<String, DistributionSummary> dataReceivedCache = new ConcurrentHashMap<String, DistributionSummary>();
    final DistributionSummary.Builder dataSentBuilder;
    final ConcurrentMap<String, DistributionSummary> dataSentCache = new ConcurrentHashMap<String, DistributionSummary>();
    final Counter.Builder errorCountBuilder;
    final ConcurrentMap<String, Counter> errorsCache = new ConcurrentHashMap<String, Counter>();
    final Timer.Builder connectTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> connectTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final Timer.Builder tlsHandshakeTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> tlsHandshakeTimeCache = new ConcurrentHashMap<MeterKey, Timer>();
    final Timer.Builder addressResolverTimeBuilder;
    final ConcurrentMap<MeterKey, Timer> addressResolverTimeCache = new ConcurrentHashMap<MeterKey, Timer>();

    public MicrometerChannelMetricsRecorder(String name, String protocol) {
        this.dataReceivedBuilder = DistributionSummary.builder((String)(name + ".data.received")).baseUnit("bytes").description("Amount of the data received, in bytes").tag("uri", protocol);
        this.dataSentBuilder = DistributionSummary.builder((String)(name + ".data.sent")).baseUnit("bytes").description("Amount of the data sent, in bytes").tag("uri", protocol);
        this.errorCountBuilder = Counter.builder((String)(name + ".errors")).description("Number of errors that occurred").tag("uri", protocol);
        this.connectTimeBuilder = Timer.builder((String)(name + ".connect.time")).description("Time spent for connecting to the remote address");
        this.tlsHandshakeTimeBuilder = Timer.builder((String)(name + ".tls.handshake.time")).description("Time spent for TLS handshake");
        this.addressResolverTimeBuilder = Timer.builder((String)(name + ".address.resolver")).description("Time spent for resolving the address");
    }

    @Override
    public void recordDataReceived(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = this.dataReceivedCache.computeIfAbsent(address, key -> MicrometerChannelMetricsRecorder.filter(this.dataReceivedBuilder.tag("remote.address", address).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void recordDataSent(SocketAddress remoteAddress, long bytes) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        DistributionSummary ds = this.dataSentCache.computeIfAbsent(address, key -> MicrometerChannelMetricsRecorder.filter(this.dataSentBuilder.tag("remote.address", address).register(Metrics.REGISTRY)));
        if (ds != null) {
            ds.record((double)bytes);
        }
    }

    @Override
    public void incrementErrorsCount(SocketAddress remoteAddress) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Counter c = this.errorsCache.computeIfAbsent(address, key -> MicrometerChannelMetricsRecorder.filter(this.errorCountBuilder.tag("remote.address", address).register(Metrics.REGISTRY)));
        if (c != null) {
            c.increment();
        }
    }

    @Override
    public void recordTlsHandshakeTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.tlsHandshakeTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> MicrometerChannelMetricsRecorder.filter(this.tlsHandshakeTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordConnectTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.connectTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> MicrometerChannelMetricsRecorder.filter(this.connectTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Override
    public void recordResolveAddressTime(SocketAddress remoteAddress, Duration time, String status) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer timer = this.addressResolverTimeCache.computeIfAbsent(new MeterKey(null, address, null, status), key -> MicrometerChannelMetricsRecorder.filter(this.addressResolverTimeBuilder.tags(new String[]{"remote.address", address, "status", status}).register(Metrics.REGISTRY)));
        if (timer != null) {
            timer.record(time);
        }
    }

    @Nullable
    protected static <M extends Meter> M filter(M meter) {
        if (meter instanceof NoopMeter) {
            return null;
        }
        return meter;
    }
}

