/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Literal;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateWithConditionClause;
import org.apache.asterix.lang.sqlpp.optype.JoinType;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class JoinClause
extends AbstractBinaryCorrelateWithConditionClause {
    private final JoinType joinType;
    private Literal.Type outerJoinMissingValueType;

    public JoinClause(JoinType joinType, Expression rightExpr, VariableExpr rightVar, VariableExpr rightPosVar, Expression conditionExpr, Literal.Type outerJoinMissingValueType) {
        super(rightExpr, rightVar, rightPosVar, conditionExpr);
        this.joinType = joinType;
        this.setOuterJoinMissingValueType(outerJoinMissingValueType);
    }

    public Literal.Type getOuterJoinMissingValueType() {
        return this.outerJoinMissingValueType;
    }

    public void setOuterJoinMissingValueType(Literal.Type outerJoinMissingValueType) {
        this.outerJoinMissingValueType = JoinClause.validateMissingValueType(this.joinType, outerJoinMissingValueType);
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.JOIN_CLAUSE;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + 31 * this.joinType.hashCode() + (this.outerJoinMissingValueType != null ? this.outerJoinMissingValueType.hashCode() : 0);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JoinClause)) {
            return false;
        }
        JoinClause target = (JoinClause)((Object)object);
        return super.equals((Object)target) && this.joinType.equals((Object)target.getJoinType()) && Objects.equals(this.outerJoinMissingValueType, target.outerJoinMissingValueType);
    }

    private static Literal.Type validateMissingValueType(JoinType joinType, Literal.Type missingValueType) {
        switch (joinType) {
            case INNER: {
                if (missingValueType != null) {
                    throw new IllegalArgumentException(String.valueOf(missingValueType));
                }
                return null;
            }
            case LEFTOUTER: 
            case RIGHTOUTER: {
                switch (Objects.requireNonNull(missingValueType)) {
                    case MISSING: 
                    case NULL: {
                        return missingValueType;
                    }
                }
                throw new IllegalArgumentException(String.valueOf(missingValueType));
            }
        }
        throw new IllegalStateException(String.valueOf((Object)joinType));
    }
}

