/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.orca;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.BindableService;
import io.grpc.ServerServiceDefinition;
import io.grpc.SynchronizationContext;
import io.grpc.services.InternalMetricRecorder;
import io.grpc.services.MetricRecorder;
import io.grpc.services.MetricReport;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OpenRcaServiceGrpc;
import io.grpc.xds.shaded.com.github.xds.service.orca.v3.OrcaLoadReportRequest;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OrcaServiceImpl
implements BindableService {
    private static final Logger logger = Logger.getLogger(OrcaServiceImpl.class.getName());
    public static final long DEFAULT_MIN_REPORT_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final long minReportIntervalNanos;
    private final ScheduledExecutorService timeService;
    @VisibleForTesting
    final AtomicInteger clientCount = new AtomicInteger(0);
    private MetricRecorder metricRecorder;
    private final RealOrcaServiceImpl delegate = new RealOrcaServiceImpl();

    public static BindableService createService(ScheduledExecutorService timeService, MetricRecorder metricsRecorder, long minInterval, TimeUnit timeUnit) {
        return new OrcaServiceImpl(minInterval, timeUnit, timeService, metricsRecorder);
    }

    public static BindableService createService(ScheduledExecutorService timeService, MetricRecorder metricRecorder) {
        return new OrcaServiceImpl(DEFAULT_MIN_REPORT_INTERVAL_NANOS, TimeUnit.NANOSECONDS, timeService, metricRecorder);
    }

    private OrcaServiceImpl(long minInterval, TimeUnit timeUnit, ScheduledExecutorService timeService, MetricRecorder orcaMetrics) {
        this.minReportIntervalNanos = minInterval > 0L ? timeUnit.toNanos(minInterval) : DEFAULT_MIN_REPORT_INTERVAL_NANOS;
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.metricRecorder = (MetricRecorder)Preconditions.checkNotNull((Object)orcaMetrics, (Object)"orcaMetrics");
    }

    public ServerServiceDefinition bindService() {
        return this.delegate.bindService();
    }

    private OrcaLoadReport generateMetricsReport() {
        MetricReport internalReport = InternalMetricRecorder.getMetricReport((MetricRecorder)this.metricRecorder);
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setApplicationUtilization(internalReport.getApplicationUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).setRpsFractional(internalReport.getQps()).setEps(internalReport.getEps()).putAllUtilization(internalReport.getUtilizationMetrics()).build();
    }

    private final class OrcaClient
    implements Runnable {
        final ServerCallStreamObserver<OrcaLoadReport> responseObserver;
        SynchronizationContext.ScheduledHandle periodicReportTimer;
        final long reportIntervalNanos;
        final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "Exception!" + e);
            }
        });

        OrcaClient(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
            this.reportIntervalNanos = Math.max(Durations.toNanos((Duration)((OrcaLoadReportRequest)Preconditions.checkNotNull((Object)request)).getReportInterval()), OrcaServiceImpl.this.minReportIntervalNanos);
            this.responseObserver = (ServerCallStreamObserver)responseObserver;
            this.responseObserver.setOnCancelHandler(new Runnable(){

                @Override
                public void run() {
                    OrcaClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaClient.this.periodicReportTimer != null) {
                                OrcaClient.this.periodicReportTimer.cancel();
                            }
                            OrcaServiceImpl.this.clientCount.getAndDecrement();
                        }
                    });
                }
            });
        }

        @Override
        public void run() {
            if (this.periodicReportTimer != null && this.periodicReportTimer.isPending()) {
                return;
            }
            OrcaLoadReport report = OrcaServiceImpl.this.generateMetricsReport();
            this.responseObserver.onNext((Object)report);
            this.periodicReportTimer = this.syncContext.schedule((Runnable)this, this.reportIntervalNanos, TimeUnit.NANOSECONDS, OrcaServiceImpl.this.timeService);
        }
    }

    private final class RealOrcaServiceImpl
    extends OpenRcaServiceGrpc.OpenRcaServiceImplBase {
        private RealOrcaServiceImpl() {
        }

        @Override
        public void streamCoreMetrics(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
            OrcaClient client = new OrcaClient(request, responseObserver);
            client.run();
            OrcaServiceImpl.this.clientCount.getAndIncrement();
        }
    }
}

