/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.api.IApplicationContext;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.IndexingScheduler;
import org.apache.asterix.external.indexing.RecordId;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.ParquetReadSupport;
import org.apache.asterix.external.input.stream.HDFSInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.runtime.projection.DataProjectionInfo;
import org.apache.asterix.runtime.projection.FunctionCallInformation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.application.ICCServiceContext;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.context.ICCContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.hdfs.scheduler.Scheduler;

public class HDFSUtils {
    private HDFSUtils() {
    }

    public static Scheduler initializeHDFSScheduler(ICCServiceContext serviceCtx) throws HyracksDataException {
        ICCContext ccContext = serviceCtx.getCCContext();
        INetworkSecurityManager networkSecurityManager = serviceCtx.getControllerService().getNetworkSecurityManager();
        Scheduler scheduler = null;
        try {
            scheduler = new Scheduler(ccContext.getClusterControllerInfo().getClientNetAddress(), ccContext.getClusterControllerInfo().getClientNetPort(), networkSecurityManager.getSocketChannelFactory());
        }
        catch (HyracksException e) {
            throw new RuntimeDataException(ErrorCode.UTIL_HDFS_UTILS_CANNOT_OBTAIN_HDFS_SCHEDULER, new Serializable[0]);
        }
        return scheduler;
    }

    public static IndexingScheduler initializeIndexingHDFSScheduler(ICCServiceContext serviceCtx) throws HyracksDataException {
        IndexingScheduler scheduler = null;
        try {
            ICcApplicationContext appCtx = (ICcApplicationContext)serviceCtx.getApplicationContext();
            IHyracksClientConnection hcc = appCtx.getHcc();
            scheduler = new IndexingScheduler(hcc.getNodeControllerInfos());
        }
        catch (HyracksException e) {
            throw new RuntimeDataException(ErrorCode.UTIL_HDFS_UTILS_CANNOT_OBTAIN_HDFS_SCHEDULER, new Serializable[0]);
        }
        return scheduler;
    }

    public static InputSplit[] getSplits(JobConf conf, List<ExternalFile> files) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        ArrayList<FileSplit> fileSplits = new ArrayList<FileSplit>();
        ArrayList<ExternalFile> orderedExternalFiles = new ArrayList<ExternalFile>();
        for (ExternalFile file : files) {
            BlockLocation[] fileBlocks;
            FileStatus fileStatus;
            Path filePath = new Path(file.getFileName());
            try {
                fileStatus = fs.getFileStatus(filePath);
            }
            catch (FileNotFoundException e) {
                continue;
            }
            if (file.getPendingOp() == DatasetConfig.ExternalFilePendingOp.ADD_OP && fileStatus.getModificationTime() == file.getLastModefiedTime().getTime()) {
                BlockLocation[] fileBlocks2;
                for (BlockLocation block : fileBlocks2 = fs.getFileBlockLocations(fileStatus, 0L, file.getSize())) {
                    if (block.getOffset() >= file.getSize()) continue;
                    fileSplits.add(new FileSplit(filePath, block.getOffset(), block.getLength() + block.getOffset() < file.getSize() ? block.getLength() : file.getSize() - block.getOffset(), block.getHosts()));
                    orderedExternalFiles.add(file);
                }
                continue;
            }
            if (file.getPendingOp() != DatasetConfig.ExternalFilePendingOp.NO_OP || fileStatus.getModificationTime() != file.getLastModefiedTime().getTime()) continue;
            long oldSize = 0L;
            long newSize = file.getSize();
            for (int i = 0; i < files.size(); ++i) {
                if (files.get(i).getFileName() != file.getFileName() || files.get(i).getSize() == file.getSize()) continue;
                newSize = files.get(i).getSize();
                oldSize = file.getSize();
                break;
            }
            for (BlockLocation block : fileBlocks = fs.getFileBlockLocations(fileStatus, 0L, newSize)) {
                if (block.getOffset() + block.getLength() <= oldSize || block.getOffset() >= newSize) continue;
                long startCut = block.getOffset() > oldSize ? 0L : oldSize - block.getOffset();
                long endCut = block.getOffset() + block.getLength() < newSize ? 0L : block.getOffset() + block.getLength() - newSize;
                long splitLength = block.getLength() - startCut - endCut;
                fileSplits.add(new FileSplit(filePath, block.getOffset() + startCut, splitLength, block.getHosts()));
                orderedExternalFiles.add(file);
            }
        }
        fs.close();
        files.clear();
        files.addAll(orderedExternalFiles);
        return (InputSplit[])fileSplits.toArray(new FileSplit[fileSplits.size()]);
    }

    public static String getInputFormatClassName(Map<String, String> configuration) {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": {
                return "org.apache.hadoop.mapred.TextInputFormat";
            }
            case "sequence-input-format": {
                return "org.apache.hadoop.mapred.SequenceFileInputFormat";
            }
            case "parquet-input-format": {
                return "org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat";
            }
        }
        return inputFormatParameter;
    }

    public static Class<?> getInputFormatClass(Map<String, String> configuration) throws ClassNotFoundException {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": {
                return TextInputFormat.class;
            }
            case "sequence-input-format": {
                return SequenceFileInputFormat.class;
            }
            case "parquet-input-format": {
                return MapredParquetInputFormat.class;
            }
        }
        return Class.forName(inputFormatParameter);
    }

    public static JobConf configureHDFSJobConf(Map<String, String> configuration) {
        JobConf conf = new JobConf();
        String localShortCircuitSocketPath = configuration.get("local-socket-path");
        String formatClassName = HDFSUtils.getInputFormatClassName(configuration);
        String url = configuration.get("hdfs");
        if (url != null && url.trim().startsWith("hdfs")) {
            conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
            conf.set("fs.defaultFS", url);
        }
        conf.set("mapred.input.dir", configuration.get("path").trim());
        conf.setClassLoader(HDFSInputStream.class.getClassLoader());
        conf.set("mapred.input.format.class", formatClassName);
        if (localShortCircuitSocketPath != null) {
            conf.set("dfs.client.read.shortcircuit", "true");
            conf.set("dfs.domain.socket.path", localShortCircuitSocketPath.trim());
        }
        if ("org.apache.asterix.external.input.record.reader.hdfs.parquet.MapredParquetInputFormat".equals(formatClassName)) {
            HDFSUtils.configureParquet(configuration, conf);
        }
        return conf;
    }

    private static void configureParquet(Map<String, String> configuration, JobConf conf) {
        conf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        String requestedValues = configuration.get("requested-fields");
        if (requestedValues == null) {
            requestedValues = DataProjectionInfo.ALL_FIELDS_TYPE.getTypeName();
        } else {
            conf.set("org.apache.asterix.function.info", configuration.get("org.apache.asterix.function.info"));
        }
        conf.set("requested-fields", requestedValues);
        conf.set("org.apache.asterix.parse-json-string", configuration.getOrDefault("parse-json-string", "true"));
        conf.set("org.apache.asterix.decimal-to-double", configuration.getOrDefault("decimal-to-double", "false"));
        conf.set("org.apache.asterix.timezone", configuration.getOrDefault("timezone", ""));
    }

    public static AlgebricksAbsolutePartitionConstraint getPartitionConstraints(IApplicationContext appCtx, AlgebricksAbsolutePartitionConstraint clusterLocations) {
        if (clusterLocations == null) {
            return ((ICcApplicationContext)appCtx).getClusterStateManager().getSortedClusterLocations();
        }
        return clusterLocations;
    }

    public static RecordId.RecordIdType getRecordIdType(Map<String, String> configuration) {
        String inputFormatParameter;
        switch (inputFormatParameter = configuration.get("input-format").trim()) {
            case "text-input-format": 
            case "sequence-input-format": {
                return RecordId.RecordIdType.OFFSET;
            }
        }
        return null;
    }

    public static ARecordType getExpectedType(Configuration configuration) throws IOException {
        String encoded = configuration.get("requested-fields", "");
        if (encoded.isEmpty() || encoded.equals(DataProjectionInfo.ALL_FIELDS_TYPE.getTypeName())) {
            return DataProjectionInfo.ALL_FIELDS_TYPE;
        }
        if (encoded.equals(DataProjectionInfo.EMPTY_TYPE.getTypeName())) {
            return DataProjectionInfo.EMPTY_TYPE;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] typeBytes = decoder.decode(encoded);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(typeBytes));
        return DataProjectionInfo.createTypeField((DataInput)dataInputStream);
    }

    public static void setFunctionCallInformationMap(Map<String, FunctionCallInformation> funcCallInfoMap, Configuration conf) throws IOException {
        String stringFunctionCallInfoMap = ExternalDataUtils.serializeFunctionCallInfoToString(funcCallInfoMap);
        conf.set("org.apache.asterix.function.info", stringFunctionCallInfoMap);
    }

    public static Map<String, FunctionCallInformation> getFunctionCallInformationMap(Configuration conf) throws IOException {
        String encoded = conf.get("org.apache.asterix.function.info", "");
        if (!encoded.isEmpty()) {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] functionCallInfoMapBytes = decoder.decode(encoded);
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(functionCallInfoMapBytes));
            return DataProjectionInfo.createFunctionCallInformationMap((DataInput)dataInputStream);
        }
        return null;
    }

    public static void setWarnings(List<Warning> warnings, Configuration conf) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        StringBuilder stringBuilder = new StringBuilder();
        Base64.Encoder encoder = Base64.getEncoder();
        for (int i = 0; i < warnings.size(); ++i) {
            Warning warning = warnings.get(i);
            warning.writeFields((DataOutput)dataOutputStream);
            stringBuilder.append(encoder.encodeToString(byteArrayOutputStream.toByteArray()));
            stringBuilder.append(',');
            byteArrayOutputStream.reset();
        }
        conf.set("org.apache.asterix.warnings.list", stringBuilder.toString());
    }

    public static void issueWarnings(IWarningCollector warningCollector, Configuration conf) throws IOException {
        String warnings = conf.get("org.apache.asterix.warnings.list", "");
        if (!warnings.isEmpty()) {
            String[] encodedWarnings = warnings.split(",");
            Base64.Decoder decoder = Base64.getDecoder();
            for (int i = 0; i < encodedWarnings.length; ++i) {
                byte[] warningBytes = decoder.decode(encodedWarnings[i]);
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(warningBytes));
                if (!warningCollector.shouldWarn()) continue;
                warningCollector.warn(Warning.create((DataInput)dataInputStream));
            }
            conf.unset("org.apache.asterix.warnings.list");
        }
    }

    public static void disableHadoopFileSystemCache(Configuration conf, String protocol) {
        conf.set(String.format("fs.%s.impl.disable.cache", protocol), "true");
    }

    public static boolean isEmpty(JobConf job) {
        return job.get("mapred.input.dir", "").isEmpty();
    }
}

