/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.IExternalLangIPCProto;
import org.apache.asterix.external.api.ILibraryEvaluator;
import org.apache.asterix.external.library.PythonLibraryEvaluatorFactory;
import org.apache.asterix.external.library.msgpack.MessageUnpackerToADM;
import org.apache.asterix.external.library.msgpack.MsgPackPointableVisitor;
import org.apache.asterix.external.util.ExternalDataConstants;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.om.functions.IExternalFunctionDescriptor;
import org.apache.asterix.om.pointables.PointableAllocator;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.Counter;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputPushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.TaggedValuePointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePackException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.core.buffer.ArrayBufferInput;
import org.msgpack.core.buffer.MessageBufferInput;

public final class ExternalAssignBatchRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private final int[] outColumns;
    private final IExternalFunctionDescriptor[] fnDescs;
    private final int[][] fnArgColumns;

    public ExternalAssignBatchRuntimeFactory(int[] outColumns, IExternalFunctionDescriptor[] fnDescs, int[][] fnArgColumns, int[] projectionList) {
        super(projectionList);
        this.outColumns = outColumns;
        this.fnDescs = fnDescs;
        this.fnArgColumns = fnArgColumns;
    }

    public AbstractOneInputOneOutputPushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) {
        final int[] projectionToOutColumns = new int[this.projectionList.length];
        for (int j = 0; j < this.projectionList.length; ++j) {
            projectionToOutColumns[j] = Arrays.binarySearch(this.outColumns, this.projectionList[j]);
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private ArrayBackedValueStorage outputWrapper;
            private List<ArrayBackedValueStorage> argHolders;
            ArrayTupleBuilder tupleBuilder;
            private List<Pair<Long, ILibraryEvaluator>> libraryEvaluators;
            private ATypeTag[][] nullCalls;
            private int[] numCalls;
            private VoidPointable ref;
            private MessageUnpacker unpacker;
            private ArrayBufferInput unpackerInput;
            private List<Pair<ByteBuffer, Counter>> batchResults;
            private MessageUnpackerToADM unpackerToADM;
            private PointableAllocator pointableAllocator;
            private MsgPackPointableVisitor pointableVisitor;
            private TaggedValuePointable anyPointer;

            public void open() throws HyracksDataException {
                int i;
                super.open();
                this.initAccessAppend(ctx);
                this.tupleBuilder = new ArrayTupleBuilder(ExternalAssignBatchRuntimeFactory.this.projectionList.length);
                this.tRef = new FrameTupleReference();
                this.ref = VoidPointable.FACTORY.createPointable();
                this.libraryEvaluators = new ArrayList<Pair<Long, ILibraryEvaluator>>();
                try {
                    PythonLibraryEvaluatorFactory evalFactory = new PythonLibraryEvaluatorFactory(ctx);
                    for (IExternalFunctionDescriptor fnDesc : ExternalAssignBatchRuntimeFactory.this.fnDescs) {
                        ILibraryEvaluator eval = evalFactory.getEvaluator(fnDesc.getFunctionInfo(), ExternalAssignBatchRuntimeFactory.this.sourceLoc);
                        long id = eval.initialize(fnDesc.getFunctionInfo());
                        this.libraryEvaluators.add((Pair<Long, ILibraryEvaluator>)new Pair((Object)id, (Object)eval));
                    }
                }
                catch (IOException | AsterixException e) {
                    throw RuntimeDataException.create((ErrorCode)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{e, ExternalAssignBatchRuntimeFactory.this.sourceLoc, e.getMessage()});
                }
                this.argHolders = new ArrayList<ArrayBackedValueStorage>(ExternalAssignBatchRuntimeFactory.this.fnArgColumns.length);
                for (i = 0; i < ExternalAssignBatchRuntimeFactory.this.fnArgColumns.length; ++i) {
                    this.argHolders.add(new ArrayBackedValueStorage());
                }
                this.outputWrapper = new ArrayBackedValueStorage();
                this.nullCalls = new ATypeTag[this.argHolders.size()][0];
                this.numCalls = new int[ExternalAssignBatchRuntimeFactory.this.fnArgColumns.length];
                this.batchResults = new ArrayList<Pair<ByteBuffer, Counter>>(this.argHolders.size());
                for (i = 0; i < this.argHolders.size(); ++i) {
                    this.batchResults.add((Pair<ByteBuffer, Counter>)new Pair((Object)ByteBuffer.allocate(ExternalDataConstants.DEFAULT_BUFFER_SIZE), (Object)new Counter(-1)));
                }
                this.unpackerInput = new ArrayBufferInput(new byte[0]);
                this.unpacker = MessagePack.newDefaultUnpacker((MessageBufferInput)this.unpackerInput);
                this.unpackerToADM = new MessageUnpackerToADM();
                this.pointableAllocator = new PointableAllocator();
                this.pointableVisitor = new MsgPackPointableVisitor();
                this.anyPointer = TaggedValuePointable.FACTORY.createPointable();
            }

            private void resetBuffers(int numTuples, int[] numCalls) {
                for (int func = 0; func < ExternalAssignBatchRuntimeFactory.this.fnArgColumns.length; ++func) {
                    this.argHolders.get(func).reset();
                    if (this.nullCalls[func].length < numTuples) {
                        this.nullCalls[func] = new ATypeTag[numTuples];
                    }
                    numCalls[func] = numTuples;
                    Arrays.fill(this.nullCalls[func], ATypeTag.TYPE);
                    for (Pair<ByteBuffer, Counter> batch : this.batchResults) {
                        ((ByteBuffer)batch.getFirst()).clear();
                        ((ByteBuffer)batch.getFirst()).position(0);
                        ((Counter)batch.getSecond()).set(-1);
                    }
                }
            }

            private ATypeTag handleNullMatrix(int func, int t, ATypeTag argumentPresence, ATypeTag argumentStatus) {
                if (this.nullCalls[func][t] == ATypeTag.TYPE && argumentPresence != ATypeTag.TYPE) {
                    if (argumentPresence == ATypeTag.NULL && argumentStatus != ATypeTag.MISSING) {
                        this.nullCalls[func][t] = argumentPresence;
                        return ATypeTag.NULL;
                    }
                    this.nullCalls[func][t] = argumentPresence;
                    return ATypeTag.MISSING;
                }
                return argumentPresence;
            }

            private void collectFunctionWarnings(List<Pair<ByteBuffer, Counter>> batchResults) throws IOException {
                for (Pair<ByteBuffer, Counter> result : batchResults) {
                    if (((Counter)result.getSecond()).get() <= -1) continue;
                    ByteBuffer resBuf = (ByteBuffer)result.getFirst();
                    this.unpackerInput.reset(resBuf.array(), resBuf.position() + resBuf.arrayOffset(), resBuf.remaining());
                    this.unpacker.reset((MessageBufferInput)this.unpackerInput);
                    try {
                        int numEntries = this.unpacker.unpackArrayHeader();
                        for (int j = 0; j < numEntries; ++j) {
                            if (!ctx.getWarningCollector().shouldWarn()) continue;
                            ctx.getWarningCollector().warn(Warning.of((SourceLocation)ExternalAssignBatchRuntimeFactory.this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{this.unpacker.unpackString().replace('\u0000', ' ')}));
                        }
                    }
                    catch (MessagePackException e) {
                        if (!ctx.getWarningCollector().shouldWarn()) continue;
                        ctx.getWarningCollector().warn(Warning.of((SourceLocation)ExternalAssignBatchRuntimeFactory.this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Error retrieving returned warnings from Python UDF"}));
                    }
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                this.tupleBuilder.reset();
                try {
                    int numTuples = this.tAccess.getTupleCount();
                    this.resetBuffers(numTuples, this.numCalls);
                    for (int t = 0; t < numTuples; ++t) {
                        for (int func = 0; func < ExternalAssignBatchRuntimeFactory.this.fnArgColumns.length; ++func) {
                            int colIdx;
                            this.tRef.reset((IFrameTupleAccessor)this.tAccess, t);
                            int[] cols = ExternalAssignBatchRuntimeFactory.this.fnArgColumns[func];
                            ATypeTag argumentStatus = ATypeTag.TYPE;
                            if (!ExternalAssignBatchRuntimeFactory.this.fnDescs[func].getFunctionInfo().getNullCall()) {
                                for (colIdx = 0; colIdx < cols.length; ++colIdx) {
                                    this.ref.set(buffer.array(), this.tRef.getFieldStart(cols[colIdx]), this.tRef.getFieldLength(cols[colIdx]));
                                    ATypeTag argumentPresence = ExternalDataUtils.peekArgument(ExternalAssignBatchRuntimeFactory.this.fnDescs[func].getArgumentTypes()[colIdx], (IValueReference)this.ref, this.anyPointer);
                                    argumentStatus = this.handleNullMatrix(func, t, argumentPresence, argumentStatus);
                                }
                            }
                            if (argumentStatus == ATypeTag.TYPE) {
                                if (cols.length > 0) {
                                    this.argHolders.get(func).getDataOutput().writeByte(-36);
                                    this.argHolders.get(func).getDataOutput().writeShort((short)cols.length);
                                }
                                for (colIdx = 0; colIdx < cols.length; ++colIdx) {
                                    this.ref.set(buffer.array(), this.tRef.getFieldStart(cols[colIdx]), this.tRef.getFieldLength(cols[colIdx]));
                                    IExternalLangIPCProto.visitValueRef(ExternalAssignBatchRuntimeFactory.this.fnDescs[func].getArgumentTypes()[colIdx], this.argHolders.get(func).getDataOutput(), (IValueReference)this.ref, this.pointableAllocator, this.pointableVisitor, ExternalAssignBatchRuntimeFactory.this.fnDescs[func].getFunctionInfo().getNullCall());
                                }
                            } else {
                                int n = func;
                                this.numCalls[n] = this.numCalls[n] - 1;
                            }
                            if (cols.length != 0) continue;
                            ExternalDataUtils.setVoidArgument(this.argHolders.get(func));
                        }
                    }
                    for (int argHolderIdx = 0; argHolderIdx < this.argHolders.size(); ++argHolderIdx) {
                        Pair<Long, ILibraryEvaluator> fnEval = this.libraryEvaluators.get(argHolderIdx);
                        ByteBuffer columnResult = ((ILibraryEvaluator)fnEval.getSecond()).callMulti((Long)fnEval.getFirst(), this.argHolders.get(argHolderIdx), this.numCalls[argHolderIdx]);
                        if (columnResult != null) {
                            Pair<ByteBuffer, Counter> resultholder = this.batchResults.get(argHolderIdx);
                            if (((ByteBuffer)resultholder.getFirst()).capacity() < columnResult.remaining()) {
                                ByteBuffer realloc = ctx.reallocateFrame((ByteBuffer)resultholder.getFirst(), ctx.getInitialFrameSize() * (columnResult.remaining() / ctx.getInitialFrameSize() + 1), false);
                                realloc.limit(columnResult.limit());
                                resultholder.setFirst((Object)realloc);
                            }
                            ByteBuffer resultBuf = (ByteBuffer)resultholder.getFirst();
                            System.arraycopy(columnResult.array(), 1, resultBuf.array(), 0, columnResult.remaining() - 1);
                            this.consumeAndGetBatchLength(resultBuf);
                            int numResults = (int)this.consumeAndGetBatchLength(resultBuf);
                            ((Counter)resultholder.getSecond()).set(numResults);
                            continue;
                        }
                        if (!ctx.getWarningCollector().shouldWarn()) continue;
                        ctx.getWarningCollector().warn(Warning.of((SourceLocation)ExternalAssignBatchRuntimeFactory.this.sourceLoc, (IError)ErrorCode.EXTERNAL_UDF_EXCEPTION, (Serializable[])new Serializable[]{"Function " + ExternalAssignBatchRuntimeFactory.this.fnDescs[argHolderIdx].getFunctionInfo().getFunctionIdentifier().toString() + " failed to execute"}));
                    }
                    for (int i = 0; i < numTuples; ++i) {
                        this.tupleBuilder.reset();
                        for (int f = 0; f < ExternalAssignBatchRuntimeFactory.this.projectionList.length; ++f) {
                            int k = projectionToOutColumns[f];
                            if (k >= 0) {
                                this.outputWrapper.reset();
                                Pair<ByteBuffer, Counter> result = this.batchResults.get(k);
                                ATypeTag functionCalled = this.nullCalls[k][i];
                                if (functionCalled == ATypeTag.TYPE) {
                                    if (((Counter)result.getSecond()).get() > 0) {
                                        this.unpackerToADM.unpack((ByteBuffer)result.getFirst(), this.outputWrapper.getDataOutput(), true);
                                        ((Counter)result.getSecond()).set(((Counter)result.getSecond()).get() - 1);
                                    } else {
                                        this.outputWrapper.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                                    }
                                } else if (functionCalled == ATypeTag.NULL) {
                                    this.outputWrapper.getDataOutput().writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
                                } else {
                                    this.outputWrapper.getDataOutput().writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
                                }
                                this.tupleBuilder.addField(this.outputWrapper.getByteArray(), 0, this.outputWrapper.getLength());
                                continue;
                            }
                            this.tupleBuilder.addField((IFrameTupleAccessor)this.tAccess, i, ExternalAssignBatchRuntimeFactory.this.projectionList[f]);
                        }
                        this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                    }
                    this.collectFunctionWarnings(this.batchResults);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
            }

            private long consumeAndGetBatchLength(ByteBuffer buf) {
                byte tag = buf.get();
                if (MessagePack.Code.isFixedArray((byte)tag)) {
                    return tag ^ 0xFFFFFF90;
                }
                if (tag == -36) {
                    return Short.toUnsignedInt(buf.getShort());
                }
                if (tag == -35) {
                    return Integer.toUnsignedLong(buf.getInt());
                }
                return -1L;
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }
}

