/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.partitions.PartitionId;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.cc.partitions.PartitionMatchMaker;
import org.apache.hyracks.control.cc.partitions.PartitionUtils;
import org.apache.hyracks.control.common.job.PartitionDescriptor;
import org.apache.hyracks.control.common.job.PartitionRequest;
import org.apache.hyracks.control.common.work.AbstractWork;

public class RegisterPartitionAvailibilityWork
extends AbstractWork {
    private final ClusterControllerService ccs;
    private final PartitionDescriptor partitionDescriptor;

    public RegisterPartitionAvailibilityWork(ClusterControllerService ccs, PartitionDescriptor partitionDescriptor) {
        this.ccs = ccs;
        this.partitionDescriptor = partitionDescriptor;
    }

    public void run() {
        PartitionId pid = this.partitionDescriptor.getPartitionId();
        IJobManager jobManager = this.ccs.getJobManager();
        JobRun run = jobManager.get(pid.getJobId());
        if (run == null) {
            return;
        }
        PartitionMatchMaker pmm = run.getPartitionMatchMaker();
        List<Pair<PartitionDescriptor, PartitionRequest>> matches = pmm.registerPartitionDescriptor(this.partitionDescriptor);
        for (Pair<PartitionDescriptor, PartitionRequest> match : matches) {
            try {
                PartitionUtils.reportPartitionMatch(this.ccs, pid, match);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return this.getName() + ": " + this.partitionDescriptor;
    }
}

